/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.effects.FlamesReborn;

import com.gametechbc.gametechbcsspellbooks.init.GSEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="gametechbcs_spellbooks")
public class FlamesRebornHandler {
    private static final Map<UUID, RecordedPosition> recordedPositions = new HashMap<UUID, RecordedPosition>();
    private static final Map<UUID, Integer> initialDurations = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.hasEffect(GSEffects.FLAMES_REBORN)) {
            event.setCanceled(true);
            entity.removeEffect(GSEffects.FLAMES_REBORN);
            FlamesRebornHandler.clearRecordedPosition(entity);
        }
    }

    public static void recordPosition(LivingEntity entity) {
        if (!entity.level().isClientSide) {
            Vec3 position = entity.position();
            ResourceKey dimension = entity.level().dimension();
            Vec3 lookDirection = entity.getLookAngle();
            float health = entity.getHealth();
            recordedPositions.put(entity.getUUID(), new RecordedPosition(position, (ResourceKey<Level>)dimension, lookDirection, health));
        }
    }

    public static void teleportEntityToRecordedPosition(LivingEntity entity) {
        Level level;
        RecordedPosition recordedPosition = recordedPositions.get(entity.getUUID());
        if (recordedPosition != null && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel currentLevel = (ServerLevel)level;
            ResourceKey<Level> targetDimension = recordedPosition.dimension;
            Vec3 targetPosition = recordedPosition.position;
            if (!currentLevel.dimension().equals(targetDimension)) {
                ServerLevel targetLevel = currentLevel.getServer().getLevel(targetDimension);
                if (targetLevel != null) {
                    DimensionTransition transition = new DimensionTransition(targetLevel, targetPosition, Vec3.ZERO, entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING);
                    entity.changeDimension(transition);
                } else {
                    System.err.println("Target dimension not found: " + String.valueOf(targetDimension.location()));
                    return;
                }
            }
            entity.teleportTo(targetPosition.x, targetPosition.y, targetPosition.z);
            entity.setYHeadRot((float)recordedPosition.lookDirection.y);
            entity.setHealth(recordedPosition.health);
        }
    }

    public static void clearRecordedPosition(LivingEntity entity) {
        recordedPositions.remove(entity.getUUID());
        initialDurations.remove(entity.getUUID());
    }

    public static RecordedPosition getRecordedPosition(UUID entityId) {
        return recordedPositions.get(entityId);
    }

    public static class RecordedPosition {
        final Vec3 position;
        final ResourceKey<Level> dimension;
        final Vec3 lookDirection;
        final float health;

        RecordedPosition(Vec3 position, ResourceKey<Level> dimension, Vec3 lookDirection, float health) {
            this.position = position;
            this.dimension = dimension;
            this.lookDirection = lookDirection;
            this.health = health;
        }
    }
}

