/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.spells.ender;

import com.gametechbc.gametechbcsspellbooks.init.GSEffects;
import com.gametechbc.gametechbcsspellbooks.init.GSSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class DisplacementSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("gametechbcs_spellbooks", "displacement");
    private static final Random RANDOM = new Random();
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(3).setCooldownSeconds(12.0).build();

    public DisplacementSpell() {
        this.baseManaCost = 15;
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)GSSounds.DISPLACEMENT.get());
    }

    public void onCast(Level level, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        float radius = this.getRadius(spellLevel, caster);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ENDER.get()).getTargetingColor(), radius), (double)caster.getX(), (double)(caster.getY() + (double)0.165f), (double)caster.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(10, caster.position(), radius));
        AABB area = new AABB(caster.blockPosition()).inflate((double)radius);
        List nearbyEntities = level.getEntities((Entity)caster, area, e -> e instanceof LivingEntity);
        for (Entity entity : nearbyEntities) {
            if (entity == caster || !(entity instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            this.emitRandomBodyParticles((ServerLevel)level, target, 50);
            Vec3 targetLookDirection = target.getLookAngle().scale(-1.0);
            Vec3 teleportCenter = target.position().add(targetLookDirection.scale(5.0));
            double randomXOffset = (level.random.nextDouble() - 0.5) * 7.0;
            double randomZOffset = (level.random.nextDouble() - 0.5) * 7.0;
            Vec3 teleportPosition = teleportCenter.add(randomXOffset, 0.0, randomZOffset);
            target.teleportTo(teleportPosition.x, teleportPosition.y, teleportPosition.z);
            this.emitRandomBodyParticles((ServerLevel)level, target, 50);
        }
        caster.addEffect(new MobEffectInstance(GSEffects.DISPLACEMENT, 20, (int)(radius / 2.0f), false, false, false));
        super.onCast(level, spellLevel, caster, castSource, playerMagicData);
    }

    private void emitRandomBodyParticles(ServerLevel serverLevel, LivingEntity entity, int count) {
        for (int i = 0; i < count; ++i) {
            double offsetX = (serverLevel.random.nextDouble() - 0.5) * (double)entity.getBbWidth();
            double offsetY = serverLevel.random.nextDouble() * (double)entity.getBbHeight();
            double offsetZ = (serverLevel.random.nextDouble() - 0.5) * (double)entity.getBbWidth();
            serverLevel.sendParticles(ParticleHelper.UNSTABLE_ENDER, entity.getX() + offsetX, entity.getY() + offsetY, entity.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private float getRadius(int spellLevel, LivingEntity caster) {
        return 2.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.0f;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.SELF_CAST_ANIMATION;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.gametechbcs_spellbooks.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getRadius(spellLevel, caster), (int)2)}), Component.literal((String)"\u00a79GTBC's Spellbooks"));
    }
}

