/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.spells.ice;

import com.gametechbc.gametechbcsspellbooks.init.GSSounds;
import com.gametechbc.gametechbcsspellbooks.particle.GSParticleHelper;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class ShatterpointSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("gametechbcs_spellbooks", "shatterpoint");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setMaxLevel(5).setCooldownSeconds(22.0).build();

    public ShatterpointSpell() {
        this.manaCostPerLevel = 40;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 30;
        this.baseManaCost = 50;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_SPIT_ANIMATION;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.WARDEN_SONIC_CHARGE);
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)GSSounds.SHATTERPOINT_CAST.get());
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Entity target;
        float damage = this.getDamage(spellLevel, entity);
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(10, entity.position(), 25.0f));
        HitResult hitResult = Utils.raycastForEntity((Level)level, (Entity)entity, (float)ShatterpointSpell.getRange(), (boolean)true, (float)0.25f);
        if (hitResult.getType() == HitResult.Type.ENTITY && (target = ((EntityHitResult)hitResult).getEntity()) instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            DamageSources.applyDamage((Entity)livingTarget, (float)damage, (DamageSource)this.getDamageSource((Entity)entity));
            AABB area = new AABB(target.blockPosition()).inflate(3.0);
            List nearbyEntities = level.getEntitiesOfClass(LivingEntity.class, area, e -> e != entity && e != livingTarget);
            for (LivingEntity nearby : nearbyEntities) {
                DamageSources.applyDamage((Entity)nearby, (float)damage, (DamageSource)this.getDamageSource((Entity)entity));
                MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.SNOWFLAKE, (double)nearby.getX(), (double)nearby.getY(), (double)nearby.getZ(), (int)40, (double)0.0, (double)0.0, (double)0.0, (double)0.3, (boolean)false);
            }
        }
        float distance = (float)hitResult.distanceTo((Entity)entity);
        Vec3 vec3 = entity.getLookAngle().normalize();
        int i = 0;
        while ((float)i < distance) {
            Vec3 vec32 = vec3.scale((double)i).add(entity.getEyePosition());
            MagicManager.spawnParticles((Level)level, (ParticleOptions)GSParticleHelper.FROST_BLAST, (double)vec32.x, (double)vec32.y, (double)vec32.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
            ++i;
        }
        MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.SNOW_DUST, (double)hitResult.getLocation().x, (double)hitResult.getLocation().y, (double)hitResult.getLocation().z, (int)50, (double)0.0, (double)0.0, (double)0.0, (double)0.2, (boolean)false);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public static float getRange() {
        return 30.0f;
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return 17.0f + this.getSpellPower(spellLevel, (Entity)caster) * 3.0f;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.gametechbcs_spellbooks.aoe_damage", (Object[])new Object[]{Float.valueOf(this.getDamage(spellLevel, caster))}), Component.translatable((String)"ui.gametechbcs_spellbooks.range", (Object[])new Object[]{Utils.stringTruncation((double)ShatterpointSpell.getRange(), (int)2)}), Component.literal((String)"\u00a79GTBC's Spellbooks"));
    }
}

