/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.type.BaseTrade;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public abstract class TradeProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final Map<EntityType<?>, EnumMap<TradeRarity, List<BaseTrade>>> trades = new HashMap();

    protected TradeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.pathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "goblin_trades");
        this.lookupProvider = lookupProvider;
    }

    protected abstract void registerTrades(HolderLookup.Provider var1);

    protected final void addTrade(EntityType<?> type, TradeRarity rarity, BaseTrade trade) {
        this.trades.putIfAbsent(type, new EnumMap(TradeRarity.class));
        this.trades.get(type).putIfAbsent(rarity, new ArrayList());
        this.trades.get(type).get((Object)rarity).add(trade);
    }

    public CompletableFuture<?> run(CachedOutput output) {
        return this.lookupProvider.thenCompose(provider -> {
            this.trades.clear();
            this.registerTrades((HolderLookup.Provider)provider);
            return CompletableFuture.allOf((CompletableFuture[])this.trades.entrySet().stream().map(e1 -> {
                EntityType type = (EntityType)e1.getKey();
                return CompletableFuture.allOf((CompletableFuture[])((EnumMap)e1.getValue()).entrySet().stream().map(e2 -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("replace", Boolean.valueOf(false));
                    JsonArray tradeArray = new JsonArray();
                    ((List)e2.getValue()).forEach(trade -> BaseTrade.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, trade).result().ifPresent(arg_0 -> ((JsonArray)tradeArray).add(arg_0)));
                    object.add("trades", (JsonElement)tradeArray);
                    ResourceLocation id = EntityType.getKey((EntityType)type);
                    Path path = this.pathProvider.json(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)(id.getPath() + "/" + ((TradeRarity)((Object)((Object)((Object)((Object)e2.getKey()))))).getKey())));
                    return DataProvider.saveStable((CachedOutput)output, (JsonElement)object, (Path)path);
                }).toArray(CompletableFuture[]::new));
            }).toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "Trades: goblintraders";
    }
}

