/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.effects;

import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.gametechbc.gtbcs_geomancy_plus.entity.extended.projectiles.ExtendedSunstrikeEntity;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import java.util.List;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SolarStormEffect
extends MagicMobEffect {
    private static final int RADIUS = 20;
    private static final int MAX_SPAWNS = 5;

    public SolarStormEffect() {
        super(MobEffectCategory.BENEFICIAL, 0);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.level().isClientSide) {
            Level level = entity.level();
            List<LivingEntity> validTargets = this.getValidTargets(level, entity, 20.0);
            int spawnCount = Math.min(validTargets.size(), 5);
            for (int i = 0; i < spawnCount; ++i) {
                LivingEntity target = validTargets.get(i);
                this.spawnSunstrike(level, entity, target, amplifier);
            }
        }
        return true;
    }

    private List<LivingEntity> getValidTargets(Level level, LivingEntity caster, double radius) {
        return level.getEntitiesOfClass(LivingEntity.class, caster.getBoundingBox().inflate(radius), target -> this.isValidTarget((LivingEntity)target, caster));
    }

    private void spawnSunstrike(Level level, LivingEntity caster, LivingEntity target, int amplifier) {
        ExtendedSunstrikeEntity sunstrike = new ExtendedSunstrikeEntity((EntityType<? extends EntitySunstrike>)((EntityType)GGEntities.EXTENDED_SUNSTRIKE.get()), level, caster, (int)target.getX(), (int)target.getY(), (int)target.getZ());
        sunstrike.setDamageFire(2.0f);
        sunstrike.setDamageMob(amplifier);
        level.addFreshEntity((Entity)sunstrike);
    }

    private boolean isValidTarget(LivingEntity target, LivingEntity caster) {
        return target != caster && !target.isAlliedTo((Entity)caster) && Utils.hasLineOfSight((Level)target.level(), (Entity)target, (Entity)caster, (boolean)false);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 60 == 0;
    }
}

