/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.effects;

import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TremorStepEffect
extends MobEffect {
    private static final int TREMOR_INTERVAL_TICKS = 8;

    public TremorStepEffect() {
        super(MobEffectCategory.BENEFICIAL, 9127187);
        this.addAttributeModifier(Attributes.MOVEMENT_SPEED, ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"tremor_step_speed"), 0.025, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        Player player;
        if (!livingEntity.level().isClientSide && livingEntity instanceof Player && (player = (Player)livingEntity).isSprinting() && player.tickCount % 8 == 0) {
            this.triggerTremorShockwave(player, amplifier);
        }
        return true;
    }

    private void triggerTremorShockwave(Player player, int amplifier) {
        Level level = player.level();
        double radius = 5.5;
        AABB boundingBox = new AABB(player.getX() - radius, player.getY() - radius, player.getZ() - radius, player.getX() + radius, player.getY() + radius, player.getZ() + radius);
        List nearbyEntities = level.getEntitiesOfClass(LivingEntity.class, boundingBox, entity -> entity != player && (double)entity.distanceTo((Entity)player) <= radius);
        for (LivingEntity target : nearbyEntities) {
            if (!((float)amplifier > 0.0f)) continue;
            DamageSources.applyDamage((Entity)target, (float)amplifier, (DamageSource)GGSpells.TREMOR_STEP_SPELL.get().getDamageSource((Entity)player, (Entity)player));
            target.invulnerableTime = 0;
        }
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(GGSchools.GEO.get().getTargetingColor(), (float)radius), (double)player.getX(), (double)(player.getY() + (double)0.165f), (double)player.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
        this.spawnBlockDiggingParticles(level, player, radius);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundRegistry.EARTHQUAKE_IMPACT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void spawnBlockDiggingParticles(Level level, Player player, double radius) {
        RandomSource random = level.getRandom();
        int particleCount = 35;
        block0: for (int i = 0; i < particleCount; ++i) {
            double angle = random.nextDouble() * Math.PI * 2.0;
            double distance = random.nextDouble() * radius;
            double x = player.getX() + Math.cos(angle) * distance;
            double z = player.getZ() + Math.sin(angle) * distance;
            double y = player.getY();
            BlockPos groundPos = new BlockPos((int)x, (int)y, (int)z);
            for (int j = 0; j < 3; ++j) {
                BlockPos checkPos = groundPos.below(j);
                BlockState groundBlock = level.getBlockState(checkPos);
                if (groundBlock.isAir() || groundBlock.getRenderShape() == RenderShape.INVISIBLE) continue;
                double particleX = x + (random.nextDouble() * 2.0 - 1.0) * 0.5;
                double particleY = (double)checkPos.getY() + 1.03;
                double particleZ = z + (random.nextDouble() * 2.0 - 1.0) * 0.5;
                double velocityX = random.nextGaussian() * 0.07;
                double velocityY = Math.abs(random.nextGaussian() * 0.1);
                double velocityZ = random.nextGaussian() * 0.07;
                MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, groundBlock), (double)particleX, (double)particleY, (double)particleZ, (int)1, (double)velocityX, (double)velocityY, (double)velocityZ, (double)0.03, (boolean)false);
                continue block0;
            }
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

