/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.extended.projectiles;

import com.bobmowzie.mowziesmobs.client.particle.AdvancedTerrainParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityEarthSpike;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import io.redspace.ironsspellbooks.damage.DamageSources;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ExtendedEntityEarthSpike
extends EntityEarthSpike {
    private double customDamage = 10.0;
    private boolean customEmerged = false;
    private int customDamageDelay = -1;

    public ExtendedEntityEarthSpike(EntityType<? extends EntityEarthSpike> type, Level world) {
        super(type, world);
    }

    public ExtendedEntityEarthSpike(EntityType<? extends EntityEarthSpike> type, Level worldIn, LivingEntity caster, BlockState blockState) {
        super(type, worldIn, caster, blockState);
    }

    public double getDamage() {
        return this.customDamage;
    }

    public void setDamage(double damage) {
        this.customDamage = damage;
    }

    public void tick() {
        this.baseTick();
        if (this.customDamageDelay >= 0) {
            --this.customDamageDelay;
        }
        if (!this.customEmerged) {
            this.customEmerged = true;
            this.customDamageDelay = 2;
            this.playSound((SoundEvent)MMSounds.ENTITY_BLUFF_SPIKE_EMERGE.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            if (this.level().isClientSide()) {
                for (int i = 0; i < 30; ++i) {
                    Vec3 offset = new Vec3(0.6 + (double)this.random.nextFloat() * 0.2, 0.1, 0.0).yRot(this.random.nextFloat() * (float)Math.PI * 2.0f);
                    Vec3 vel = offset.normalize().scale(this.random.nextGaussian() * 0.12).yRot(this.random.nextFloat() * 0.2f - 0.1f).add(0.0, this.random.nextDouble() * 0.45 + 0.2, 0.0).add(this.getForward().scale(0.1));
                    AdvancedTerrainParticle.spawnTerrainParticle((Level)this.level(), (Holder)ParticleHandler.TERRAIN, (double)(this.getX() + offset.x), (double)this.getY(), (double)(this.getZ() + offset.z), (double)vel.x, (double)vel.y, (double)vel.z, (double)0.0, (double)((double)0.4f + this.random.nextGaussian() * 0.3), (double)0.94f, (double)(25.0f + this.random.nextFloat() * 10.0f), (BlockState)this.getBlock(), (ParticleComponent[])new ParticleComponent[]{new ParticleComponent.Gravity(1.0f)});
                }
            }
        }
        if (this.customDamageDelay == 0 && !this.level().isClientSide()) {
            this.customDamageDelay = -1;
            List entitiesHit = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.4), e -> e.canBeHitByProjectile() && e != this.getCaster());
            for (Entity entity : entitiesHit) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                DamageSources.applyDamage((Entity)livingEntity, (float)((float)this.getDamage()), (DamageSource)GGSpells.FISSURE_SPELL.get().getDamageSource((Entity)this, (Entity)this.getCaster()));
                float applyKnockbackResistance = (float)livingEntity.getAttribute(Attributes.KNOCKBACK_RESISTANCE).getValue();
                double y = 0.0;
                if (entity.onGround()) {
                    y += 0.15 * (double)(1.0f - applyKnockbackResistance);
                }
                entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, y, 0.0));
                if (!(entity instanceof ServerPlayer)) continue;
                ((ServerPlayer)entity).connection.send((Packet)new ClientboundSetEntityMotionPacket(entity));
            }
        }
        if (this.tickCount > 200) {
            this.discard();
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.customDamage = compound.getDouble("customDamage");
        this.customEmerged = compound.getBoolean("customEmerged");
        this.customDamageDelay = compound.getInt("customDamageDelay");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putDouble("customDamage", this.customDamage);
        compound.putBoolean("customEmerged", this.customEmerged);
        compound.putInt("customDamageDelay", this.customDamageDelay);
    }
}

