/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.extended.projectiles;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.client.particle.AdvancedTerrainParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.sound.IGeomancyRumbler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.bluff.EntityBluff;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityEarthSpike;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityFissure;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityFissurePiece;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.gametechbc.gtbcs_geomancy_plus.entity.extended.projectiles.ExtendedEntityEarthSpike;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ExtendedEntityFissure
extends EntityFissure {
    private double spikeDamage = 10.0;
    private int customDespawnTimer = 0;

    public ExtendedEntityFissure(EntityType<? extends EntityFissure> type, Level worldIn) {
        super(type, worldIn);
    }

    public double getSpikeDamage() {
        return this.spikeDamage;
    }

    public void setSpikeDamage(double damage) {
        this.spikeDamage = damage;
    }

    private void customSpikeSpawn() {
        if (this.isTravelling()) {
            if (!this.level().isClientSide()) {
                BlockState state = this.level().getBlockState(this.getOnPos());
                if (!EffectGeomancy.isBlockUseable((BlockState)state)) {
                    state = Blocks.DIRT.defaultBlockState();
                }
                ExtendedEntityEarthSpike spike = new ExtendedEntityEarthSpike((EntityType<? extends EntityEarthSpike>)((EntityType)EntityHandler.EARTH_SPIKE.get()), this.level(), (LivingEntity)this.getOwner(), state);
                spike.setPos(this.position());
                spike.setYRot(this.getYRot());
                spike.setDamage(this.spikeDamage);
                this.level().addFreshEntity((Entity)spike);
            }
            this.setTravelling(false);
            this.customDespawnTimer = 180;
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
    }

    public void tick() {
        this.baseTick();
        if (this.isTravelling()) {
            this.stepForwardTrace();
            if (this.tickCount > 60 && this.isTravelling()) {
                this.customSpikeSpawn();
            }
            if (this.customDespawnTimer > 0) {
                --this.customDespawnTimer;
                if (this.customDespawnTimer == 1) {
                    this.discard();
                }
            }
            if (!this.level().isClientSide()) {
                if (this.isTravelling() && (float)(this.tickCount % TICKS_PER_PIECE) == 1.0f) {
                    EntityFissurePiece piece = new EntityFissurePiece((EntityType)EntityHandler.FISSURE_PIECE.get(), this.level());
                    piece.setPos(this.position().add(this.getDeltaMovement().scale((double)((float)TICKS_PER_PIECE / 3.0f))));
                    piece.setYRot(this.getYRot());
                    piece.setOwner((EntityFissure)this);
                    this.level().addFreshEntity((Entity)piece);
                }
                if (this.isTravelling() && !this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.3), e -> e.canBeHitByProjectile() && e != this.getOwner() && !(e instanceof EntityBluff)).isEmpty()) {
                    this.customSpikeSpawn();
                }
            } else if (this.tickCount == 1) {
                MMCommon.PROXY.playGeomancyRumbleSound((IGeomancyRumbler)this);
                if (this.isTravelling()) {
                    BlockState blockBeneath = this.level().getBlockState(this.getOnPos());
                    for (int i = 0; i < 10; ++i) {
                        Vec3 offset = new Vec3((double)this.random.nextFloat() * 0.45, 0.0, 0.0).yRot(this.random.nextFloat() * (float)Math.PI * 2.0f);
                        Vec3 vel = offset.normalize().scale(this.random.nextGaussian() * 0.12).yRot(this.random.nextFloat() * 0.2f - 0.1f).add(0.0, this.random.nextDouble() * 0.25 + 0.02, 0.0).add(this.getDeltaMovement().scale(0.4));
                        AdvancedTerrainParticle.spawnTerrainParticle((Level)this.level(), (Holder)ParticleHandler.TERRAIN, (double)(this.getX() + offset.x), (double)this.getY(), (double)(this.getZ() + offset.z), (double)vel.x, (double)vel.y, (double)vel.z, (double)0.0, (double)((double)0.4f + this.random.nextGaussian() * 0.3), (double)0.94f, (double)(20.0f + this.random.nextFloat() * 5.0f), (BlockState)blockBeneath, (ParticleComponent[])new ParticleComponent[]{new ParticleComponent.Gravity(1.0f)});
                    }
                }
            }
        }
        if (this.tickCount > 200) {
            this.discard();
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putDouble("spikeDamage", this.spikeDamage);
        compound.putInt("customDespawnTimer", this.customDespawnTimer);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.spikeDamage = compound.getDouble("spikeDamage");
        this.customDespawnTimer = compound.getInt("customDespawnTimer");
    }
}

