/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.extended.projectiles;

import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySolarBeam;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthi;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ExtendedSolarBeamEntity
extends EntitySolarBeam {
    private float damageFire = 2.0f;
    private float damageMob = 2.0f;
    private boolean didExtendedRaytrace;

    public ExtendedSolarBeamEntity(EntityType<? extends EntitySolarBeam> type, Level world) {
        super(type, world);
    }

    public ExtendedSolarBeamEntity(EntityType<? extends EntitySolarBeam> type, Level world, LivingEntity caster, double x, double y, double z, float yaw, float pitch, int duration) {
        super(type, world, caster, x, y, z, yaw, pitch, duration);
    }

    public void setDamageFire(float damageFire) {
        this.damageFire = damageFire;
    }

    public float getDamageFire() {
        return this.damageFire;
    }

    public void setDamageMob(float damageMob) {
        this.damageMob = damageMob;
    }

    public float getDamageMob() {
        return this.damageMob;
    }

    public void tick() {
        if (this.tickCount > 20 && !this.level().isClientSide) {
            for (Entity target : this.extendedRaytraceEntities((Level)this.level(), (Vec3)this.position(), (Vec3)new Vec3((double)this.endPosX, (double)this.endPosY, (double)this.endPosZ), (boolean)false, (boolean)true, (boolean)true).extendedEntities) {
                if (this.caster instanceof EntityUmvuthi && target instanceof LeaderSunstrikeImmune || target instanceof ItemEntity) continue;
                float damageFire = this.getDamageFire();
                float damageMob = this.getDamageMob();
                if (this.caster instanceof EntityUmvuthi) {
                    damageFire *= this.getDamageFire();
                    damageMob *= this.getDamageMob();
                }
                if (this.caster instanceof Player) {
                    damageFire *= this.getDamageFire();
                    damageMob *= this.getDamageMob();
                }
                if (!(target instanceof LivingEntity)) continue;
                SpellDamageSource damageSource = GGSpells.SOLAR_BEAM_SPELL.get().getDamageSource((Entity)this, (Entity)this.caster);
                DamageSources.ignoreNextKnockback((LivingEntity)((LivingEntity)target));
                target.hurt((DamageSource)damageSource, this.getDamageMob());
            }
        }
        super.tick();
    }

    public ExtendedSolarBeamHitResult extendedRaytraceEntities(Level world, Vec3 from, Vec3 to, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        this.didExtendedRaytrace = true;
        ExtendedSolarBeamHitResult result = new ExtendedSolarBeamHitResult();
        result.setBlockHit((HitResult)world.clip(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        if (result.blockHit != null) {
            Vec3 hitVec = result.blockHit.getLocation();
            this.collidePosX = hitVec.x;
            this.collidePosY = hitVec.y;
            this.collidePosZ = hitVec.z;
            this.blockSide = result.blockHit.getDirection();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = null;
        }
        List entities = world.getEntitiesOfClass(Entity.class, new AABB(Math.min(this.getX(), this.collidePosX), Math.min(this.getY(), this.collidePosY), Math.min(this.getZ(), this.collidePosZ), Math.max(this.getX(), this.collidePosX), Math.max(this.getY(), this.collidePosY), Math.max(this.getZ(), this.collidePosZ)).inflate(1.0, 1.0, 1.0));
        for (Entity entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.getPickRadius() + 0.5f;
            AABB aabb = entity.getBoundingBox().inflate((double)pad, (double)pad, (double)pad);
            Optional hit = aabb.clip(from, to);
            if (aabb.contains(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public static class ExtendedSolarBeamHitResult {
        private BlockHitResult blockHit;
        private final List<Entity> extendedEntities = new ArrayList<Entity>();

        public BlockHitResult getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(HitResult rayTraceResult) {
            if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
                this.blockHit = (BlockHitResult)rayTraceResult;
            }
        }

        public void addEntityHit(Entity entity) {
            this.extendedEntities.add(entity);
        }
    }
}

