/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.chunker;

import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.entity.IResonanceEntity;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonate_pillar.ResonatePillarEntity;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import com.gametechbc.spelllib.entity.GSLScreenShakeEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ChunkerEntity
extends Entity
implements GeoEntity,
AntiMagicSusceptible,
IResonanceEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.defineId(ChunkerEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_AGE = SynchedEntityData.defineId(ChunkerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_MAX_AGE = SynchedEntityData.defineId(ChunkerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private Vec3 lastPosition = Vec3.ZERO;
    private int stuckCounter = 0;
    private int lastStuckCheck = 0;
    private UUID summonerUUID;
    private LivingEntity cachedSummoner;
    private final RawAnimation IDLE_ROLL_ANIMATION = RawAnimation.begin().thenLoop("idle_roll");
    private final AnimationController<ChunkerEntity> controller = new AnimationController((GeoAnimatable)this, "boulder_roll_controller", 0, this::animationPredicate);

    public ChunkerEntity(EntityType<? extends Entity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ChunkerEntity(Level level, LivingEntity summoner) {
        this((EntityType<? extends Entity>)((EntityType)GGEntities.CHUNKER.get()), level);
        this.setSummoner(summoner);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_DAMAGE, (Object)Float.valueOf(5.0f));
        builder.define(DATA_AGE, (Object)0);
        builder.define(DATA_MAX_AGE, (Object)110);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putFloat("Damage", this.getDamage());
        tag.putInt("Age", this.getAge());
        tag.putInt("MaxAge", this.getMaxAge());
        if (this.summonerUUID != null) {
            tag.putUUID("Summoner", this.summonerUUID);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("Age")) {
            this.setAge(tag.getInt("Age"));
        }
        if (tag.contains("MaxAge")) {
            this.setMaxAge(tag.getInt("MaxAge"));
        }
        if (tag.contains("Damage")) {
            this.setDamage(tag.getFloat("Damage"));
        }
        if (tag.hasUUID("Summoner")) {
            this.summonerUUID = tag.getUUID("Summoner");
        }
    }

    public int getAge() {
        return (Integer)this.entityData.get(DATA_AGE);
    }

    public void setAge(int age) {
        this.entityData.set(DATA_AGE, (Object)age);
    }

    public int getMaxAge() {
        return (Integer)this.entityData.get(DATA_MAX_AGE);
    }

    public void setMaxAge(int maxAge) {
        this.entityData.set(DATA_MAX_AGE, (Object)maxAge);
    }

    public void setDamage(float damage) {
        this.entityData.set(DATA_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DATA_DAMAGE)).floatValue();
    }

    public void setSummoner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.summonerUUID = owner.getUUID();
            this.cachedSummoner = owner;
        }
    }

    public LivingEntity getSummoner() {
        if (this.cachedSummoner != null && this.cachedSummoner.isAlive()) {
            return this.cachedSummoner;
        }
        if (this.summonerUUID != null && this.level() instanceof ServerLevel) {
            Entity entity = ((ServerLevel)this.level()).getEntity(this.summonerUUID);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.cachedSummoner = livingEntity = (LivingEntity)entity;
            }
            return this.cachedSummoner;
        }
        return null;
    }

    @Override
    public float getResonanceMultiplier() {
        return 0.8f;
    }

    @Override
    public void onResonanceShockwave(ResonatePillarEntity pillar, ResonatePillarEntity.Stage stage, LivingEntity owner, LivingEntity target, Level world, Vec3 resonancePosition, float resonanceRadius, double distanceFromSource, float baseDamage, float finalDamage) {
        IResonanceEntity.super.onResonanceShockwave(pillar, stage, owner, target, world, resonancePosition, resonanceRadius, distanceFromSource, baseDamage, finalDamage);
        Vec3 targetPosition = target.position();
        Vec3 pullDirection = resonancePosition.subtract(targetPosition).normalize();
        double maxPullStrength = 2.5;
        double stageReduction = 1.0 - (double)stage.value * 0.1;
        double distanceReduction = Math.max(0.3, 1.0 - distanceFromSource / (double)resonanceRadius);
        double pullStrength = maxPullStrength * stageReduction * distanceReduction;
        Vec3 pullMotion = new Vec3(pullDirection.x * pullStrength, 0.2 + pullStrength * 0.1, pullDirection.z * pullStrength);
        Vec3 currentMotion = target.getDeltaMovement();
        target.setDeltaMovement(currentMotion.add(pullMotion));
        target.hurtMarked = true;
    }

    @Override
    public boolean canResonateWith(ResonatePillarEntity pillar) {
        LivingEntity pillarOwner = pillar.getSummoner();
        LivingEntity thisOwner = this.getSummoner();
        return pillarOwner != null && thisOwner != null && pillarOwner.getUUID().equals(thisOwner.getUUID());
    }

    @Override
    public Vector3f getResonanceParticleColor() {
        return GGSchools.GEO.get().getTargetingColor();
    }

    public void tick() {
        super.tick();
        int currentAge = this.getAge();
        this.setAge(currentAge + 1);
        int age = this.getAge();
        int maxAge = this.getMaxAge();
        float forwardSpeed = 0.25f;
        Vec3 forward = this.getLookAngle().normalize().scale((double)forwardSpeed);
        double currentY = this.getDeltaMovement().y;
        double newY = this.applyCustomGravityWithAntiStuck(currentY);
        this.setDeltaMovement(forward.x, newY, forward.z);
        this.hasImpulse = true;
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.level().isClientSide && this.tickCount % 3 == 0) {
            LivingEntity owner = this.getSummoner();
            AABB boundingBox = this.getBoundingBox();
            this.level().getEntitiesOfClass(LivingEntity.class, boundingBox).stream().filter(entity -> entity.isAlive() && entity.getId() != this.getId() && entity != owner).filter(entity -> owner == null || !this.isAlly(owner, (LivingEntity)entity) && !this.isTamed((LivingEntity)entity)).forEach(entity -> {
                DamageSources.applyDamage((Entity)entity, (float)this.getDamage(), (DamageSource)GGSpells.CHUNKER_SPELL.get().getDamageSource((Entity)this, (Entity)owner));
                Vec3 knockbackDirection = entity.position().subtract(this.position()).normalize();
                double knockbackStrength = 1.2;
                entity.setDeltaMovement(entity.getDeltaMovement().add(knockbackDirection.x * knockbackStrength, 0.3, knockbackDirection.z * knockbackStrength));
                entity.hasImpulse = true;
            });
        }
        if (!this.level().isClientSide) {
            this.spawnTrailParticles();
            if (this.tickCount == 1 || this.tickCount % 60 == 0) {
                this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_LOOP.get(), 2.0f, 1.0f);
            }
        }
        if (!this.level().isClientSide && this.tickCount % 5 == 0) {
            GSLScreenShakeEntity.createScreenShake((Level)this.level(), (Vec3)this.position(), (float)10.0f, (float)0.008f, (int)4, (int)0, (int)2, (boolean)true);
        }
        if (age >= maxAge) {
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 4.0f, 1.0f);
            if (!this.level().isClientSide) {
                this.spawnDiscardBlast();
                GSLScreenShakeEntity.createScreenShake((Level)this.level(), (Vec3)this.position(), (float)10.0f, (float)0.025f, (int)10, (int)0, (int)5, (boolean)false);
                this.spawnFallingBlockBlast();
            }
            this.discard();
        }
    }

    private double applyCustomGravityWithAntiStuck(double currentY) {
        boolean isStuck = this.checkIfStuck();
        double distanceToGround = this.getDistanceToGround();
        if (isStuck && distanceToGround <= 2.0) {
            double upwardBoost = 0.15 + (double)this.stuckCounter * 0.02;
            return Math.min(currentY + upwardBoost, 0.4);
        }
        if (distanceToGround <= 0.5) {
            if (currentY < -0.1) {
                return Math.max(currentY * 0.8, -0.05);
            }
            if (currentY > 0.1) {
                return Math.min(currentY * 0.8, 0.05);
            }
            return currentY * 0.9;
        }
        double gravity = -0.08;
        double terminalVelocity = -2.0;
        double newY = currentY + gravity;
        return Math.max(newY, terminalVelocity);
    }

    private boolean checkIfStuck() {
        double expectedMovement;
        if (this.tickCount - this.lastStuckCheck < 2) {
            return this.stuckCounter > 0;
        }
        this.lastStuckCheck = this.tickCount;
        Vec3 currentPos = this.position();
        double horizontalMovement = Math.sqrt(Math.pow(currentPos.x - this.lastPosition.x, 2.0) + Math.pow(currentPos.z - this.lastPosition.z, 2.0));
        if (horizontalMovement < (expectedMovement = 0.35)) {
            ++this.stuckCounter;
            if (this.hasBlockInFront()) {
                this.stuckCounter += 2;
            }
        } else {
            this.stuckCounter = Math.max(0, this.stuckCounter - 2);
        }
        this.lastPosition = currentPos;
        this.stuckCounter = Math.min(this.stuckCounter, 15);
        return this.stuckCounter > 3;
    }

    private boolean hasBlockInFront() {
        Vec3 lookDirection = this.getLookAngle();
        Vec3 checkPos = this.position().add(lookDirection.scale(1.0));
        BlockPos blockPos = BlockPos.containing((Position)checkPos);
        BlockState blockState = this.level().getBlockState(blockPos);
        return !blockState.isAir() && blockState.isSolidRender((BlockGetter)this.level(), blockPos);
    }

    private double getDistanceToGround() {
        BlockPos entityPos = this.blockPosition();
        Level level = this.level();
        for (int y = 0; y <= 3; ++y) {
            BlockPos checkPos = entityPos.below(y);
            BlockState blockState = level.getBlockState(checkPos);
            if (blockState.isAir() || !blockState.isSolidRender((BlockGetter)level, checkPos)) continue;
            double blockTop = (double)checkPos.getY() + 1.0;
            double entityBottom = this.getY();
            return Math.max(0.0, entityBottom - blockTop);
        }
        return 4.0;
    }

    private void spawnTrailParticles() {
        double d5;
        double d4;
        double d3;
        double d2;
        double d1;
        double d0;
        AABB boundingBox = this.getBoundingBox();
        Vec3 velocity = this.getDeltaMovement();
        int dirtParticleCount = 5 + this.random.nextInt(3);
        for (int i = 0; i < dirtParticleCount; ++i) {
            double d02 = boundingBox.minX + (boundingBox.maxX - boundingBox.minX) * this.random.nextDouble();
            double d12 = boundingBox.minY + (boundingBox.maxY - boundingBox.minY) * 0.3;
            double d22 = boundingBox.minZ + (boundingBox.maxZ - boundingBox.minZ) * this.random.nextDouble();
            double d32 = -velocity.x * 0.5 + (this.random.nextDouble() - 0.5) * 0.2;
            double d42 = this.random.nextDouble() * 0.1 + 0.02;
            double d52 = -velocity.z * 0.5 + (this.random.nextDouble() - 0.5) * 0.2;
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DIRT.defaultBlockState()), (double)d02, (double)d12, (double)d22, (int)1, (double)d32, (double)d42, (double)d52, (double)0.0, (boolean)false);
        }
        int dustCount = 2 + this.random.nextInt(2);
        for (int i = 0; i < dustCount; ++i) {
            double d03 = this.getX() - velocity.x * (1.0 + this.random.nextDouble()) + (this.random.nextDouble() - 0.5) * 1.5;
            double d13 = boundingBox.minY + 0.1 + this.random.nextDouble() * 0.5;
            double d23 = this.getZ() - velocity.z * (1.0 + this.random.nextDouble()) + (this.random.nextDouble() - 0.5) * 1.5;
            double d33 = (this.random.nextDouble() - 0.5) * 0.03;
            double d43 = this.random.nextDouble() * 0.02 + 0.01;
            double d53 = (this.random.nextDouble() - 0.5) * 0.03;
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.POOF, (double)d03, (double)d13, (double)d23, (int)1, (double)d33, (double)d43, (double)d53, (double)0.0, (boolean)false);
        }
        if (this.tickCount % 2 == 0) {
            int impactCount = 3 + this.random.nextInt(2);
            for (int i = 0; i < impactCount; ++i) {
                d0 = this.getX() + (this.random.nextDouble() - 0.5) * (boundingBox.maxX - boundingBox.minX);
                d1 = boundingBox.minY - 0.1;
                d2 = this.getZ() + (this.random.nextDouble() - 0.5) * (boundingBox.maxZ - boundingBox.minZ);
                d3 = (this.random.nextDouble() - 0.5) * 0.15;
                d4 = this.random.nextDouble() * 0.08 + 0.02;
                d5 = (this.random.nextDouble() - 0.5) * 0.15;
                MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.CLAY.defaultBlockState()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
            }
        }
        if (this.tickCount % 2 == 0) {
            int stoneCount = 3 + this.random.nextInt(2);
            for (int i = 0; i < stoneCount; ++i) {
                d0 = boundingBox.minX + (boundingBox.maxX - boundingBox.minX) * this.random.nextDouble();
                d1 = boundingBox.minY + (boundingBox.maxY - boundingBox.minY) * 0.4;
                d2 = boundingBox.minZ + (boundingBox.maxZ - boundingBox.minZ) * this.random.nextDouble();
                d3 = -velocity.x * 0.3 + (this.random.nextDouble() - 0.5) * 0.1;
                d4 = this.random.nextDouble() * 0.06 + 0.01;
                d5 = -velocity.z * 0.3 + (this.random.nextDouble() - 0.5) * 0.1;
                BlockState stoneBlock = this.random.nextBoolean() ? Blocks.COBBLESTONE.defaultBlockState() : Blocks.GRAVEL.defaultBlockState();
                MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, stoneBlock), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
            }
        }
    }

    private void spawnDiscardBlast() {
        float blastRadius = 5.0f;
        for (int i = 0; i < 30; ++i) {
            double d0 = this.getX() + (this.random.nextDouble() - 0.5) * (double)blastRadius * 2.0;
            double d1 = this.getY() + this.random.nextDouble() * (double)blastRadius;
            double d2 = this.getZ() + (this.random.nextDouble() - 0.5) * (double)blastRadius * 2.0;
            double d3 = (this.random.nextDouble() - 0.5) * 0.5;
            double d4 = this.random.nextDouble() * 0.4 + 0.1;
            double d5 = (this.random.nextDouble() - 0.5) * 0.5;
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DIRT.defaultBlockState()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
        }
    }

    private void spawnFallingBlockBlast() {
        AABB boundingBox = this.getBoundingBox();
        Vec3 center = boundingBox.getCenter();
        int particleCount = 10;
        for (int i = 0; i < particleCount; ++i) {
            double d3 = (this.random.nextDouble() - 0.5) * 1.2;
            double d4 = this.random.nextDouble() + 0.3;
            double d5 = (this.random.nextDouble() - 0.5) * 1.2;
            int duration = 80 + this.random.nextInt(41);
            EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), this.level(), duration, Blocks.DIRT.defaultBlockState());
            fallingBlock.setPos(center.x, center.y, center.z);
            fallingBlock.setDeltaMovement(d3, d4, d5);
            this.level().addFreshEntity((Entity)fallingBlock);
        }
    }

    public void onAntiMagic(MagicData playerMagicData) {
        this.discard();
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isNoGravity() {
        return false;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return false;
    }

    private boolean isAlly(LivingEntity owner, LivingEntity target) {
        return owner.getTeam() != null && owner.getTeam().isAlliedTo((Team)target.getTeam());
    }

    private boolean isTamed(LivingEntity target) {
        if (target instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)target;
            return tamableAnimal.isTame();
        }
        return false;
    }

    private PlayState animationPredicate(AnimationState<ChunkerEntity> event) {
        event.getController().setAnimation(this.IDLE_ROLL_ANIMATION);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(this.controller);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

