/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.dripstone_bolt;

import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DripstoneBoltEntity
extends AbstractMagicProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_LOOP_ANIM = RawAnimation.begin().thenLoop("traveling_loop");
    private final AnimationController<DripstoneBoltEntity> controller = new AnimationController((GeoAnimatable)this, "stone_controller", 0, this::animationPredicate);

    public DripstoneBoltEntity(EntityType<? extends DripstoneBoltEntity> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    public DripstoneBoltEntity(EntityType<? extends DripstoneBoltEntity> entityType, Level levelIn, LivingEntity shooter) {
        this(entityType, levelIn);
        this.setOwner((Entity)shooter);
    }

    public DripstoneBoltEntity(Level levelIn, LivingEntity shooter) {
        this((EntityType<? extends DripstoneBoltEntity>)((EntityType)GGEntities.DRIPSTONE_BOLT.get()), levelIn, shooter);
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        Vec3 hitPos = blockHitResult.getLocation();
        this.applyAOEDamage(hitPos.x, hitPos.y, hitPos.z);
        this.discard();
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        DamageSources.applyDamage((Entity)entityHitResult.getEntity(), (float)this.getDamage(), (DamageSource)GGSpells.DRIPSTONE_BOLT.get().getDamageSource((Entity)this, this.getOwner()));
        Vec3 hitPos = entityHitResult.getLocation();
        this.applyAOEDamage(hitPos.x, hitPos.y, hitPos.z);
        this.discard();
    }

    private void applyAOEDamage(double x, double y, double z) {
        if (this.level().isClientSide) {
            return;
        }
        Entity owner = this.getOwner();
        float radius = 2.0f;
        AABB aoeRegion = new AABB(x - (double)radius, y - (double)radius, z - (double)radius, x + (double)radius, y + (double)radius, z + (double)radius);
        List nearbyEntities = this.level().getEntities((Entity)this, aoeRegion, entity -> entity instanceof LivingEntity);
        for (Entity entity2 : nearbyEntities) {
            if (entity2 == owner || !(entity2 instanceof LivingEntity)) continue;
            DamageSources.applyDamage((Entity)entity2, (float)(this.getDamage() * 0.5f), (DamageSource)GGSpells.DRIPSTONE_BOLT.get().getDamageSource((Entity)this, owner));
        }
        MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlastwaveParticleOptions(GGSchools.GEO.get().getTargetingColor(), radius), (double)this.getX(), (double)(this.getY() + (double)0.1f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
    }

    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DRIPSTONE_BLOCK.defaultBlockState()), (double)x, (double)y, (double)z, (int)25, (double)0.0, (double)0.0, (double)0.0, (double)0.18, (boolean)true);
    }

    public void trailParticles() {
        for (int i = 0; i < 2; ++i) {
            double speed = 0.02;
            double dx = Utils.random.nextDouble() * 2.0 * speed - speed;
            double dy = Utils.random.nextDouble() * 2.0 * speed - speed;
            double dz = Utils.random.nextDouble() * 2.0 * speed - speed;
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DRIPSTONE_BLOCK.defaultBlockState()), this.getX() + dx, this.getY() + dy, this.getZ() + dz, dx, dy, dz);
            if (this.tickCount <= 1) continue;
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DRIPSTONE_BLOCK.defaultBlockState()), this.getX() + dx - this.getDeltaMovement().x / 2.0, this.getY() + dy - this.getDeltaMovement().y / 2.0, this.getZ() + dz - this.getDeltaMovement().z / 2.0, dx, dy, dz);
        }
    }

    public float getSpeed() {
        return 2.5f;
    }

    public Optional<Holder<SoundEvent>> getImpactSound() {
        return Optional.of(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.POINTED_DRIPSTONE_HIT));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(this.controller);
    }

    private PlayState animationPredicate(AnimationState<DripstoneBoltEntity> state) {
        state.getController().setAnimation(IDLE_LOOP_ANIM);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

