/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.dripstone_bolt;

import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.dripstone_bolt.DripstoneBoltEntity;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.dripstone_bolt.DripstoneBoltEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class DripstoneBoltEntityRenderer
extends GeoEntityRenderer<DripstoneBoltEntity> {
    public DripstoneBoltEntityRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new DripstoneBoltEntityModel());
        this.shadowRadius = 0.0f;
    }

    public void render(DripstoneBoltEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        Vec3 motion = entity.getDeltaMovement();
        double horizontalDistance = Math.sqrt(motion.x * motion.x + motion.z * motion.z);
        float yaw = (float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.29577951308232);
        float pitch = (float)(Mth.atan2((double)motion.y, (double)horizontalDistance) * 57.29577951308232);
        poseStack.mulPose(Axis.YP.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(-pitch));
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.popPose();
    }
}

