/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.eroding_boulder;

import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEffects;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import com.gametechbc.gtbcs_geomancy_plus.network.ClientboundEarthExplosionParticles;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ErodingBoulderEntity
extends AbstractMagicProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> BLAST_RADIUS = SynchedEntityData.defineId(ErodingBoulderEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private int effectAmplifier = 0;
    private static final RawAnimation IDLE_LOOP_ANIM = RawAnimation.begin().thenLoop("idle_loop");
    private final AnimationController<ErodingBoulderEntity> controller = new AnimationController((GeoAnimatable)this, "boulder_controller", 0, this::animationPredicate);

    public ErodingBoulderEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ErodingBoulderEntity(Level pLevel, LivingEntity pShooter) {
        this((EntityType<? extends Projectile>)((EntityType)GGEntities.ERODING_BOULDER.get()), pLevel);
        this.setOwner((Entity)pShooter);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BLAST_RADIUS, (Object)Float.valueOf(3.0f));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("BlastRadius", this.getBlastRadius());
        tag.putInt("EffectAmplifier", this.effectAmplifier);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("BlastRadius")) {
            this.setBlastRadius(tag.getFloat("BlastRadius"));
        }
        if (tag.contains("EffectAmplifier")) {
            this.effectAmplifier = tag.getInt("EffectAmplifier");
        }
    }

    public float getBlastRadius() {
        return ((Float)this.entityData.get(BLAST_RADIUS)).floatValue();
    }

    public void setBlastRadius(float radius) {
        this.entityData.set(BLAST_RADIUS, (Object)Float.valueOf(radius));
    }

    public int getEffectAmplifier() {
        return this.effectAmplifier;
    }

    public void setEffectAmplifier(int amplifier) {
        this.effectAmplifier = amplifier;
    }

    protected void onHit(HitResult hitResult) {
        if (!this.level().isClientSide) {
            float explosionRadius = this.getBlastRadius();
            float explosionRadiusSqr = explosionRadius * explosionRadius;
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)explosionRadius));
            Vec3 losPoint = Utils.raycastForBlock((Level)this.level(), (Vec3)this.position(), (Vec3)this.position().add(0.0, 2.0, 0.0), (ClipContext.Fluid)ClipContext.Fluid.NONE).getLocation();
            for (Entity entity : entities) {
                double distanceSqr = entity.distanceToSqr(hitResult.getLocation());
                if (!(distanceSqr < (double)explosionRadiusSqr) || !this.canHitEntity(entity) || !Utils.hasLineOfSight((Level)this.level(), (Vec3)losPoint, (Vec3)entity.getBoundingBox().getCenter(), (boolean)true)) continue;
                double p = 1.0 - distanceSqr / (double)explosionRadiusSqr;
                float damage = (float)((double)this.damage * p);
                DamageSources.applyDamage((Entity)entity, (float)damage, (DamageSource)GGSpells.ERODING_BOULDER_SPELL.get().getDamageSource((Entity)this, this.getOwner()));
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(GGEffects.ERODE_EFFECT, 100, this.getEffectAmplifier(), false, false, false));
            }
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlastwaveParticleOptions(GGSchools.GEO.get().getTargetingColor(), explosionRadius), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new ClientboundEarthExplosionParticles(new Vec3(this.getX(), this.getY(), this.getZ()), explosionRadius), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1.get(), 2.7f, 1.0f);
            this.discard();
        }
    }

    public void trailParticles() {
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() - vec3.x;
        double d1 = this.getY() - vec3.y;
        double d2 = this.getZ() - vec3.z;
        int count = Mth.clamp((int)((int)(vec3.lengthSqr() * 4.0)), (int)1, (int)4);
        BlockState dirtBlock = Blocks.DIRT.defaultBlockState();
        for (int i = 0; i < count; ++i) {
            Vec3 random = Utils.getRandomVec3((double)0.25);
            float f = (float)i / (float)count;
            double x = Mth.lerp((double)f, (double)d0, (double)this.getX());
            double y = Mth.lerp((double)f, (double)d1, (double)this.getY());
            double z = Mth.lerp((double)f, (double)d2, (double)this.getZ());
            if (dirtBlock.getRenderShape() == RenderShape.INVISIBLE) continue;
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, dirtBlock), x - random.x, y + 0.5 - random.y, z - random.z, random.x * 0.5, random.y * 0.5, random.z * 0.5);
        }
    }

    public void impactParticles(double x, double y, double z) {
    }

    public float getSpeed() {
        return 1.15f;
    }

    public Optional<Holder<SoundEvent>> getImpactSound() {
        return Optional.of(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1.get())));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(this.controller);
    }

    private PlayState animationPredicate(AnimationState<ErodingBoulderEntity> state) {
        state.getController().setAnimation(IDLE_LOOP_ANIM);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

