/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.eroding_boulder;

import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.eroding_boulder.ErodingBoulderEntity;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.eroding_boulder.ErodingBoulderEntityModel;
import com.gametechbc.spelllib.render.GSLRenderEmissiveLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class ErodingBoulderEntityRenderer
extends GeoEntityRenderer<ErodingBoulderEntity> {
    private static final ResourceLocation LAYER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"textures/models/entity/small_boulder/small_boulder_layer.png");

    public ErodingBoulderEntityRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new ErodingBoulderEntityModel());
        this.addRenderLayer((GeoRenderLayer)new GSLRenderEmissiveLayer((GeoRenderer)this, RenderType.eyes((ResourceLocation)LAYER_TEXTURE), 0.6f));
        this.shadowRadius = 0.0f;
    }

    public void render(ErodingBoulderEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        Vec3 motion = entity.getDeltaMovement();
        double horizontalDistance = Math.sqrt(motion.x * motion.x + motion.z * motion.z);
        float yaw = (float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.29577951308232);
        float pitch = (float)(Mth.atan2((double)motion.y, (double)horizontalDistance) * 57.29577951308232);
        poseStack.mulPose(Axis.YP.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(-pitch));
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.popPose();
    }
}

