/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.petrivise_pillar;

import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.entity.IResonanceEntity;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonate_pillar.ResonatePillarEntity;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import com.gametechbc.spelllib.entity.GSLScreenShakeEntity;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PetrivisePillarEntity
extends Entity
implements GeoEntity,
IResonanceEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.defineId(PetrivisePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_AGE = SynchedEntityData.defineId(PetrivisePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_WARMUP_DELAY = SynchedEntityData.defineId(PetrivisePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_SLAM_DELAY = SynchedEntityData.defineId(PetrivisePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_SLAM_SPEED = SynchedEntityData.defineId(PetrivisePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_PILLAR_ID = SynchedEntityData.defineId(PetrivisePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private UUID casterUUID;
    private LivingEntity cachedCaster;
    private boolean hasDamaged = false;
    private boolean enableScreenShake = false;
    private boolean hasSpawnedEmergeParticles = false;
    private final RawAnimation IDLE_BLANK_ANIMATION = RawAnimation.begin().thenLoop("idle_warmup");
    private final RawAnimation EMERGE_ANIMATION = RawAnimation.begin().thenPlayAndHold("petrivise_emerge");
    private final AnimationController<PetrivisePillarEntity> controller = new AnimationController((GeoAnimatable)this, "pillar_controller", 0, this::animationPredicate);

    public PetrivisePillarEntity(EntityType<? extends PetrivisePillarEntity> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    public PetrivisePillarEntity(Level level, double x, double y, double z, float yRot, int warmupDelay, int slamDelay, float slamSpeed, float damage, int pillarId, LivingEntity caster) {
        this((EntityType<? extends PetrivisePillarEntity>)((EntityType)GGEntities.PETRIVISE_PILLAR.get()), level);
        this.setPos(x, y, z);
        this.setYRot(yRot);
        this.setDamage(damage);
        this.setWarmupDelay(warmupDelay);
        this.setSlamDelay(slamDelay);
        this.setSlamSpeed(slamSpeed);
        this.setPillarId(pillarId);
        this.setCaster(caster);
        this.noPhysics = true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_DAMAGE, (Object)Float.valueOf(0.0f));
        builder.define(DATA_AGE, (Object)0);
        builder.define(DATA_WARMUP_DELAY, (Object)40);
        builder.define(DATA_SLAM_DELAY, (Object)10);
        builder.define(DATA_SLAM_SPEED, (Object)Float.valueOf(0.5f));
        builder.define(DATA_PILLAR_ID, (Object)0);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putFloat("Damage", this.getDamage());
        tag.putInt("Age", this.getAge());
        tag.putInt("WarmupDelay", this.getWarmupDelay());
        tag.putInt("SlamDelay", this.getSlamDelay());
        tag.putFloat("SlamSpeed", this.getSlamSpeed());
        tag.putBoolean("HasDamaged", this.hasDamaged);
        tag.putInt("PillarId", this.getPillarId());
        tag.putBoolean("EnableScreenShake", this.enableScreenShake);
        tag.putBoolean("HasSpawnedEmergeParticles", this.hasSpawnedEmergeParticles);
        if (this.casterUUID != null) {
            tag.putUUID("Caster", this.casterUUID);
        }
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("Damage")) {
            this.setDamage(tag.getFloat("Damage"));
        }
        if (tag.contains("Age")) {
            this.setAge(tag.getInt("Age"));
        }
        if (tag.contains("WarmupDelay")) {
            this.setWarmupDelay(tag.getInt("WarmupDelay"));
        }
        if (tag.contains("SlamDelay")) {
            this.setSlamDelay(tag.getInt("SlamDelay"));
        }
        if (tag.contains("SlamSpeed")) {
            this.setSlamSpeed(tag.getFloat("SlamSpeed"));
        }
        if (tag.contains("HasDamaged")) {
            this.hasDamaged = tag.getBoolean("HasDamaged");
        }
        if (tag.contains("PillarId")) {
            this.setPillarId(tag.getInt("PillarId"));
        }
        if (tag.contains("EnableScreenShake")) {
            this.enableScreenShake = tag.getBoolean("EnableScreenShake");
        }
        if (tag.contains("HasSpawnedEmergeParticles")) {
            this.hasSpawnedEmergeParticles = tag.getBoolean("HasSpawnedEmergeParticles");
        }
        if (tag.hasUUID("Caster")) {
            this.casterUUID = tag.getUUID("Caster");
        }
    }

    public int getPillarId() {
        return (Integer)this.entityData.get(DATA_PILLAR_ID);
    }

    public void setPillarId(int id) {
        this.entityData.set(DATA_PILLAR_ID, (Object)id);
    }

    public int getAge() {
        return (Integer)this.entityData.get(DATA_AGE);
    }

    public void setAge(int age) {
        this.entityData.set(DATA_AGE, (Object)age);
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DATA_DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.entityData.set(DATA_DAMAGE, (Object)Float.valueOf(damage));
    }

    public int getWarmupDelay() {
        return (Integer)this.entityData.get(DATA_WARMUP_DELAY);
    }

    public void setWarmupDelay(int delay) {
        this.entityData.set(DATA_WARMUP_DELAY, (Object)delay);
    }

    public int getSlamDelay() {
        return (Integer)this.entityData.get(DATA_SLAM_DELAY);
    }

    public void setSlamDelay(int delay) {
        this.entityData.set(DATA_SLAM_DELAY, (Object)delay);
    }

    public float getSlamSpeed() {
        return ((Float)this.entityData.get(DATA_SLAM_SPEED)).floatValue();
    }

    public void setSlamSpeed(float speed) {
        this.entityData.set(DATA_SLAM_SPEED, (Object)Float.valueOf(speed));
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.cachedCaster = caster;
        this.casterUUID = caster == null ? null : caster.getUUID();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.cachedCaster == null && this.casterUUID != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.casterUUID)) instanceof LivingEntity) {
            this.cachedCaster = (LivingEntity)entity;
        }
        return this.cachedCaster;
    }

    public boolean getEnableScreenShake() {
        return this.enableScreenShake;
    }

    public void setEnableScreenShake(boolean enable) {
        this.enableScreenShake = enable;
    }

    @Override
    public float getResonanceMultiplier() {
        return 1.0f;
    }

    @Override
    public void onResonanceShockwave(ResonatePillarEntity pillar, ResonatePillarEntity.Stage stage, LivingEntity owner, LivingEntity target, Level world, Vec3 resonancePosition, float resonanceRadius, double distanceFromSource, float baseDamage, float finalDamage) {
        IResonanceEntity.super.onResonanceShockwave(pillar, stage, owner, target, world, resonancePosition, resonanceRadius, distanceFromSource, baseDamage, finalDamage);
        Vec3 targetPosition = target.position();
        Vec3 pullDirection = resonancePosition.subtract(targetPosition).normalize();
        double maxPullStrength = 2.5;
        double stageReduction = 1.0 - (double)stage.value * 0.1;
        double distanceReduction = Math.max(0.3, 1.0 - distanceFromSource / (double)resonanceRadius);
        double pullStrength = maxPullStrength * stageReduction * distanceReduction;
        Vec3 pullMotion = new Vec3(pullDirection.x * pullStrength, 0.2 + pullStrength * 0.1, pullDirection.z * pullStrength);
        Vec3 currentMotion = target.getDeltaMovement();
        target.setDeltaMovement(currentMotion.add(pullMotion));
        target.hurtMarked = true;
    }

    @Override
    public boolean canResonateWith(ResonatePillarEntity pillar) {
        LivingEntity pillarOwner = pillar.getSummoner();
        LivingEntity thisOwner = this.getCaster();
        return pillarOwner != null && thisOwner != null && pillarOwner.getUUID().equals(thisOwner.getUUID());
    }

    @Override
    public Vector3f getResonanceParticleColor() {
        return GGSchools.GEO.get().getTargetingColor();
    }

    public void tick() {
        super.tick();
        int currentAge = this.getAge();
        this.setAge(currentAge + 1);
        int age = this.getAge();
        int warmupDelay = this.getWarmupDelay();
        int slamDelay = this.getSlamDelay();
        int slamStartAge = warmupDelay + slamDelay;
        if (age < warmupDelay) {
            this.setDeltaMovement(Vec3.ZERO);
        } else if (age < slamStartAge) {
            this.setDeltaMovement(Vec3.ZERO);
            if (!this.hasSpawnedEmergeParticles && !this.level().isClientSide) {
                this.spawnEmergeParticles();
                this.hasSpawnedEmergeParticles = true;
            }
        } else {
            Vec3 lookDirection = this.getLookAngle().normalize();
            Vec3 movement = lookDirection.scale((double)this.getSlamSpeed());
            this.setDeltaMovement(movement);
            this.hasImpulse = true;
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (this.level().isClientSide) {
                this.spawnBlockDiggingParticles();
            }
            if (!this.level().isClientSide) {
                this.checkForPillarCollision();
                this.applySubtlePushToNearbyEntities();
            }
        }
    }

    private void checkForPillarCollision() {
        AABB searchArea = this.getBoundingBox().inflate(1.5);
        List nearbyPillars = this.level().getEntitiesOfClass(PetrivisePillarEntity.class, searchArea);
        for (PetrivisePillarEntity otherPillar : nearbyPillars) {
            if (otherPillar == this || this.getPillarId() != otherPillar.getPillarId() || this.getPillarId() == 0) continue;
            int ourAge = this.getAge();
            int theirAge = otherPillar.getAge();
            int ourSlamStartAge = this.getWarmupDelay() + this.getSlamDelay();
            int theirSlamStartAge = otherPillar.getWarmupDelay() + otherPillar.getSlamDelay();
            if (ourAge < ourSlamStartAge || theirAge < theirSlamStartAge) continue;
            this.dealCollisionDamage();
            this.customRemove();
            otherPillar.customRemove();
            break;
        }
    }

    private void dealCollisionDamage() {
        AABB damageArea = this.getBoundingBox().inflate(1.5);
        List targets = this.level().getEntitiesOfClass(LivingEntity.class, damageArea);
        LivingEntity caster = this.getCaster();
        for (LivingEntity target : targets) {
            if (target == caster || !target.isAlive() || target.isInvulnerable() || caster != null && (caster.isAlliedTo((Entity)target) || target.isAlliedTo((Entity)caster))) continue;
            DamageSources.applyDamage((Entity)target, (float)this.getDamage(), (DamageSource)GGSpells.PETRIVISE_SPELL.get().getDamageSource((Entity)this, (Entity)caster));
        }
        if (this.enableScreenShake) {
            GSLScreenShakeEntity.createScreenShake((Level)this.level(), (Vec3)this.position(), (float)24.0f, (float)0.03f, (int)15, (int)0, (int)5, (boolean)false);
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 4.0f, 1.0f);
        }
    }

    private void applySubtlePushToNearbyEntities() {
        int slamStartAge;
        int age = this.getAge();
        if (age < (slamStartAge = this.getWarmupDelay() + this.getSlamDelay())) {
            return;
        }
        AABB pushArea = this.getBoundingBox().inflate(1.5);
        List nearbyEntities = this.level().getEntitiesOfClass(LivingEntity.class, pushArea);
        LivingEntity caster = this.getCaster();
        Vec3 pillarDirection = this.getLookAngle().normalize();
        for (LivingEntity entity : nearbyEntities) {
            if (entity == caster || !entity.isAlive() || caster != null && (caster.isAlliedTo((Entity)entity) || entity.isAlliedTo((Entity)caster))) continue;
            Vec3 currentMotion = entity.getDeltaMovement();
            double pushStrength = 0.05;
            Vec3 pushForce = pillarDirection.scale(pushStrength);
            Vec3 horizontalPush = new Vec3(pushForce.x, 0.0, pushForce.z);
            Vec3 newMotion = currentMotion.add(horizontalPush);
            entity.setDeltaMovement(newMotion);
            entity.hasImpulse = true;
        }
    }

    private void spawnEmergeParticles() {
        AABB boundingBox = this.getBoundingBox();
        for (int i = 0; i < 10; ++i) {
            double d0 = boundingBox.minX + this.random.nextDouble() * (boundingBox.maxX - boundingBox.minX);
            double d1 = boundingBox.minY + this.random.nextDouble() * (boundingBox.maxY - boundingBox.minY);
            double d2 = boundingBox.minZ + this.random.nextDouble() * (boundingBox.maxZ - boundingBox.minZ);
            double d3 = (this.random.nextDouble() - 0.5) * 0.3;
            double d4 = this.random.nextDouble() * 0.3 + 0.1;
            double d5 = (this.random.nextDouble() - 0.5) * 0.3;
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.BEDROCK.defaultBlockState()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.03, (boolean)false);
        }
    }

    private void spawnBlockDiggingParticles() {
        double vZ;
        double vY;
        double vX;
        int i;
        BlockState block = this.level().getBlockState(this.blockPosition().below());
        if (block.getRenderShape() == RenderShape.INVISIBLE) {
            return;
        }
        Vec3 direction = this.getLookAngle().normalize();
        for (i = 0; i < 1; ++i) {
            double d0 = this.getX() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.35;
            double d1 = this.getY() + 0.02;
            double d2 = this.getZ() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.35;
            double d3 = this.random.nextGaussian() * 0.06;
            double d4 = this.random.nextGaussian() * 0.09;
            double d5 = this.random.nextGaussian() * 0.06;
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), d0, d1, d2, d3, d4, d5);
        }
        for (i = 0; i < 1; ++i) {
            double backX = this.getX() - direction.x * 0.55 + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 0.45;
            double backY = this.getY() + 0.06;
            double backZ = this.getZ() - direction.z * 0.55 + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 0.45;
            vX = direction.x * -0.13 + this.random.nextGaussian() * 0.045;
            vY = this.random.nextGaussian() * 0.08;
            vZ = direction.z * -0.13 + this.random.nextGaussian() * 0.045;
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), backX, backY, backZ, vX, vY, vZ);
        }
        for (i = 0; i < 1; ++i) {
            double frontX = this.getX() + direction.x * 0.78 + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 0.38;
            double frontY = this.getY() + 0.08;
            double frontZ = this.getZ() + direction.z * 0.78 + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 0.38;
            vX = direction.x * 0.2 + this.random.nextGaussian() * 0.03;
            vY = this.random.nextGaussian() * 0.08;
            vZ = direction.z * 0.2 + this.random.nextGaussian() * 0.03;
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), frontX, frontY, frontZ, vX, vY, vZ);
        }
    }

    private void spawnDiscardBlast() {
        double d5;
        double d4;
        double d3;
        double d2;
        double d1;
        double d0;
        int i;
        AABB boundingBox = this.getBoundingBox();
        Vec3 center = boundingBox.getCenter();
        for (i = 0; i < 30; ++i) {
            d0 = boundingBox.minX + this.random.nextDouble() * (boundingBox.maxX - boundingBox.minX);
            d1 = boundingBox.minY + this.random.nextDouble() * (boundingBox.maxY - boundingBox.minY);
            d2 = boundingBox.minZ + this.random.nextDouble() * (boundingBox.maxZ - boundingBox.minZ);
            d3 = (this.random.nextDouble() - 0.5) * 2.5;
            d4 = this.random.nextDouble() * 1.8 + 0.4;
            d5 = (this.random.nextDouble() - 0.5) * 2.5;
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.BEDROCK.defaultBlockState()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.08, (boolean)false);
        }
        for (i = 0; i < 25; ++i) {
            d0 = center.x + (this.random.nextDouble() - 0.5) * 1.5;
            d1 = center.y + this.random.nextDouble() * 1.2;
            d2 = center.z + (this.random.nextDouble() - 0.5) * 1.5;
            d3 = (this.random.nextDouble() - 0.5) * 2.0;
            d4 = this.random.nextDouble() * 1.5 + 0.3;
            d5 = (this.random.nextDouble() - 0.5) * 2.0;
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.COBBLESTONE.defaultBlockState()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.06, (boolean)false);
        }
        for (i = 0; i < 20; ++i) {
            d0 = center.x + (this.random.nextDouble() - 0.5) * 0.8;
            d1 = center.y + this.random.nextDouble() * 0.8;
            d2 = center.z + (this.random.nextDouble() - 0.5) * 0.8;
            d3 = (this.random.nextDouble() - 0.5) * 3.0;
            d4 = this.random.nextDouble() * 2.0 + 0.5;
            d5 = (this.random.nextDouble() - 0.5) * 3.0;
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.STONE.defaultBlockState()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.1, (boolean)false);
        }
        for (i = 0; i < 3; ++i) {
            d0 = center.x + (this.random.nextDouble() - 0.5) * 2.0;
            d1 = center.y + this.random.nextDouble() * 1.5;
            d2 = center.z + (this.random.nextDouble() - 0.5) * 2.0;
            d3 = this.random.nextDouble() - 0.5;
            d4 = this.random.nextDouble() * 0.8 + 0.2;
            d5 = this.random.nextDouble() - 0.5;
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.05, (boolean)false);
        }
    }

    private void spawnFallingBlockRemnant() {
        double randomX = (this.random.nextDouble() - 0.5) * 1.5;
        double randomY = this.random.nextDouble() * 0.8 + 0.3;
        double randomZ = (this.random.nextDouble() - 0.5) * 1.5;
        int duration = 80 + this.random.nextInt(41);
        EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), this.level(), duration, Blocks.BEDROCK.defaultBlockState());
        AABB boundingBox = this.getBoundingBox();
        Vec3 center = boundingBox.getCenter();
        fallingBlock.setPos(center.x, center.y, center.z);
        fallingBlock.setDeltaMovement(randomX, randomY, randomZ);
        this.level().addFreshEntity((Entity)fallingBlock);
    }

    public void customRemove() {
        if (!this.level().isClientSide) {
            this.spawnDiscardBlast();
            this.spawnFallingBlockRemnant();
        }
        this.discard();
    }

    private PlayState animationPredicate(AnimationState<PetrivisePillarEntity> event) {
        int warmupDelay;
        int age = this.getAge();
        if (age < (warmupDelay = this.getWarmupDelay())) {
            event.getController().setAnimation(this.IDLE_BLANK_ANIMATION);
        } else {
            event.getController().setAnimation(this.EMERGE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(this.controller);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return true;
    }
}

