/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonate_pillar;

import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.entity.IResonanceEntity;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.api.util.GGGeneralUtil;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonate_pillar.ResonatePillarParticleManager;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEffects;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import com.gametechbc.gtbcs_geomancy_plus.util.GGTags;
import com.gametechbc.spelllib.entity.GSLScreenShakeEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ResonatePillarEntity
extends Entity
implements GeoEntity,
AntiMagicSusceptible {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.defineId(ResonatePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_AGE = SynchedEntityData.defineId(ResonatePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_MAX_AGE = SynchedEntityData.defineId(ResonatePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_STAGE = SynchedEntityData.defineId(ResonatePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_SHOCKWAVE_RADIUS = SynchedEntityData.defineId(ResonatePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_EMISSIVE_BRIGHTNESS = SynchedEntityData.defineId(ResonatePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private UUID summonerUUID;
    private LivingEntity cachedSummoner;
    private int lastShockwaveAge = 0;
    private int lastStage1ShockwaveAge = -30;
    private int lastStage2ShockwaveAge = -20;
    private int lastStage3ShockwaveAge = -10;
    private int secondBlastwaveAge = -1;
    private int erodeAmplifier = 0;
    private float targetEmissiveBrightness = 0.0f;
    private final RawAnimation IDLE_BLANK_ANIMATION = RawAnimation.begin().thenLoop("idle_blank");
    private final RawAnimation PILLAR_RISE_ANIMATION = RawAnimation.begin().thenPlay("pillar_rise");
    private final RawAnimation PILLAR_DIE_ANIMATION = RawAnimation.begin().thenPlay("pillar_die");
    private final AnimationController<ResonatePillarEntity> controller = new AnimationController((GeoAnimatable)this, "pillar_controller", 0, this::animationPredicate);

    public ResonatePillarEntity(EntityType<? extends Entity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ResonatePillarEntity(Level level, LivingEntity summoner) {
        this((EntityType<? extends Entity>)((EntityType)GGEntities.RESONATE_PILLAR.get()), level);
        this.setSummoner(summoner);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_DAMAGE, (Object)Float.valueOf(8.0f));
        builder.define(DATA_AGE, (Object)0);
        builder.define(DATA_MAX_AGE, (Object)600);
        builder.define(DATA_STAGE, (Object)0);
        builder.define(DATA_SHOCKWAVE_RADIUS, (Object)Float.valueOf(6.0f));
        builder.define(DATA_EMISSIVE_BRIGHTNESS, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putFloat("Damage", this.getDamage());
        tag.putInt("Age", this.getAge());
        tag.putInt("MaxAge", this.getMaxAge());
        tag.putInt("Stage", this.getStageValue());
        tag.putFloat("ShockwaveRadius", this.getShockwaveRadius());
        tag.putInt("LastShockwaveAge", this.lastShockwaveAge);
        tag.putFloat("EmissiveBrightness", this.getEmissiveBrightness());
        tag.putInt("ErodeAmplifier", this.getErodeAmplifier());
        if (this.summonerUUID != null) {
            tag.putUUID("Summoner", this.summonerUUID);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("Age")) {
            this.setAge(tag.getInt("Age"));
        }
        if (tag.contains("MaxAge")) {
            this.setMaxAge(tag.getInt("MaxAge"));
        }
        if (tag.contains("Damage")) {
            this.setDamage(tag.getFloat("Damage"));
        }
        if (tag.contains("Stage")) {
            this.setStage(Stage.fromValue(tag.getInt("Stage")));
        }
        if (tag.contains("ShockwaveRadius")) {
            this.setShockwaveRadius(tag.getFloat("ShockwaveRadius"));
        }
        if (tag.contains("LastShockwaveAge")) {
            this.lastShockwaveAge = tag.getInt("LastShockwaveAge");
        }
        if (tag.contains("EmissiveBrightness")) {
            this.setEmissiveBrightness(tag.getFloat("EmissiveBrightness"));
        }
        if (tag.contains("ErodeAmplifier")) {
            this.setErodeAmplifier(tag.getInt("ErodeAmplifier"));
        }
        if (tag.hasUUID("Summoner")) {
            this.summonerUUID = tag.getUUID("Summoner");
        }
    }

    public int getAge() {
        return (Integer)this.entityData.get(DATA_AGE);
    }

    public void setAge(int age) {
        this.entityData.set(DATA_AGE, (Object)age);
    }

    public int getMaxAge() {
        return (Integer)this.entityData.get(DATA_MAX_AGE);
    }

    public void setMaxAge(int maxAge) {
        this.entityData.set(DATA_MAX_AGE, (Object)maxAge);
    }

    public void setDamage(float damage) {
        this.entityData.set(DATA_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DATA_DAMAGE)).floatValue();
    }

    public Stage getStage() {
        return Stage.fromValue((Integer)this.entityData.get(DATA_STAGE));
    }

    public int getStageValue() {
        return (Integer)this.entityData.get(DATA_STAGE);
    }

    public void setStage(Stage stage) {
        this.entityData.set(DATA_STAGE, (Object)stage.value);
    }

    public float getShockwaveRadius() {
        return ((Float)this.entityData.get(DATA_SHOCKWAVE_RADIUS)).floatValue();
    }

    public void setShockwaveRadius(float radius) {
        this.entityData.set(DATA_SHOCKWAVE_RADIUS, (Object)Float.valueOf(radius));
    }

    public int getErodeAmplifier() {
        return this.erodeAmplifier;
    }

    public void setErodeAmplifier(int amplifier) {
        this.erodeAmplifier = Math.max(0, amplifier);
    }

    public float getEmissiveBrightness() {
        return ((Float)this.entityData.get(DATA_EMISSIVE_BRIGHTNESS)).floatValue();
    }

    public void setEmissiveBrightness(float brightness) {
        this.entityData.set(DATA_EMISSIVE_BRIGHTNESS, (Object)Float.valueOf(brightness));
    }

    public void setSummoner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.summonerUUID = owner.getUUID();
            this.cachedSummoner = owner;
        }
    }

    public LivingEntity getSummoner() {
        if (this.cachedSummoner != null && this.cachedSummoner.isAlive()) {
            return this.cachedSummoner;
        }
        if (this.summonerUUID != null && this.level() instanceof ServerLevel) {
            Entity entity = ((ServerLevel)this.level()).getEntity(this.summonerUUID);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.cachedSummoner = livingEntity = (LivingEntity)entity;
            }
            return this.cachedSummoner;
        }
        return null;
    }

    public void tick() {
        super.tick();
        int currentAge = this.getAge();
        this.setAge(currentAge + 1);
        int age = this.getAge();
        int maxAge = this.getMaxAge();
        int stageProgression = age / 10 % 4;
        this.setStage(Stage.fromValue(stageProgression));
        this.updateEmissiveBrightness();
        Vec3 currentMotion = this.getDeltaMovement();
        double newY = this.applyArtificialGravity(currentMotion.y);
        this.setDeltaMovement(currentMotion.x, newY, currentMotion.z);
        this.move(MoverType.SELF, this.getDeltaMovement());
        Vec3 motion = this.getDeltaMovement();
        this.setDeltaMovement(0.0, motion.y, 0.0);
        if ((age == 1 || age % 60 == 0) && this.onGround()) {
            this.alignToBlockCenter();
        }
        if (this.level().isClientSide) {
            ResonatePillarParticleManager.playWaterfallCascade(this.level(), this.position(), this.getAge(), 1.7);
        }
        if (age - this.lastShockwaveAge >= 40) {
            this.performOwnShockwave();
            this.lastShockwaveAge = age;
            this.secondBlastwaveAge = age + 2;
        }
        if (!this.level().isClientSide && this.secondBlastwaveAge != -1 && age >= this.secondBlastwaveAge) {
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlastwaveParticleOptions(GGGeneralUtil.hexToVector3f(7719759), this.getShockwaveRadius()), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
            this.secondBlastwaveAge = -1;
        }
        if (age - this.lastStage1ShockwaveAge >= 40) {
            this.performResonanceShockwave(Stage.STAGE_1);
            this.lastStage1ShockwaveAge = age;
        }
        if (age - this.lastStage2ShockwaveAge >= 40) {
            this.performResonanceShockwave(Stage.STAGE_2);
            this.lastStage2ShockwaveAge = age;
        }
        if (age - this.lastStage3ShockwaveAge >= 40) {
            this.performResonanceShockwave(Stage.STAGE_3);
            this.lastStage3ShockwaveAge = age;
        }
        if (age >= maxAge) {
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 4.0f, 1.0f);
            if (!this.level().isClientSide) {
                GSLScreenShakeEntity.createScreenShake((Level)this.level(), (Vec3)this.position(), (float)(this.getShockwaveRadius() * 2.0f), (float)0.025f, (int)10, (int)0, (int)5, (boolean)true);
            }
            this.discard();
        }
    }

    private double applyArtificialGravity(double currentY) {
        if (this.onGround()) {
            return Math.max(currentY * 0.8, -0.05);
        }
        double gravity = -0.1;
        double terminalVelocity = -1.5;
        double newY = currentY + gravity;
        return Math.max(newY, terminalVelocity);
    }

    private void alignToBlockCenter() {
        if (!this.onGround()) {
            return;
        }
        Vec3 currentPos = this.position();
        BlockPos groundBlock = this.blockPosition().below();
        BlockState groundState = this.level().getBlockState(groundBlock);
        if (groundState.isAir() || !groundState.isSolidRender((BlockGetter)this.level(), groundBlock)) {
            return;
        }
        double centerX = (double)groundBlock.getX() + 0.5;
        double centerZ = (double)groundBlock.getZ() + 0.5;
        double currentY = currentPos.y;
        double distanceFromCenter = Math.sqrt(Math.pow(currentPos.x - centerX, 2.0) + Math.pow(currentPos.z - centerZ, 2.0));
        if (distanceFromCenter > 0.1) {
            this.teleportTo(centerX, currentY, centerZ);
            Vec3 motion = this.getDeltaMovement();
            this.setDeltaMovement(0.0, motion.y, 0.0);
        }
    }

    private void performOwnShockwave() {
        if (this.level().isClientSide) {
            return;
        }
        LivingEntity owner = this.getSummoner();
        float radius = this.getShockwaveRadius();
        AABB shockwaveArea = new AABB(this.getX() - (double)radius, this.getY() - 1.0, this.getZ() - (double)radius, this.getX() + (double)radius, this.getY() + 2.0, this.getZ() + (double)radius);
        this.level().getEntitiesOfClass(LivingEntity.class, shockwaveArea).stream().filter(entity -> entity.isAlive() && entity.getId() != this.getId() && entity != owner).filter(entity -> entity.distanceTo((Entity)this) <= radius).filter(entity -> owner == null || !GGGeneralUtil.isAlly(owner, entity) && !GGGeneralUtil.isTamed(entity)).forEach(entity -> {
            entity.invulnerableTime = 0;
            DamageSources.applyDamage((Entity)entity, (float)this.getDamage(), (DamageSource)GGSpells.PILLAR_OF_THE_RESOUNDING_EARTH.get().getDamageSource((Entity)this, (Entity)owner));
            if (this.getErodeAmplifier() > 0) {
                entity.addEffect(new MobEffectInstance(GGEffects.ERODE_EFFECT, 60, this.getErodeAmplifier() - 1, false, false, true));
            }
        });
        this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_2.get(), 2.5f, 0.8f);
        GSLScreenShakeEntity.createScreenShake((Level)this.level(), (Vec3)this.position(), (float)(radius * 2.0f), (float)0.01f, (int)8, (int)0, (int)4, (boolean)true);
        MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlastwaveParticleOptions(GGGeneralUtil.hexToVector3f(7719759), this.getShockwaveRadius()), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
        this.createBaseShockwaveParticles();
    }

    private void performResonanceShockwave(Stage forceStage) {
        if (this.level().isClientSide) {
            return;
        }
        int targetIndex = forceStage.value - 1;
        float baseRadius = this.getShockwaveRadius();
        float searchRadius = baseRadius * 2.0f;
        List<Entity> resonanceEntities = this.level().getEntitiesOfClass(Entity.class, new AABB(this.getX() - (double)searchRadius, this.getY() - 20.0, this.getZ() - (double)searchRadius, this.getX() + (double)searchRadius, this.getY() + 20.0, this.getZ() + (double)searchRadius)).stream().filter(entity -> entity.getId() != this.getId()).filter(this::canResonateWith).sorted(Comparator.comparingDouble(entity -> entity.distanceTo((Entity)this))).toList();
        if (resonanceEntities.size() <= targetIndex) {
            return;
        }
        Entity resonanceEntity = resonanceEntities.get(targetIndex);
        Vec3 resonancePosition = resonanceEntity.position();
        LivingEntity owner = this.getSummoner();
        float radiusReduction = 1.0f - (float)forceStage.value * 0.15f;
        float resonanceRadius = baseRadius * radiusReduction;
        float stageMultiplier = 1.0f - (float)forceStage.value * 0.1f;
        float entityMultiplier = this.getEntityResonanceMultiplier(resonanceEntity);
        float baseDamage = this.getDamage();
        float finalDamage = baseDamage * stageMultiplier * entityMultiplier;
        if (resonanceEntity instanceof IResonanceEntity) {
            IResonanceEntity resonanceImpl = (IResonanceEntity)resonanceEntity;
            resonanceImpl.onResonanceActivated(this, forceStage, resonanceRadius, baseDamage, finalDamage, owner);
            this.createSpecialResonanceEffects(resonancePosition, forceStage);
        }
        AABB shockwaveArea = new AABB(resonancePosition.x - (double)resonanceRadius, resonancePosition.y - 1.0, resonancePosition.z - (double)resonanceRadius, resonancePosition.x + (double)resonanceRadius, resonancePosition.y + 2.0, resonancePosition.z + (double)resonanceRadius);
        this.level().getEntitiesOfClass(LivingEntity.class, shockwaveArea).stream().filter(entity -> entity.isAlive() && entity.getId() != this.getId() && entity != owner).filter(entity -> entity.position().distanceTo(resonancePosition) <= (double)resonanceRadius).filter(entity -> owner == null || !GGGeneralUtil.isAlly(owner, entity) && !GGGeneralUtil.isTamed(entity)).filter(entity -> !this.canResonateWith((Entity)entity)).forEach(entity -> {
            entity.invulnerableTime = 0;
            DamageSources.applyDamage((Entity)entity, (float)finalDamage, (DamageSource)GGSpells.PILLAR_OF_THE_RESOUNDING_EARTH.get().getDamageSource((Entity)this, (Entity)owner));
            if (this.getErodeAmplifier() > 0) {
                entity.addEffect(new MobEffectInstance(GGEffects.ERODE_EFFECT, 60, this.getErodeAmplifier() - 1, false, false, true));
            }
            if (resonanceEntity instanceof IResonanceEntity) {
                IResonanceEntity resonanceImpl = (IResonanceEntity)resonanceEntity;
                double distanceFromResonanceSource = entity.position().distanceTo(resonancePosition);
                resonanceImpl.onResonanceShockwave(this, forceStage, owner, (LivingEntity)entity, this.level(), resonancePosition, resonanceRadius, distanceFromResonanceSource, baseDamage, finalDamage);
            }
        });
        this.createResonanceEffects(resonancePosition, resonanceEntity, resonanceRadius, forceStage);
    }

    private boolean canResonateWith(Entity entity) {
        if (entity.getType().is(GGTags.CAN_RESONATE)) {
            return true;
        }
        if (entity instanceof IResonanceEntity) {
            IResonanceEntity resonanceEntity = (IResonanceEntity)entity;
            return resonanceEntity.canResonateWith(this);
        }
        return false;
    }

    private float getEntityResonanceMultiplier(Entity entity) {
        if (entity instanceof IResonanceEntity) {
            IResonanceEntity resonanceEntity = (IResonanceEntity)entity;
            return resonanceEntity.getResonanceMultiplier();
        }
        return 1.0f;
    }

    private void createSpecialResonanceEffects(Vec3 position, Stage stage) {
        if (!this.level().isClientSide) {
            for (int i = 0; i < 8; ++i) {
                double angle = (double)i / 8.0 * 2.0 * Math.PI;
                double radius = 2.0 + (double)stage.value * 0.5;
                double x = position.x + Math.cos(angle) * radius;
                double z = position.z + Math.sin(angle) * radius;
                MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.ENCHANT, (double)x, (double)(position.y + 1.0), (double)z, (int)1, (double)0.0, (double)0.1, (double)0.0, (double)0.02, (boolean)false);
            }
        }
    }

    private void createResonanceEffects(Vec3 position, Entity resonanceEntity, float radius, Stage stage) {
        GSLScreenShakeEntity.createScreenShake((Level)this.level(), (Vec3)resonanceEntity.position(), (float)this.getShockwaveRadius(), (float)0.007f, (int)6, (int)0, (int)2, (boolean)true);
        float basePitch = 0.8f;
        float stagePitch = basePitch + (float)stage.value * 0.1f;
        this.level().playSound(null, resonanceEntity.getX(), resonanceEntity.getY(), resonanceEntity.getZ(), (SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_SMALL.get(), SoundSource.AMBIENT, 1.5f, stagePitch);
        Vector3f particleColor = GGSchools.GEO.get().getTargetingColor();
        if (resonanceEntity instanceof IResonanceEntity) {
            IResonanceEntity resonanceImpl = (IResonanceEntity)resonanceEntity;
            particleColor = resonanceImpl.getResonanceParticleColor();
        }
        MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlastwaveParticleOptions(particleColor, radius), (double)position.x, (double)(position.y + (double)0.165f), (double)position.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
        if (!this.level().isClientSide) {
            this.createResonanceShockwaveParticles(position, radius, stage);
        }
    }

    private void createBaseShockwaveParticles() {
        float radius = this.getShockwaveRadius();
        Vec3 center = this.position();
        float radiusScale = radius / 6.0f;
        int basaltCount = Math.round(50.0f * radiusScale);
        for (int i = 0; i < basaltCount; ++i) {
            double angle = (double)i / (double)basaltCount * 2.0 * Math.PI;
            double distance = 1.0 + this.random.nextDouble() * ((double)radius - 1.0);
            double x = center.x + Math.cos(angle) * distance;
            double z = center.z + Math.sin(angle) * distance;
            double y = center.y + 0.1 + this.random.nextDouble() * 0.3;
            double velX = Math.cos(angle) * (0.3 + this.random.nextDouble() * 0.4);
            double velY = 0.1 + this.random.nextDouble() * 0.3;
            double velZ = Math.sin(angle) * (0.3 + this.random.nextDouble() * 0.4);
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.BASALT.defaultBlockState()), (double)x, (double)y, (double)z, (int)1, (double)velX, (double)velY, (double)velZ, (double)0.0, (boolean)false);
        }
        int debrisCount = Math.round(16.0f * radiusScale);
        for (int i = 0; i < debrisCount; ++i) {
            double x = center.x + (this.random.nextDouble() - 0.5) * (double)radius * 2.0;
            double z = center.z + (this.random.nextDouble() - 0.5) * (double)radius * 2.0;
            double y = center.y + this.random.nextDouble() * 1.5;
            double velX = (this.random.nextDouble() - 0.5) * 0.2;
            double velY = this.random.nextDouble() * 0.4;
            double velZ = (this.random.nextDouble() - 0.5) * 0.2;
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.COBBLESTONE.defaultBlockState()), (double)x, (double)y, (double)z, (int)1, (double)velX, (double)velY, (double)velZ, (double)0.0, (boolean)false);
        }
        int smokeCount = Math.round(12.0f * radiusScale);
        for (int i = 0; i < smokeCount; ++i) {
            double x = center.x + (this.random.nextDouble() - 0.5) * (double)radius;
            double z = center.z + (this.random.nextDouble() - 0.5) * (double)radius;
            double y = center.y + 0.5 + this.random.nextDouble();
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)x, (double)y, (double)z, (int)1, (double)0.0, (double)0.02, (double)0.0, (double)0.01, (boolean)false);
        }
    }

    private void createResonanceShockwaveParticles(Vec3 center, float radius, Stage stage) {
        float radiusScale = radius / 6.0f;
        int baseParticleCount = Math.round(20.0f * radiusScale);
        int particleCount = Math.max(5, baseParticleCount - stage.value * 3);
        for (int i = 0; i < particleCount; ++i) {
            double angle = (double)i / (double)particleCount * 2.0 * Math.PI;
            double distance = 0.5 + this.random.nextDouble() * ((double)radius * 0.8);
            double x = center.x + Math.cos(angle) * distance;
            double z = center.z + Math.sin(angle) * distance;
            double y = center.y + this.random.nextDouble() * 0.2;
            double velX = Math.cos(angle) * (0.2 + this.random.nextDouble() * 0.2);
            double velY = 0.05 + this.random.nextDouble() * 0.2;
            double velZ = Math.sin(angle) * (0.2 + this.random.nextDouble() * 0.2);
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.BASALT.defaultBlockState()), (double)x, (double)y, (double)z, (int)1, (double)velX, (double)velY, (double)velZ, (double)0.0, (boolean)false);
        }
        int groundCount = Math.max(2, Math.round(8.0f * radiusScale - (float)(stage.value * 2)));
        for (int i = 0; i < groundCount; ++i) {
            double x = center.x + (this.random.nextDouble() - 0.5) * (double)radius;
            double z = center.z + (this.random.nextDouble() - 0.5) * (double)radius;
            double y = center.y - 0.3 + this.random.nextDouble() * 0.1;
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.STONE.defaultBlockState()), (double)x, (double)y, (double)z, (int)1, (double)0.0, (double)0.1, (double)0.0, (double)0.02, (boolean)false);
        }
    }

    public void onAntiMagic(MagicData playerMagicData) {
        this.discard();
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean isNoGravity() {
        return false;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return false;
    }

    private PlayState animationPredicate(AnimationState<ResonatePillarEntity> event) {
        int age = this.getAge();
        int maxAge = this.getMaxAge();
        if (age <= 10) {
            event.getController().setAnimation(this.PILLAR_RISE_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (age >= maxAge - 10) {
            event.getController().setAnimation(this.PILLAR_DIE_ANIMATION);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(this.IDLE_BLANK_ANIMATION);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(this.controller);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private void updateEmissiveBrightness() {
        Stage currentStage = this.getStage();
        float targetBrightness = switch (currentStage.ordinal()) {
            case 0 -> 0.8f;
            case 1 -> 0.8f;
            case 2 -> 0.4f;
            case 3 -> 0.1f;
            default -> 0.0f;
        };
        this.targetEmissiveBrightness = targetBrightness;
        float newBrightness = this.getNewBrightness(targetBrightness);
        this.setEmissiveBrightness(newBrightness);
    }

    private float getNewBrightness(float targetBrightness) {
        float lerpSpeed = 0.15f;
        float currentBrightness = this.getEmissiveBrightness();
        float newBrightness = Mth.lerp((float)lerpSpeed, (float)currentBrightness, (float)targetBrightness);
        if (Math.abs(newBrightness - targetBrightness) < 0.005f) {
            newBrightness = targetBrightness;
        }
        return newBrightness;
    }

    public static enum Stage {
        STAGE_0(0),
        STAGE_1(1),
        STAGE_2(2),
        STAGE_3(3);

        public final int value;

        private Stage(int value) {
            this.value = value;
        }

        public static Stage fromValue(int value) {
            for (Stage stage : Stage.values()) {
                if (stage.value != value) continue;
                return stage;
            }
            return STAGE_0;
        }
    }
}

