/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonate_pillar;

import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonate_pillar.ResonatePillarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.redspace.ironsspellbooks.api.util.Utils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

@OnlyIn(value=Dist.CLIENT)
public class ResonatePillarEntityLayer
extends GeoRenderLayer<ResonatePillarEntity> {
    public static final ResourceLocation BASE_EMISSIVE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"textures/models/entity/resonate_pillar/resonate_pillar_layer_base.png");
    public static final ResourceLocation RESONATE_EMISSIVE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"textures/models/entity/resonate_pillar/resonate_pillar_layer_resonate.png");

    public ResonatePillarEntityLayer(GeoRenderer<ResonatePillarEntity> entityRenderer) {
        super(entityRenderer);
    }

    public void render(PoseStack poseStack, ResonatePillarEntity animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        float glowIntensity = animatable.getEmissiveBrightness();
        if (glowIntensity <= 0.0f) {
            return;
        }
        ResourceLocation emissiveTexture = this.getEmissiveTexture(animatable);
        RenderType glowRenderType = RenderType.eyes((ResourceLocation)emissiveTexture);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(glowRenderType);
        poseStack.pushPose();
        int packedColor = Utils.packRGB((Vector3f)new Vector3f(glowIntensity, glowIntensity, glowIntensity));
        this.getRenderer().actuallyRender(poseStack, (GeoAnimatable)animatable, bakedModel, glowRenderType, bufferSource, vertexConsumer, true, partialTick, 0xF000F0, OverlayTexture.NO_OVERLAY, packedColor);
        poseStack.popPose();
    }

    private ResourceLocation getEmissiveTexture(ResonatePillarEntity animatable) {
        ResonatePillarEntity.Stage stage = animatable.getStage();
        switch (stage) {
            case STAGE_0: {
                return BASE_EMISSIVE_TEXTURE;
            }
            case STAGE_1: 
            case STAGE_2: 
            case STAGE_3: {
                return RESONATE_EMISSIVE_TEXTURE;
            }
        }
        return BASE_EMISSIVE_TEXTURE;
    }
}

