/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonator;

import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.entity.IResonanceEntity;
import com.gametechbc.gtbcs_geomancy_plus.api.util.GGGeneralUtil;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonate_pillar.ResonatePillarEntity;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonator.ResonatorParticleManager;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEffects;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ResonatorEntity
extends Entity
implements GeoEntity,
AntiMagicSusceptible,
IResonanceEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_AGE = SynchedEntityData.defineId(ResonatorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_MAX_AGE = SynchedEntityData.defineId(ResonatorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_SHOCKWAVE_RADIUS = SynchedEntityData.defineId(ResonatorEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_EMISSIVE_BRIGHTNESS = SynchedEntityData.defineId(ResonatorEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_HIT_EFFECT_TIMER = SynchedEntityData.defineId(ResonatorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private UUID summonerUUID;
    private LivingEntity cachedSummoner;
    private int maxAegisAmplifier = 3;
    private int erodeEffectAmplifier = 1;
    private final RawAnimation IDLE_BLANK_ANIMATION = RawAnimation.begin().thenLoop("idle_blank");
    private final RawAnimation PILLAR_RISE_ANIMATION = RawAnimation.begin().thenPlay("pillar_rise");
    private final RawAnimation PILLAR_DIE_ANIMATION = RawAnimation.begin().thenPlay("pillar_die");
    private final AnimationController<ResonatorEntity> controller = new AnimationController((GeoAnimatable)this, "pillar_controller", 0, this::animationPredicate);

    public ResonatorEntity(EntityType<? extends Entity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ResonatorEntity(Level level, LivingEntity summoner) {
        this((EntityType<? extends Entity>)((EntityType)GGEntities.RESONATOR.get()), level);
        this.setSummoner(summoner);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_AGE, (Object)0);
        builder.define(DATA_MAX_AGE, (Object)600);
        builder.define(DATA_SHOCKWAVE_RADIUS, (Object)Float.valueOf(6.0f));
        builder.define(DATA_EMISSIVE_BRIGHTNESS, (Object)Float.valueOf(0.0f));
        builder.define(DATA_HIT_EFFECT_TIMER, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("Age", this.getAge());
        tag.putInt("MaxAge", this.getMaxAge());
        tag.putFloat("ShockwaveRadius", this.getEffectRadius());
        tag.putFloat("EmissiveBrightness", this.getEmissiveBrightness());
        tag.putInt("MaxAegisAmplifier", this.maxAegisAmplifier);
        tag.putInt("HitEffectTimer", this.getHitEffectTimer());
        tag.putInt("ErodeEffectAmplifier", this.erodeEffectAmplifier);
        if (this.summonerUUID != null) {
            tag.putUUID("Summoner", this.summonerUUID);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("Age")) {
            this.setAge(tag.getInt("Age"));
        }
        if (tag.contains("MaxAge")) {
            this.setMaxAge(tag.getInt("MaxAge"));
        }
        if (tag.contains("ShockwaveRadius")) {
            this.setEffectRadius(tag.getFloat("ShockwaveRadius"));
        }
        if (tag.contains("EmissiveBrightness")) {
            this.setEmissiveBrightness(tag.getFloat("EmissiveBrightness"));
        }
        if (tag.contains("MaxAegisAmplifier")) {
            this.maxAegisAmplifier = tag.getInt("MaxAegisAmplifier");
        }
        if (tag.contains("HitEffectTimer")) {
            this.setHitEffectTimer(tag.getInt("HitEffectTimer"));
        }
        if (tag.contains("ErodeEffectAmplifier")) {
            this.erodeEffectAmplifier = tag.getInt("ErodeEffectAmplifier");
        }
        if (tag.hasUUID("Summoner")) {
            this.summonerUUID = tag.getUUID("Summoner");
        }
    }

    public int getAge() {
        return (Integer)this.entityData.get(DATA_AGE);
    }

    public void setAge(int age) {
        this.entityData.set(DATA_AGE, (Object)age);
    }

    public int getMaxAge() {
        return (Integer)this.entityData.get(DATA_MAX_AGE);
    }

    public void setMaxAge(int maxAge) {
        this.entityData.set(DATA_MAX_AGE, (Object)maxAge);
    }

    public float getEffectRadius() {
        return ((Float)this.entityData.get(DATA_SHOCKWAVE_RADIUS)).floatValue();
    }

    public void setEffectRadius(float radius) {
        this.entityData.set(DATA_SHOCKWAVE_RADIUS, (Object)Float.valueOf(radius));
    }

    public int getMaxAegisAmplifier() {
        return this.maxAegisAmplifier;
    }

    public void setMaxAegisAmplifier(int maxAmplifier) {
        this.maxAegisAmplifier = Math.max(0, Math.min(maxAmplifier, 15));
    }

    public int getResonanceErodeEffectAmplifier() {
        return this.erodeEffectAmplifier;
    }

    public void setResonanceErodeEffectAmplifier(int amplifier) {
        this.erodeEffectAmplifier = Math.max(0, amplifier);
    }

    public float getEmissiveBrightness() {
        return ((Float)this.entityData.get(DATA_EMISSIVE_BRIGHTNESS)).floatValue();
    }

    public void setEmissiveBrightness(float brightness) {
        this.entityData.set(DATA_EMISSIVE_BRIGHTNESS, (Object)Float.valueOf(brightness));
    }

    public int getHitEffectTimer() {
        return (Integer)this.entityData.get(DATA_HIT_EFFECT_TIMER);
    }

    public void setHitEffectTimer(int timer) {
        this.entityData.set(DATA_HIT_EFFECT_TIMER, (Object)timer);
    }

    public void triggerHitEffect() {
        this.setHitEffectTimer(10);
    }

    public void setSummoner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.summonerUUID = owner.getUUID();
            this.cachedSummoner = owner;
        }
    }

    public LivingEntity getSummoner() {
        if (this.cachedSummoner != null && this.cachedSummoner.isAlive()) {
            return this.cachedSummoner;
        }
        if (this.summonerUUID != null && this.level() instanceof ServerLevel) {
            Entity entity = ((ServerLevel)this.level()).getEntity(this.summonerUUID);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.cachedSummoner = livingEntity = (LivingEntity)entity;
            }
            return this.cachedSummoner;
        }
        return null;
    }

    @Override
    public float getResonanceMultiplier() {
        return 1.15f;
    }

    @Override
    public void onResonanceShockwave(ResonatePillarEntity pillar, ResonatePillarEntity.Stage stage, LivingEntity owner, LivingEntity target, Level world, Vec3 resonancePosition, float resonanceRadius, double distanceFromSource, float baseDamage, float finalDamage) {
        IResonanceEntity.super.onResonanceShockwave(pillar, stage, owner, target, world, resonancePosition, resonanceRadius, distanceFromSource, baseDamage, finalDamage);
    }

    @Override
    public boolean canResonateWith(ResonatePillarEntity pillar) {
        LivingEntity pillarOwner = pillar.getSummoner();
        LivingEntity thisOwner = this.getSummoner();
        return pillarOwner != null && thisOwner != null && pillarOwner.getUUID().equals(thisOwner.getUUID());
    }

    @Override
    public Vector3f getResonanceParticleColor() {
        return GGGeneralUtil.hexToVector3f(7719759);
    }

    public void tick() {
        int hitTimer;
        super.tick();
        int currentAge = this.getAge();
        this.setAge(currentAge + 1);
        int age = this.getAge();
        int maxAge = this.getMaxAge();
        this.updateEmissiveBrightness();
        Vec3 currentMotion = this.getDeltaMovement();
        double newY = this.applyArtificialGravity(currentMotion.y);
        this.setDeltaMovement(currentMotion.x, newY, currentMotion.z);
        this.move(MoverType.SELF, this.getDeltaMovement());
        Vec3 motion = this.getDeltaMovement();
        this.setDeltaMovement(0.0, motion.y, 0.0);
        if ((age == 1 || age % 60 == 0) && this.onGround()) {
            this.alignToBlockCenter();
        }
        if ((hitTimer = this.getHitEffectTimer()) > 0) {
            this.setHitEffectTimer(hitTimer - 1);
            ResonatorParticleManager.spawnHitEffect(this.level(), this.position(), this.getEffectRadius(), hitTimer);
        }
        if (this.tickCount % 2 == 0) {
            ResonatorParticleManager.spawnAegisRadiusRing(this.level(), this.position(), this.getEffectRadius(), this.getAge());
        }
        if (!this.level().isClientSide && this.tickCount % 40 == 0) {
            this.performAegisShockwave();
        }
        if (age >= maxAge) {
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM_2.get(), 3.0f, 1.0f);
            this.discard();
        }
    }

    private double applyArtificialGravity(double currentY) {
        if (this.onGround()) {
            return Math.max(currentY * 0.8, -0.05);
        }
        double gravity = -0.1;
        double terminalVelocity = -1.5;
        double newY = currentY + gravity;
        return Math.max(newY, terminalVelocity);
    }

    private void alignToBlockCenter() {
        if (!this.onGround()) {
            return;
        }
        Vec3 currentPos = this.position();
        BlockPos groundBlock = this.blockPosition().below();
        BlockState groundState = this.level().getBlockState(groundBlock);
        if (groundState.isAir() || !groundState.isSolidRender((BlockGetter)this.level(), groundBlock)) {
            return;
        }
        double centerX = (double)groundBlock.getX() + 0.5;
        double centerZ = (double)groundBlock.getZ() + 0.5;
        double currentY = currentPos.y;
        double distanceFromCenter = Math.sqrt(Math.pow(currentPos.x - centerX, 2.0) + Math.pow(currentPos.z - centerZ, 2.0));
        if (distanceFromCenter > 0.1) {
            this.teleportTo(centerX, currentY, centerZ);
            Vec3 motion = this.getDeltaMovement();
            this.setDeltaMovement(0.0, motion.y, 0.0);
        }
    }

    private void performAegisShockwave() {
        LivingEntity summoner = this.getSummoner();
        float radius = this.getEffectRadius();
        AABB aegisArea = new AABB(this.getX() - (double)radius, this.getY() - 2.0, this.getZ() - (double)radius, this.getX() + (double)radius, this.getY() + 4.0, this.getZ() + (double)radius);
        List<LivingEntity> targets = this.level().getEntitiesOfClass(LivingEntity.class, aegisArea).stream().filter(entity -> entity.isAlive() && entity.distanceTo((Entity)this) <= radius).filter(entity -> {
            if (entity == summoner) {
                return true;
            }
            if (summoner != null) {
                return GGGeneralUtil.isAlly(summoner, entity) || GGGeneralUtil.isTamed(entity);
            }
            return false;
        }).toList();
        for (LivingEntity target : targets) {
            int currentAmplifier = 0;
            if (target.hasEffect(GGEffects.AEGIS_EFFECT)) {
                currentAmplifier = target.getEffect(GGEffects.AEGIS_EFFECT).getAmplifier();
            }
            int newAmplifier = Math.min(currentAmplifier + 1, this.getMaxAegisAmplifier());
            target.addEffect(new MobEffectInstance(GGEffects.AEGIS_EFFECT, 100, newAmplifier, false, false, true));
        }
        if (!targets.isEmpty()) {
            this.triggerHitEffect();
        }
    }

    public void onAntiMagic(MagicData playerMagicData) {
        this.discard();
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean isNoGravity() {
        return false;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return false;
    }

    private PlayState animationPredicate(AnimationState<ResonatorEntity> event) {
        int age = this.getAge();
        int maxAge = this.getMaxAge();
        if (age <= 10) {
            event.getController().setAnimation(this.PILLAR_RISE_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (age >= maxAge - 10) {
            event.getController().setAnimation(this.PILLAR_DIE_ANIMATION);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(this.IDLE_BLANK_ANIMATION);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(this.controller);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private void updateEmissiveBrightness() {
        int maxAge;
        int age = this.getAge();
        if (age >= (maxAge = this.getMaxAge()) - 60) {
            double blinkCycle = Math.sin((double)age * 0.3) * 0.5 + 0.5;
            float blinkBrightness = blinkCycle > 0.5 ? 0.8f : 0.4f;
            this.setEmissiveBrightness(blinkBrightness);
        } else {
            double breathingCycle = Math.sin((double)age * 0.05) * 0.5 + 0.5;
            float breathingBrightness = (float)(0.3 + breathingCycle * 0.5);
            this.setEmissiveBrightness(breathingBrightness);
        }
    }
}

