/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.seismic_ride;

import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.spelllib.entity.GSLScreenShakeEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SeismicRideEntity
extends Mob
implements GeoEntity,
AntiMagicSusceptible {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.defineId(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_AGE = SynchedEntityData.defineId(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_MAX_AGE = SynchedEntityData.defineId(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_RESTING_INITIAL = SynchedEntityData.defineId(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_RISING = SynchedEntityData.defineId(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_RESTING_HOVER = SynchedEntityData.defineId(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_GOING_FORWARD = SynchedEntityData.defineId(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_GOING_DOWN = SynchedEntityData.defineId(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> GOING_DOWN_START_AGE = SynchedEntityData.defineId(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final float targetHoverYLevel = 25.0f;
    private static final int MINIMUM_MAX_AGE = 980;
    private float forwardSpeed = 0.3f;
    private UUID summonerUUID;
    private LivingEntity cachedSummoner;
    private final RawAnimation RIDE_BUILDING_ANIMATION = RawAnimation.begin().thenPlayAndHold("ride_building");
    private final AnimationController<SeismicRideEntity> controller = new AnimationController((GeoAnimatable)this, "seismic_ride_controller", 0, this::animationPredicate);

    public SeismicRideEntity(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SeismicRideEntity(Level level, LivingEntity summoner) {
        this((EntityType<? extends Mob>)((EntityType)GGEntities.SEISMIC_RIDE.get()), level);
        this.setSummoner(summoner);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_DAMAGE, (Object)Float.valueOf(5.0f));
        builder.define(DATA_AGE, (Object)0);
        builder.define(DATA_MAX_AGE, (Object)1000);
        builder.define(IS_RESTING_INITIAL, (Object)true);
        builder.define(IS_RISING, (Object)false);
        builder.define(IS_RESTING_HOVER, (Object)false);
        builder.define(IS_GOING_FORWARD, (Object)false);
        builder.define(IS_GOING_DOWN, (Object)false);
        builder.define(GOING_DOWN_START_AGE, (Object)-1);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("Damage", this.getDamage());
        tag.putInt("Age", this.getAge());
        tag.putInt("MaxAge", this.getMaxAge());
        tag.putFloat("ForwardSpeed", this.forwardSpeed);
        tag.putInt("GoingDownStartAge", this.getGoingDownStartAge());
        tag.putBoolean("IsRestingInitial", this.isRestingInitial());
        tag.putBoolean("IsRising", this.isRising());
        tag.putBoolean("IsRestingHover", this.isRestingHover());
        tag.putBoolean("IsGoingForward", this.isGoingForward());
        tag.putBoolean("IsGoingDown", this.isGoingDown());
        if (this.summonerUUID != null) {
            tag.putUUID("Summoner", this.summonerUUID);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Age")) {
            this.setAge(tag.getInt("Age"));
        }
        if (tag.contains("MaxAge")) {
            this.setMaxAge(tag.getInt("MaxAge"));
        }
        if (tag.contains("ForwardSpeed")) {
            this.forwardSpeed = tag.getFloat("ForwardSpeed");
        }
        if (tag.contains("GoingDownStartAge")) {
            this.setGoingDownStartAge(tag.getInt("GoingDownStartAge"));
        }
        if (tag.contains("Damage")) {
            this.setDamage(tag.getFloat("Damage"));
        }
        if (tag.contains("IsRestingInitial")) {
            this.setRestingInitial(tag.getBoolean("IsRestingInitial"));
        }
        if (tag.contains("IsRising")) {
            this.setRising(tag.getBoolean("IsRising"));
        }
        if (tag.contains("IsRestingHover")) {
            this.setRestingHover(tag.getBoolean("IsRestingHover"));
        }
        if (tag.contains("IsGoingForward")) {
            this.setGoingForward(tag.getBoolean("IsGoingForward"));
        }
        if (tag.contains("IsGoingDown")) {
            this.setGoingDown(tag.getBoolean("IsGoingDown"));
        }
        if (tag.hasUUID("Summoner")) {
            this.summonerUUID = tag.getUUID("Summoner");
        }
    }

    public int getAge() {
        return (Integer)this.entityData.get(DATA_AGE);
    }

    public void setAge(int age) {
        this.entityData.set(DATA_AGE, (Object)age);
    }

    public int getMaxAge() {
        return (Integer)this.entityData.get(DATA_MAX_AGE);
    }

    public void setMaxAge(int maxAge) {
        this.entityData.set(DATA_MAX_AGE, (Object)Math.max(maxAge, 980));
    }

    public int getGoingDownStartAge() {
        return (Integer)this.entityData.get(GOING_DOWN_START_AGE);
    }

    public void setGoingDownStartAge(int age) {
        this.entityData.set(GOING_DOWN_START_AGE, (Object)age);
    }

    public void setDamage(float damage) {
        this.entityData.set(DATA_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DATA_DAMAGE)).floatValue();
    }

    public float getForwardSpeed() {
        return this.forwardSpeed;
    }

    public void setForwardSpeed(float speed) {
        this.forwardSpeed = speed;
    }

    public boolean isRestingInitial() {
        return (Boolean)this.entityData.get(IS_RESTING_INITIAL);
    }

    public void setRestingInitial(boolean value) {
        this.entityData.set(IS_RESTING_INITIAL, (Object)value);
    }

    public boolean isRising() {
        return (Boolean)this.entityData.get(IS_RISING);
    }

    public void setRising(boolean value) {
        this.entityData.set(IS_RISING, (Object)value);
    }

    public boolean isRestingHover() {
        return (Boolean)this.entityData.get(IS_RESTING_HOVER);
    }

    public void setRestingHover(boolean value) {
        this.entityData.set(IS_RESTING_HOVER, (Object)value);
    }

    public boolean isGoingForward() {
        return (Boolean)this.entityData.get(IS_GOING_FORWARD);
    }

    public void setGoingForward(boolean value) {
        this.entityData.set(IS_GOING_FORWARD, (Object)value);
    }

    public boolean isGoingDown() {
        return (Boolean)this.entityData.get(IS_GOING_DOWN);
    }

    public void setGoingDown(boolean value) {
        this.entityData.set(IS_GOING_DOWN, (Object)value);
    }

    private void setPhase(boolean initial, boolean rising, boolean hover, boolean forward, boolean down) {
        this.setRestingInitial(initial);
        this.setRising(rising);
        this.setRestingHover(hover);
        this.setGoingForward(forward);
        this.setGoingDown(down);
    }

    public void setSummoner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.summonerUUID = owner.getUUID();
            this.cachedSummoner = owner;
        }
    }

    public LivingEntity getSummoner() {
        Level level;
        if (this.cachedSummoner != null && this.cachedSummoner.isAlive()) {
            return this.cachedSummoner;
        }
        if (this.summonerUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = serverLevel.getEntity(this.summonerUUID);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.cachedSummoner = livingEntity = (LivingEntity)entity;
            }
            return this.cachedSummoner;
        }
        return null;
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        if (this.isVehicle()) {
            return super.mobInteract(pPlayer, pHand);
        }
        if (pPlayer == this.getSummoner()) {
            this.doPlayerRide(pPlayer);
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    protected void doPlayerRide(Player pPlayer) {
        if (!this.level().isClientSide) {
            pPlayer.setYRot(this.getYRot());
            pPlayer.setXRot(this.getXRot());
            pPlayer.startRiding((Entity)this);
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof Mob) {
            return (Mob)entity;
        }
        entity = this.getFirstPassenger();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    protected void tickRidden(Player player, Vec3 movementVector) {
        super.tickRidden(player, movementVector);
        this.yRotO = this.getYRot();
        if (this.isGoingForward()) {
            this.setYRot(player.getYRot());
            this.setRot(this.getYRot(), this.getXRot());
            this.yHeadRot = this.getYRot();
        }
        this.yBodyRot = this.yRotO;
    }

    protected Vec3 getRiddenInput(Player player, Vec3 playerMovementInput) {
        return Vec3.ZERO;
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.isPassengerOfSameVehicle(passenger)) {
            float yOffset = 2.45f;
            moveFunction.accept(passenger, this.getX(), this.getY() + (double)yOffset, this.getZ());
        } else {
            super.positionRider(passenger, moveFunction);
        }
    }

    public void tick() {
        super.tick();
        int currentAge = this.getAge();
        this.setAge(currentAge + 1);
        int age = this.getAge();
        int maxAge = this.getMaxAge();
        if (!this.isGoingDown() && age >= maxAge - 220) {
            this.setGoingDown(true);
            this.setGoingDownStartAge(age);
            this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
            if (!this.level().isClientSide) {
                GSLScreenShakeEntity.createScreenShake((Level)this.level(), (Vec3)this.position(), (float)6.0f, (float)0.008f, (int)10, (int)0, (int)5, (boolean)false);
            }
        }
        if (this.isGoingDown()) {
            int goingDownStartAge = this.getGoingDownStartAge();
            int goingDownAge = age - goingDownStartAge;
            if (goingDownAge <= 60) {
                this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
                BlockPos groundPos = this.findGroundBelow();
                double groundHeight = groundPos.getY() + 1;
                double targetHeight = groundHeight + 25.0;
                double hoverOffset = 0.5 * Math.sin((double)age * 0.25);
                double hoverY = targetHeight + hoverOffset;
                double deltaY = hoverY - this.getY();
                if (Math.abs(deltaY) > 0.02) {
                    Vec3 motion = this.getDeltaMovement();
                    this.setDeltaMovement(motion.x, deltaY * 0.25, motion.z);
                }
                this.fallDistance = 0.0f;
                this.setOnGround(false);
            } else if (goingDownAge <= 220) {
                double descendProgress;
                double scaledProgress;
                BlockPos groundPos;
                double groundHeight;
                double desiredY;
                double deltaY;
                if (goingDownAge == 61 && !this.level().isClientSide) {
                    this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_LOOP.get(), 2.5f, 1.0f);
                }
                if (!this.level().isClientSide && (goingDownAge - 61) % 60 == 0 && goingDownAge > 61) {
                    this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_LOOP.get(), 2.5f, 1.0f);
                }
                if (Math.abs(deltaY = (desiredY = (groundHeight = (double)((groundPos = this.findGroundBelow()).getY() + 1)) + 25.0 * (scaledProgress = Math.cos((descendProgress = (double)(goingDownAge - 60) / 160.0) * Math.PI * 0.5))) - this.getY()) > 0.02) {
                    this.setDeltaMovement(0.0, deltaY * 0.1, 0.0);
                    this.hasImpulse = true;
                }
                this.fallDistance = 0.0f;
                this.setOnGround(false);
                if (!this.level().isClientSide) {
                    AABB boundingBox = this.getBoundingBox();
                    for (int i = 0; i < 3; ++i) {
                        double d0 = boundingBox.minX + (boundingBox.maxX - boundingBox.minX) * this.random.nextDouble();
                        double d1 = boundingBox.minY + (boundingBox.maxY - boundingBox.minY) * this.random.nextDouble();
                        double d2 = boundingBox.minZ + (boundingBox.maxZ - boundingBox.minZ) * this.random.nextDouble();
                        double d3 = (this.random.nextDouble() - 0.5) * 0.1;
                        double d4 = 0.05 + this.random.nextDouble() * 0.1;
                        double d5 = (this.random.nextDouble() - 0.5) * 0.1;
                        MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DEEPSLATE.defaultBlockState()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
                    }
                }
            } else {
                this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 2.5f, 1.0f);
                if (!this.level().isClientSide) {
                    GSLScreenShakeEntity.createScreenShake((Level)this.level(), (Vec3)this.position(), (float)12.0f, (float)0.04f, (int)10, (int)0, (int)10, (boolean)false);
                    this.spawnDiscardBlast();
                    this.spawnFallingBlockBlast();
                }
                this.discard();
            }
        } else if (age <= 100) {
            if (!this.isRestingInitial()) {
                this.setPhase(true, false, false, false, false);
                if (!this.level().isClientSide) {
                    this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_LOOP.get(), 2.5f, 1.0f);
                }
            }
            if (age <= 40 && age % 5 == 0 && !this.level().isClientSide) {
                if (age == 40) {
                    this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1.get(), 1.0f, 1.0f);
                } else {
                    float randomPitch = 0.8f + this.random.nextFloat() * 0.4f;
                    this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_SMALL.get(), 1.0f, randomPitch);
                }
            }
            this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
        } else if (age <= 260) {
            double risingProgress;
            double scaledProgress;
            BlockPos groundPos;
            double groundHeight;
            double desiredY;
            double deltaY;
            if (this.isRestingInitial() || !this.isRising()) {
                this.setPhase(false, true, false, false, false);
                if (!this.level().isClientSide) {
                    GSLScreenShakeEntity.createScreenShake((Level)this.level(), (Vec3)this.position(), (float)6.0f, (float)0.008f, (int)10, (int)0, (int)5, (boolean)false);
                    this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_LOOP.get(), 2.5f, 1.0f);
                }
            }
            if (Math.abs(deltaY = (desiredY = (groundHeight = (double)((groundPos = this.findGroundBelow()).getY() + 1)) + 25.0 * (scaledProgress = Math.sin((risingProgress = (double)(age - 100) / 160.0) * Math.PI * 0.5))) - this.getY()) > 0.02) {
                this.setDeltaMovement(0.0, deltaY * 0.1, 0.0);
                this.hasImpulse = true;
            }
            this.fallDistance = 0.0f;
            this.setOnGround(false);
            if (!this.level().isClientSide) {
                AABB boundingBox = this.getBoundingBox();
                for (int i = 0; i < 2; ++i) {
                    double d0 = boundingBox.minX + (boundingBox.maxX - boundingBox.minX) * this.random.nextDouble();
                    double d1 = boundingBox.minY + (boundingBox.maxY - boundingBox.minY) * this.random.nextDouble();
                    double d2 = boundingBox.minZ + (boundingBox.maxZ - boundingBox.minZ) * this.random.nextDouble();
                    double d3 = (this.random.nextDouble() - 0.5) * 0.05;
                    double d4 = -0.1 - this.random.nextDouble() * 0.05;
                    double d5 = (this.random.nextDouble() - 0.5) * 0.05;
                    MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DEEPSLATE.defaultBlockState()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
                }
            }
            if (!this.level().isClientSide && (age - 100) % 60 == 0 && age > 100) {
                this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_LOOP.get(), 2.5f, 1.0f);
            }
        } else if (age <= 360) {
            if (this.isRising() || !this.isRestingHover()) {
                this.setPhase(false, false, true, false, false);
                if (!this.level().isClientSide) {
                    GSLScreenShakeEntity.createScreenShake((Level)this.level(), (Vec3)this.position(), (float)6.0f, (float)0.008f, (int)10, (int)0, (int)5, (boolean)false);
                }
            }
            this.maintainHoverHeight();
        } else {
            if (this.isRestingHover() || !this.isGoingForward()) {
                this.setPhase(false, false, false, true, false);
                if (!this.level().isClientSide) {
                    this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_2.get(), 2.5f, 1.0f);
                }
            }
            Vec3 forward = this.getLookAngle().normalize().scale((double)this.forwardSpeed);
            this.setDeltaMovement(forward.x, this.getDeltaMovement().y, forward.z);
            this.maintainHoverHeight();
            this.hasImpulse = true;
            if (!this.level().isClientSide) {
                Vec3 velocity = this.getDeltaMovement();
                AABB boundingBox = this.getBoundingBox();
                for (int i = 0; i < 2; ++i) {
                    double d0 = boundingBox.minX + (boundingBox.maxX - boundingBox.minX) * this.random.nextDouble();
                    double d1 = boundingBox.minY + (boundingBox.maxY - boundingBox.minY) * this.random.nextDouble();
                    double d2 = boundingBox.minZ + (boundingBox.maxZ - boundingBox.minZ) * this.random.nextDouble();
                    double d3 = -velocity.x * 0.8 + (this.random.nextDouble() - 0.5) * 0.1;
                    double d4 = this.random.nextDouble() * 0.05 + 0.01;
                    double d5 = -velocity.z * 0.8 + (this.random.nextDouble() - 0.5) * 0.1;
                    MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DEEPSLATE.defaultBlockState()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
                }
                if (this.tickCount % 2 == 0) {
                    double d0 = this.getX() - velocity.x * 1.5 + (this.random.nextDouble() - 0.5);
                    double d1 = this.getY() + this.random.nextDouble() * 0.5;
                    double d2 = this.getZ() - velocity.z * 1.5 + (this.random.nextDouble() - 0.5);
                    double d3 = (this.random.nextDouble() - 0.5) * 0.02;
                    double d4 = this.random.nextDouble() * 0.02 + 0.01;
                    double d5 = (this.random.nextDouble() - 0.5) * 0.02;
                    MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
                }
            }
        }
    }

    private BlockPos findGroundBelow() {
        BlockPos groundPos = this.blockPosition().below();
        while (this.level().isEmptyBlock(groundPos) && groundPos.getY() > this.level().getMinBuildHeight()) {
            groundPos = groundPos.below();
        }
        return groundPos;
    }

    private void maintainHoverHeight() {
        double hoverOffset;
        BlockPos groundPos = this.findGroundBelow();
        double groundHeight = groundPos.getY() + 1;
        double targetHeight = groundHeight + 25.0;
        double hoverY = targetHeight + (hoverOffset = 0.5 * Math.sin((double)this.getAge() * 0.25));
        double deltaY = hoverY - this.getY();
        if (Math.abs(deltaY) > 0.02) {
            Vec3 motion = this.getDeltaMovement();
            this.setDeltaMovement(motion.x, deltaY * 0.25, motion.z);
        }
        this.fallDistance = 0.0f;
        this.setOnGround(false);
    }

    private void spawnDiscardBlast() {
        for (int i = 0; i < 30; ++i) {
            double d0 = this.getX() + (this.random.nextDouble() - 0.5) * 10.0;
            double d1 = this.getY() + this.random.nextDouble() * 5.0;
            double d2 = this.getZ() + (this.random.nextDouble() - 0.5) * 10.0;
            double d3 = (this.random.nextDouble() - 0.5) * 0.5;
            double d4 = this.random.nextDouble() * 0.4 + 0.1;
            double d5 = (this.random.nextDouble() - 0.5) * 0.5;
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DEEPSLATE.defaultBlockState()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
        }
    }

    private void spawnFallingBlockBlast() {
        AABB boundingBox = this.getBoundingBox();
        Vec3 center = boundingBox.getCenter();
        int particleCount = 6;
        for (int i = 0; i < particleCount; ++i) {
            double d3 = (this.random.nextDouble() - 0.5) * 1.5;
            double d4 = this.random.nextDouble() * 0.9 + 0.3;
            double d5 = (this.random.nextDouble() - 0.5) * 1.5;
            int duration = 80 + this.random.nextInt(41);
            EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), this.level(), duration, Blocks.COBBLED_DEEPSLATE.defaultBlockState());
            fallingBlock.setPos(center.x, center.y, center.z);
            fallingBlock.setDeltaMovement(d3, d4, d5);
            this.level().addFreshEntity((Entity)fallingBlock);
        }
    }

    public void onAntiMagic(MagicData playerMagicData) {
        if (this.getAge() < 40) {
            return;
        }
        this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 2.5f, 1.0f);
        if (!this.level().isClientSide) {
            GSLScreenShakeEntity.createScreenShake((Level)this.level(), (Vec3)this.position(), (float)12.0f, (float)0.008f, (int)10, (int)0, (int)5, (boolean)false);
        }
        if (!this.isGoingDown()) {
            this.setGoingDown(true);
            this.setGoingDownStartAge(this.getAge());
            this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
        }
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return false;
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.MAX_HEALTH, 800.0).add(Attributes.FOLLOW_RANGE, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 100.0).add(Attributes.MOVEMENT_SPEED, 0.0);
    }

    private PlayState animationPredicate(AnimationState<SeismicRideEntity> event) {
        event.getController().setAnimation(this.RIDE_BUILDING_ANIMATION);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(this.controller);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

