/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.seismic_ride;

import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.seismic_ride.SeismicRideEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.redspace.ironsspellbooks.api.util.Utils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

@OnlyIn(value=Dist.CLIENT)
public class SeismicRideEntityLayer
extends GeoRenderLayer<SeismicRideEntity> {
    public static final ResourceLocation EMISSIVE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"textures/models/entity/seismic_ride/seismic_ride_layer.png");

    public SeismicRideEntityLayer(GeoRenderer<SeismicRideEntity> entityRenderer) {
        super(entityRenderer);
    }

    public void render(PoseStack poseStack, SeismicRideEntity animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        float glowIntensity = SeismicRideEntityLayer.getGlowIntensity(animatable, partialTick);
        if (glowIntensity <= 0.0f) {
            return;
        }
        RenderType glowRenderType = RenderType.eyes((ResourceLocation)EMISSIVE_TEXTURE);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(glowRenderType);
        poseStack.pushPose();
        int packedColor = Utils.packRGB((Vector3f)new Vector3f(glowIntensity, glowIntensity, glowIntensity));
        this.getRenderer().actuallyRender(poseStack, (GeoAnimatable)animatable, bakedModel, glowRenderType, bufferSource, vertexConsumer, true, partialTick, 0xF000F0, OverlayTexture.NO_OVERLAY, packedColor);
        poseStack.popPose();
    }

    private static float getGlowIntensity(SeismicRideEntity animatable, float partialTick) {
        float glowIntensity;
        if (animatable.isRestingInitial() || animatable.isRestingHover()) {
            float time = (float)animatable.tickCount + partialTick;
            glowIntensity = 0.65f + 0.35f * Mth.sin((float)(time * 0.15f));
        } else {
            glowIntensity = animatable.isRising() ? 0.8f : (animatable.isGoingForward() ? 1.0f : 0.0f);
        }
        return glowIntensity;
    }
}

