/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.tremor_spike;

import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import com.gametechbc.gtbcs_geomancy_plus.util.GGTags;
import io.redspace.ironsspellbooks.damage.DamageSources;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TremorSpikeEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> ACTIVATE = SynchedEntityData.defineId(TremorSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(TremorSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> WARMUP_TICKS = SynchedEntityData.defineId(TremorSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_RISING = SynchedEntityData.defineId(TremorSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_GOING_DOWN = SynchedEntityData.defineId(TremorSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> VARIANT_TYPE = SynchedEntityData.defineId(TremorSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int warmupDelayTicks;
    private LivingEntity caster;
    private UUID casterUuid;
    private boolean hasDamaged = false;
    private int riseTickCount = 0;
    private boolean hasDetectedBlock = false;
    public static final int VARIANT_DIRT = 0;
    public static final int VARIANT_GRASS = 1;
    public static final int VARIANT_COBBLESTONE = 2;
    public static final int VARIANT_DEEPSLATE = 3;
    private static final RawAnimation BLANK_ANIM = RawAnimation.begin().thenLoop("blank");
    private static final RawAnimation SPIKE_RISE_ANIM = RawAnimation.begin().thenPlay("spike_rise");
    private final AnimationController<TremorSpikeEntity> controller = new AnimationController((GeoAnimatable)this, "spike_controller", 0, this::animationPredicate);

    public TremorSpikeEntity(EntityType<? extends TremorSpikeEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public TremorSpikeEntity(Level worldIn, double x, double y, double z, float yRot, int warmupDelay, float damage, LivingEntity casterIn) {
        this((EntityType<? extends TremorSpikeEntity>)((EntityType)GGEntities.TREMOR_SPIKE.get()), worldIn);
        this.warmupDelayTicks = warmupDelay;
        this.setCaster(casterIn);
        this.setDamage(damage);
        this.setWarmupTicks(warmupDelay);
        this.setYRot(yRot);
        this.setPos(x, y, z);
        this.detectBlockBeneath();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ACTIVATE, (Object)false);
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
        builder.define(WARMUP_TICKS, (Object)0);
        builder.define(IS_RISING, (Object)false);
        builder.define(IS_GOING_DOWN, (Object)false);
        builder.define(VARIANT_TYPE, (Object)0);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            tag.putUUID("Owner", this.casterUuid);
        }
        tag.putFloat("damage", this.getDamage());
        tag.putInt("variantType", this.getVariantType());
        tag.putBoolean("hasDetectedBlock", this.hasDetectedBlock);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.warmupDelayTicks = tag.getInt("Warmup");
        if (tag.hasUUID("Owner")) {
            this.casterUuid = tag.getUUID("Owner");
        }
        this.setDamage(tag.getFloat("damage"));
        if (tag.contains("variantType")) {
            this.setVariantType(tag.getInt("variantType"));
        }
        this.hasDetectedBlock = tag.getBoolean("hasDetectedBlock");
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.entityData.set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public int getWarmupTicks() {
        return (Integer)this.entityData.get(WARMUP_TICKS);
    }

    public void setWarmupTicks(int ticks) {
        this.entityData.set(WARMUP_TICKS, (Object)ticks);
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
        this.casterUuid = caster == null ? null : caster.getUUID();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public boolean isActivate() {
        return (Boolean)this.entityData.get(ACTIVATE);
    }

    public void setActivate(boolean activate) {
        this.entityData.set(ACTIVATE, (Object)activate);
    }

    public boolean isRising() {
        return (Boolean)this.entityData.get(IS_RISING);
    }

    public void setRising(boolean rising) {
        this.entityData.set(IS_RISING, (Object)rising);
    }

    public boolean isGoingDown() {
        return (Boolean)this.entityData.get(IS_GOING_DOWN);
    }

    public void setGoingDown(boolean goingDown) {
        this.entityData.set(IS_GOING_DOWN, (Object)goingDown);
    }

    public int getVariantType() {
        return (Integer)this.entityData.get(VARIANT_TYPE);
    }

    public void setVariantType(int variantType) {
        this.entityData.set(VARIANT_TYPE, (Object)variantType);
    }

    public boolean isDirtVariant() {
        return this.getVariantType() == 0;
    }

    public boolean isGrassVariant() {
        return this.getVariantType() == 1;
    }

    public boolean isCobblestoneVariant() {
        return this.getVariantType() == 2;
    }

    public boolean isDeepslateVariant() {
        return this.getVariantType() == 3;
    }

    private void detectBlockBeneath() {
        BlockPos posBelow = this.blockPosition().below();
        BlockState blockBelow = this.level().getBlockState(posBelow);
        int variantType = blockBelow.is(Blocks.GRASS_BLOCK) ? 1 : (blockBelow.is(GGTags.IS_COBBLESTONE_CATEGORY) ? 2 : (blockBelow.is(GGTags.IS_DEEPSLATE_CATEGORY) ? 3 : 0));
        this.setVariantType(variantType);
        this.hasDetectedBlock = true;
    }

    public void tick() {
        super.tick();
        if (this.tickCount == 1 && !this.hasDetectedBlock && !this.level().isClientSide) {
            this.detectBlockBeneath();
        }
        if (this.level().isClientSide) {
            if (this.isRising()) {
                this.spawnBlockDiggingParticles();
            }
            if (this.isGoingDown()) {
                this.spawnGoingDownParticles();
            }
        } else {
            int currentWarmup = this.getWarmupTicks();
            if (currentWarmup > 0) {
                this.setWarmupTicks(currentWarmup - 1);
            } else if (!this.isActivate()) {
                this.setActivate(true);
                this.setRising(true);
            }
            if (this.isActivate()) {
                ++this.riseTickCount;
                if (this.riseTickCount == 7) {
                    this.setRising(false);
                    if (!this.hasDamaged) {
                        this.dealDamageOnce();
                        this.hasDamaged = true;
                    }
                    this.setGoingDown(true);
                }
                if (this.riseTickCount >= 20) {
                    this.discard();
                }
            }
        }
    }

    private void dealDamageOnce() {
        for (LivingEntity livingentity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.2, 0.0, 0.2))) {
            this.damage(livingentity);
        }
    }

    private void damage(LivingEntity hitEntity) {
        LivingEntity livingentity = this.getCaster();
        if (hitEntity.isAlive() && !hitEntity.isInvulnerable() && hitEntity != livingentity) {
            if (livingentity == null) {
                hitEntity.hurt(this.damageSources().magic(), this.getDamage());
            } else if (!livingentity.isAlliedTo((Entity)hitEntity) && !hitEntity.isAlliedTo((Entity)livingentity)) {
                DamageSources.applyDamage((Entity)hitEntity, (float)this.getDamage(), (DamageSource)GGSpells.TREMOR_SPIKE_SPELL.get().getDamageSource((Entity)this, (Entity)this.getCaster()));
            }
        }
    }

    private void spawnBlockDiggingParticles() {
        for (int i = 0; i < 3; ++i) {
            BlockState block = this.level().getBlockState(this.blockPosition().below());
            double d0 = this.getX() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
            double d1 = this.getY() + 0.03;
            double d2 = this.getZ() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
            double d3 = this.random.nextGaussian() * 0.07;
            double d4 = this.random.nextGaussian() * 0.07;
            double d5 = this.random.nextGaussian() * 0.07;
            if (block.getRenderShape() == RenderShape.INVISIBLE) continue;
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), d0, d1, d2, d3, d4, d5);
        }
    }

    private void spawnGoingDownParticles() {
        for (int i = 0; i < 1; ++i) {
            BlockState spikeBlock = this.getBlockForVariant();
            double d0 = this.getX() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.6;
            double d1 = this.getY() + 0.5 + this.random.nextDouble() * 0.8;
            double d2 = this.getZ() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.6;
            double d3 = (this.random.nextDouble() * 2.0 - 1.0) * 0.15;
            double d4 = -0.1 - this.random.nextDouble() * 0.2;
            double d5 = (this.random.nextDouble() * 2.0 - 1.0) * 0.15;
            if (spikeBlock.getRenderShape() == RenderShape.INVISIBLE) continue;
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, spikeBlock), d0, d1, d2, d3, d4, d5);
        }
    }

    private BlockState getBlockForVariant() {
        return switch (this.getVariantType()) {
            case 1 -> Blocks.GRASS_BLOCK.defaultBlockState();
            case 2 -> Blocks.COBBLESTONE.defaultBlockState();
            case 3 -> Blocks.DEEPSLATE.defaultBlockState();
            default -> Blocks.DIRT.defaultBlockState();
        };
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(this.controller);
    }

    private PlayState animationPredicate(AnimationState<TremorSpikeEntity> state) {
        if (this.isActivate()) {
            state.getController().setAnimation(SPIKE_RISE_ANIM);
        } else {
            state.getController().setAnimation(BLANK_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

