/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.network;

import com.gametechbc.gtbcs_geomancy_plus.util.GGClientCastHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientboundEarthExplosionParticles
implements CustomPacketPayload {
    private final Vec3 pos;
    private final float radius;
    public static final CustomPacketPayload.Type<ClientboundEarthExplosionParticles> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"earth_explosion_particles"));
    public static final StreamCodec<FriendlyByteBuf, ClientboundEarthExplosionParticles> STREAM_CODEC = CustomPacketPayload.codec(ClientboundEarthExplosionParticles::write, ClientboundEarthExplosionParticles::new);

    public ClientboundEarthExplosionParticles(Vec3 pos, float radius) {
        this.pos = pos;
        this.radius = radius;
    }

    public ClientboundEarthExplosionParticles(FriendlyByteBuf buf) {
        this.pos = buf.readVec3();
        this.radius = buf.readFloat();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVec3(this.pos);
        buf.writeFloat(this.radius);
    }

    public static void handle(ClientboundEarthExplosionParticles packet, IPayloadContext context) {
        context.enqueueWork(() -> GGClientCastHelper.handleClientboundEarthExplosion(packet.pos, packet.radius));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

