/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.particle.glowing_enchantment;

import com.gametechbc.gtbcs_geomancy_plus.particle.glowing_enchantment.GlowingEnchantmentParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlowingEnchantmentParticle
extends TextureSheetParticle {
    private final double xStart;
    private final double yStart;
    private final double zStart;
    private final boolean fallAtEnd;

    public GlowingEnchantmentParticle(ClientLevel level, double x, double y, double z, SpriteSet sprite, double xd, double yd, double zd, GlowingEnchantmentParticleOptions options) {
        super(level, x, y, z);
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.xStart = x;
        this.yStart = y;
        this.zStart = z;
        this.xo = x + xd;
        this.yo = y + yd;
        this.zo = z + zd;
        this.x = this.xo;
        this.y = this.yo;
        this.z = this.zo;
        this.quadSize = options.getScale();
        this.rCol = options.getColor().x();
        this.gCol = options.getColor().y();
        this.bCol = options.getColor().z();
        this.fallAtEnd = options.shouldFallAtEnd();
        this.hasPhysics = false;
        this.lifetime = options.getLifespan();
        this.pickSprite(sprite);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void move(double x, double y, double z) {
        this.setBoundingBox(this.getBoundingBox().move(x, y, z));
        this.setLocationFromBoundingbox();
    }

    public int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            float f = (float)this.age / (float)this.lifetime;
            f = 1.0f - f;
            float f1 = 1.0f - f;
            f1 *= f1;
            f1 *= f1;
            this.x = this.xStart + this.xd * (double)f;
            this.y = this.fallAtEnd ? this.yStart + this.yd * (double)f - (double)(f1 * 1.2f) : this.yStart + this.yd * (double)f;
            this.z = this.zStart + this.zd * (double)f;
            this.setPos(this.x, this.y, this.z);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<GlowingEnchantmentParticleOptions> {
        private final SpriteSet sprite;

        public Provider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(GlowingEnchantmentParticleOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new GlowingEnchantmentParticle(level, x, y, z, this.sprite, xd, yd, zd, options);
        }
    }
}

