/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.particle.glowing_enchantment;

import com.gametechbc.gtbcs_geomancy_plus.init.GGParticles;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class GlowingEnchantmentParticleOptions
implements ParticleOptions {
    private final Vector3f color;
    private final float scale;
    private final boolean fallAtEnd;
    private final int lifespan;
    public static final StreamCodec<ByteBuf, GlowingEnchantmentParticleOptions> STREAM_CODEC = StreamCodec.of((buf, option) -> {
        buf.writeFloat(option.color.x());
        buf.writeFloat(option.color.y());
        buf.writeFloat(option.color.z());
        buf.writeFloat(option.scale);
        buf.writeBoolean(option.fallAtEnd);
        buf.writeInt(option.lifespan);
    }, buf -> new GlowingEnchantmentParticleOptions(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readBoolean(), buf.readInt()));
    public static final MapCodec<GlowingEnchantmentParticleOptions> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(p -> Float.valueOf(p.color.x())), (App)Codec.FLOAT.fieldOf("g").forGetter(p -> Float.valueOf(p.color.y())), (App)Codec.FLOAT.fieldOf("b").forGetter(p -> Float.valueOf(p.color.z())), (App)Codec.FLOAT.fieldOf("scale").forGetter(p -> Float.valueOf(p.scale)), (App)Codec.BOOL.fieldOf("fall_at_end").forGetter(p -> p.fallAtEnd), (App)Codec.INT.fieldOf("lifespan").forGetter(p -> p.lifespan)).apply((Applicative)instance, GlowingEnchantmentParticleOptions::new));

    public GlowingEnchantmentParticleOptions(Vector3f color, float scale, boolean fallAtEnd, int lifespan) {
        this.color = color;
        this.scale = scale;
        this.fallAtEnd = fallAtEnd;
        this.lifespan = Math.max(1, lifespan);
    }

    public GlowingEnchantmentParticleOptions(float r, float g, float b, float scale, boolean fallAtEnd, int lifespan) {
        this(new Vector3f(r, g, b), scale, fallAtEnd, lifespan);
    }

    public Vector3f getColor() {
        return this.color;
    }

    public float getScale() {
        return this.scale;
    }

    public boolean shouldFallAtEnd() {
        return this.fallAtEnd;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    @NotNull
    public ParticleType<?> getType() {
        return GGParticles.GLOWING_ENCHANT.get();
    }
}

