/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.spells.geo;

import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.chunker.ChunkerEntity;
import com.gametechbc.spelllib.entity.GSLScreenShakeEntity;
import com.gametechbc.spelllib.particle.AdvancedLineParticleManager;
import com.gametechbc.spelllib.particle.ParticleDirection;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class ChunkerSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"chunker");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(GGSchools.GEO_RESOURCE).setMaxLevel(6).setCooldownSeconds(22.0).build();

    public ChunkerSpell() {
        this.manaCostPerLevel = 50;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 30;
        this.baseManaCost = 70;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_2.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1.get());
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        AdvancedLineParticleManager.spawnParticles((Level)level, (Entity)entity, (int)10, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DIRT.defaultBlockState()), (ParticleDirection)ParticleDirection.UPWARD, (double)8.0, (double)3.5, (double)this.getSpawnOffset(), (double)2.5, (boolean)false);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        this.spawnChunker(level, entity, spellLevel);
        GSLScreenShakeEntity.createScreenShake((Level)level, (Vec3)entity.position(), (float)12.0f, (float)0.02f, (int)10, (int)0, (int)5, (boolean)false);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnChunker(Level level, LivingEntity caster, int spellLevel) {
        Vec3 spawnPosition = this.calculateSpawnPosition(caster, this.getSpawnOffset());
        ChunkerEntity chunker = new ChunkerEntity(level, caster);
        chunker.setPos(spawnPosition.x, spawnPosition.y, spawnPosition.z);
        chunker.setYRot(caster.getYRot());
        chunker.setXRot(0.0f);
        chunker.setMaxAge(this.getDuration(spellLevel));
        chunker.setDamage(this.getDamage(spellLevel, caster));
        level.addFreshEntity((Entity)chunker);
    }

    private Vec3 calculateSpawnPosition(LivingEntity caster, double offset) {
        Vec3 lookDirection = caster.getLookAngle();
        return caster.position().add(lookDirection.x * offset, 0.0, lookDirection.z * offset);
    }

    private double getSpawnOffset() {
        return 4.0;
    }

    public int getDuration(int spellLevel) {
        return 110 + spellLevel * 20;
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return 1.0f + this.getSpellPower(spellLevel, (Entity)entity) * 3.5f;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.STOMP;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.gtbcs_geomancy_plus.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.translatable((String)"ui.gtbcs_geomancy_plus.duration", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(spellLevel), (int)1)}), Component.translatable((String)"ui.gtbcs_geomancy_plus.on_resonate"), Component.translatable((String)"ui.gtbcs_geomancy_plus.resonate_multiplier", (Object[])new Object[]{"0.8"}), Component.translatable((String)"ui.gtbcs_geomancy_plus.chunker_resonate_bonus"), Component.literal((String)"\u00a79GTBC'S Geomancy Plus"));
    }
}

