/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.spells.geo;

import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityFissure;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.entity.extended.projectiles.ExtendedEntityFissure;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.spelllib.entity.GSLScreenShakeEntity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class FissureSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"fissure");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(GGSchools.GEO_RESOURCE).setMaxLevel(8).setCooldownSeconds(15.0).build();

    public FissureSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 30;
        this.baseManaCost = 15;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.SLASH_ANIMATION;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)MMSounds.ENTITY_BLUFF_ATTACK.get());
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        ExtendedEntityFissure fissure = new ExtendedEntityFissure((EntityType<? extends EntityFissure>)((EntityType)GGEntities.EXTENDED_FISSURE.get()), level);
        fissure.setOwner((Entity)entity);
        fissure.setPos(entity.position());
        Vec3 shootVec = entity.getLookAngle().normalize();
        fissure.shoot(shootVec.x, shootVec.z);
        fissure.setSpikeDamage(this.getDamage(entity, spellLevel));
        level.addFreshEntity((Entity)fissure);
        entity.playSound((SoundEvent)MMSounds.ENTITY_UMVUTHI_BURST.get(), 1.0f, 1.2f);
        this.spawnCastParticles(level, entity);
        GSLScreenShakeEntity.createScreenShake((Level)level, (Vec3)entity.position(), (float)6.0f, (float)0.008f, (int)5, (int)0, (int)5, (boolean)false);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnCastParticles(Level level, LivingEntity caster) {
        BlockState blockBeneath = level.getBlockState(caster.getOnPos());
        for (int i = 0; i < 30; ++i) {
            double xOffset = caster.getRandom().nextFloat() * 3.0f - 1.5f;
            double zOffset = caster.getRandom().nextFloat() * 3.0f - 1.5f;
            double yPosition = (float)caster.getBlockY() + 0.1f;
            Vec3 velocity = new Vec3((double)(caster.getRandom().nextFloat() * 3.0f - 1.5f), 2.2, (double)(caster.getRandom().nextFloat() * 3.0f - 1.5f));
            MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockBeneath), (double)(caster.getX() + xOffset), (double)yPosition, (double)(caster.getZ() + zOffset), (int)1, (double)velocity.x, (double)velocity.y, (double)velocity.z, (double)0.1, (boolean)true);
        }
    }

    public float getDamage(LivingEntity caster, int spellLevel) {
        return 4.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.5f;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.gtbcs_geomancy_plus.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(caster, spellLevel), (int)2)}), Component.literal((String)"\u00a79GTBC'S Geomancy Plus"));
    }
}

