/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.spells.geo;

import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonator.ResonatorEntity;
import com.gametechbc.spelllib.particle.AdvancedSphereParticleManager;
import com.gametechbc.spelllib.particle.ParticleDirection;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class GeoConductorSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"geo_conductor");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(GGSchools.GEO_RESOURCE).setMaxLevel(3).setCooldownSeconds(75.0).build();

    public GeoConductorSpell() {
        this.manaCostPerLevel = 60;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 60;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)MMSounds.EFFECT_GEOMANCY_SMALL_CRASH.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)MMSounds.EFFECT_GEOMANCY_SMALL_CRASH.get());
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return 3;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 100, castSource, null), playerMagicData);
        }
        this.spawnResonator(level, entity, spellLevel);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnResonator(Level level, LivingEntity caster, int spellLevel) {
        Vec3 spawnPosition = this.performRaycast(caster, this.getRaycastRange());
        if (spawnPosition == null) {
            return;
        }
        AdvancedSphereParticleManager.spawnParticles((Level)level, (double)spawnPosition.x, (double)(spawnPosition.y + 1.0), (double)spawnPosition.z, (int)40, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DEEPSLATE.defaultBlockState()), (ParticleDirection)ParticleDirection.OUTWARD, (double)0.8, (boolean)false);
        ResonatorEntity resonator = new ResonatorEntity(level, caster);
        resonator.setPos(spawnPosition.x, spawnPosition.y, spawnPosition.z);
        resonator.setMaxAge(this.getDuration(spellLevel));
        resonator.setEffectRadius(this.getEffectRadius(spellLevel));
        resonator.setMaxAegisAmplifier(this.getMaxAegisAmplifier(spellLevel, caster));
        level.addFreshEntity((Entity)resonator);
    }

    private Vec3 performRaycast(LivingEntity caster, double range) {
        Vec3 eyePos = caster.getEyePosition();
        Vec3 lookDirection = caster.getLookAngle();
        Vec3 endPos = eyePos.add(lookDirection.scale(range));
        BlockHitResult hitResult = caster.level().clip(new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)caster));
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            BlockPos hitPos = hitResult.getBlockPos();
            return new Vec3((double)hitPos.getX() + 0.5, (double)hitPos.getY() + 1.0, (double)hitPos.getZ() + 0.5);
        }
        return null;
    }

    private double getRaycastRange() {
        return 30.0;
    }

    private float getEffectRadius(int spellLevel) {
        return 2.5f + (float)spellLevel * 0.5f;
    }

    private int getMaxAegisAmplifier(int spellLevel, LivingEntity caster) {
        return Math.max(1, (int)(1.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.0f));
    }

    public int getDuration(int spellLevel) {
        return 200 + spellLevel * 200;
    }

    public static List<MutableComponent> getAegisEffectTooltip(int amplifier) {
        float armorGain = (float)amplifier * 0.025f;
        float spellResistGain = (float)amplifier * 0.0125f;
        return List.of(Component.translatable((String)"ui.gtbcs_geomancy_plus.armor_gain", (Object[])new Object[]{Utils.stringTruncation((double)(armorGain * 100.0f), (int)2)}), Component.translatable((String)"ui.gtbcs_geomancy_plus.spell_resist_gain", (Object[])new Object[]{Utils.stringTruncation((double)(spellResistGain * 100.0f), (int)2)}));
    }

    public static List<MutableComponent> getResonateEffectTooltip() {
        return List.of(Component.translatable((String)"ui.gtbcs_geomancy_plus.on_resonate"), Component.translatable((String)"ui.gtbcs_geomancy_plus.resonate_multiplier", (Object[])new Object[]{"1.15"}));
    }

    public static List<MutableComponent> buildResonatorSpellInfo(Integer aegisAmplifier, boolean includeFooter, MutableComponent ... coreStats) {
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>(List.of(coreStats));
        if (aegisAmplifier != null && aegisAmplifier > 0) {
            tooltip.addAll(GeoConductorSpell.getAegisEffectTooltip(aegisAmplifier));
        }
        tooltip.addAll(GeoConductorSpell.getResonateEffectTooltip());
        if (includeFooter) {
            tooltip.add(Component.literal((String)"\u00a79GTBC'S Geomancy Plus"));
        }
        return tooltip;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        MutableComponent[] coreStats = new MutableComponent[]{Component.translatable((String)"ui.gtbcs_geomancy_plus.duration", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(spellLevel), (int)1)}), Component.translatable((String)"ui.gtbcs_geomancy_plus.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getEffectRadius(spellLevel), (int)1)})};
        return GeoConductorSpell.buildResonatorSpellInfo(this.getMaxAegisAmplifier(spellLevel, caster), true, coreStats);
    }
}

