/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.spells.geo;

import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.petrivise_pillar.PetrivisePillarEntity;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEffects;
import com.gametechbc.gtbcs_geomancy_plus.spells.GGSpellAnimations;
import com.gametechbc.spelllib.entity.GSLScreenShakeEntity;
import com.gametechbc.spelllib.particle.AdvancedLineParticleManager;
import com.gametechbc.spelllib.particle.ParticleDirection;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

@AutoSpellConfig
public class PetriviseSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"petrivise");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(GGSchools.GEO_RESOURCE).setMaxLevel(3).setCooldownSeconds(25.0).build();

    public PetriviseSpell() {
        this.manaCostPerLevel = 60;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 60;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_1.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1.get());
    }

    public AnimationHolder getCastStartAnimation() {
        return GGSpellAnimations.PETRIVISE_CAST;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        AdvancedLineParticleManager.spawnParticles((Level)level, (Entity)entity, (int)10, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.BEDROCK.defaultBlockState()), (ParticleDirection)ParticleDirection.UPWARD, (double)16.0, (double)4.0, (double)3.0, (double)3.0, (boolean)false);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        this.spawnPillarWalls(level, entity, spellLevel);
        GSLScreenShakeEntity.createScreenShake((Level)level, (Vec3)entity.position(), (float)24.0f, (float)0.015f, (int)26, (int)0, (int)12, (boolean)true);
        entity.addEffect(new MobEffectInstance(GGEffects.CASTING_EFFECT, 40, 3, false, false, false));
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnPillarWalls(Level level, LivingEntity caster, int spellLevel) {
        Vec3 lookDirection = caster.getLookAngle();
        Vec3 horizontalLook = new Vec3(lookDirection.x, 0.0, lookDirection.z).normalize();
        Vec3 rightDirection = new Vec3(-horizontalLook.z, 0.0, horizontalLook.x).normalize();
        Vec3 leftDirection = rightDirection.scale(-1.0);
        float sideDistance = 6.0f;
        int pillarCount = 20;
        float damage = this.getDamage(spellLevel, caster);
        float slamSpeed = 0.6f;
        int baseSlamDelay = 5;
        float casterYaw = caster.getYRot();
        float rightToLeftYaw = casterYaw - 90.0f;
        float leftToRightYaw = casterYaw + 90.0f;
        for (int i = 0; i < pillarCount; ++i) {
            float forwardDistance = i;
            int warmupDelay = i;
            int slamDelay = baseSlamDelay + (pillarCount - 1 - i);
            int pillarId = i + 1;
            Vec3 rightPillarPos = caster.position().add(horizontalLook.scale((double)forwardDistance)).add(rightDirection.scale((double)sideDistance));
            Vec3 rightGroundPos = this.findGroundLevel(level, rightPillarPos);
            PetrivisePillarEntity rightPillar = new PetrivisePillarEntity(level, rightGroundPos.x, rightGroundPos.y, rightGroundPos.z, rightToLeftYaw, warmupDelay, slamDelay, slamSpeed, damage, pillarId, caster);
            if (i == 8) {
                rightPillar.setEnableScreenShake(true);
            }
            level.addFreshEntity((Entity)rightPillar);
            Vec3 leftPillarPos = caster.position().add(horizontalLook.scale((double)forwardDistance)).add(leftDirection.scale((double)sideDistance));
            Vec3 leftGroundPos = this.findGroundLevel(level, leftPillarPos);
            PetrivisePillarEntity leftPillar = new PetrivisePillarEntity(level, leftGroundPos.x, leftGroundPos.y, leftGroundPos.z, leftToRightYaw, warmupDelay, slamDelay, slamSpeed, damage, pillarId, caster);
            if (i == 8) {
                leftPillar.setEnableScreenShake(true);
            }
            level.addFreshEntity((Entity)leftPillar);
        }
    }

    private Vec3 findGroundLevel(Level level, Vec3 position) {
        double casterHeadY = position.y + 1.0;
        int standOnYPos = Mth.floor((double)position.y) - 2;
        BlockPos pos = new BlockPos((int)position.x, (int)casterHeadY, (int)position.z);
        boolean foundGround = false;
        double heightOffset = 0.0;
        do {
            BlockState currentBlockState;
            VoxelShape voxelShape;
            BlockPos belowPos;
            BlockState blockState;
            if (!(blockState = level.getBlockState(belowPos = pos.below())).isFaceSturdy((BlockGetter)level, belowPos, Direction.UP)) continue;
            if (!level.isEmptyBlock(pos) && !(voxelShape = (currentBlockState = level.getBlockState(pos)).getCollisionShape((BlockGetter)level, pos)).isEmpty()) {
                heightOffset = voxelShape.max(Direction.Axis.Y);
            }
            foundGround = true;
            break;
        } while ((pos = pos.below()).getY() >= Mth.floor((float)standOnYPos) - 1);
        if (foundGround) {
            return new Vec3(position.x, (double)pos.getY() + heightOffset, position.z);
        }
        return position;
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return 15.0f + this.getSpellPower(spellLevel, (Entity)entity) * 5.0f;
    }

    private float getPillars() {
        return 20.0f;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.gtbcs_geomancy_plus.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.translatable((String)"ui.gtbcs_geomancy_plus.pillar_walls", (Object[])new Object[]{Utils.stringTruncation((double)this.getPillars(), (int)2)}), Component.translatable((String)"ui.gtbcs_geomancy_plus.on_resonate"), Component.translatable((String)"ui.gtbcs_geomancy_plus.resonate_multiplier", (Object[])new Object[]{"1.0"}), Component.translatable((String)"ui.gtbcs_geomancy_plus.petrivise_resonate_bonus"), Component.literal((String)"\u00a79GTBC'S Geomancy Plus"));
    }
}

