/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.spells.geo;

import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonate_pillar.ResonatePillarEntity;
import com.gametechbc.gtbcs_geomancy_plus.spells.GGSpellAnimations;
import com.gametechbc.spelllib.entity.GSLScreenShakeEntity;
import com.gametechbc.spelllib.particle.AdvancedCylinderParticleManager;
import com.gametechbc.spelllib.particle.AdvancedSphereParticleManager;
import com.gametechbc.spelllib.particle.ParticleDirection;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class PillarOfTheResoundingEarthSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"pillar_of_the_resounding_earth");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(GGSchools.GEO_RESOURCE).setMaxLevel(6).setCooldownSeconds(75.0).build();

    public PillarOfTheResoundingEarthSpell() {
        this.manaCostPerLevel = 30;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 20;
        this.baseManaCost = 70;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_1.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get());
    }

    public AnimationHolder getCastStartAnimation() {
        return GGSpellAnimations.RESONATE_PILLAR_CHARGE;
    }

    public AnimationHolder getCastFinishAnimation() {
        return GGSpellAnimations.RESONATE_PILLAR_CAST;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        Vec3 spawnPosition = this.calculateSpawnPosition(entity, this.getSpawnOffset());
        AdvancedSphereParticleManager.spawnParticles((Level)level, (double)spawnPosition.x, (double)(spawnPosition.y + 0.5), (double)spawnPosition.z, (int)3, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.BASALT.defaultBlockState()), (ParticleDirection)ParticleDirection.INWARD, (double)2.5, (boolean)false);
        if (playerMagicData != null && (playerMagicData.getCastDurationRemaining() + 1) % 5 == 0) {
            GSLScreenShakeEntity.createScreenShake((Level)level, (Vec3)entity.position(), (float)12.0f, (float)0.008f, (int)6, (int)0, (int)0, (boolean)false);
        }
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        this.removeExistingPillars(level, entity, 64.0);
        this.spawnResonatePillar(level, entity, spellLevel);
        GSLScreenShakeEntity.createScreenShake((Level)level, (Vec3)entity.position(), (float)20.0f, (float)0.03f, (int)5, (int)5, (int)5, (boolean)true);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void removeExistingPillars(Level level, LivingEntity caster, double radius) {
        Vec3 casterPos = caster.position();
        AABB searchArea = new AABB(casterPos.x - radius, casterPos.y - radius, casterPos.z - radius, casterPos.x + radius, casterPos.y + radius, casterPos.z + radius);
        List existingPillars = level.getEntitiesOfClass(ResonatePillarEntity.class, searchArea, entity -> entity != null && entity.isAlive() && entity.getSummoner() != null && entity.getSummoner().getUUID().equals(caster.getUUID()));
        for (ResonatePillarEntity pillar : existingPillars) {
            double distance = pillar.position().distanceTo(casterPos);
            if (!(distance <= radius)) continue;
            AdvancedCylinderParticleManager.spawnParticles((Level)level, (Vec3)pillar.position(), (int)80, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DEEPSLATE.defaultBlockState()), (ParticleDirection)ParticleDirection.OUTWARD, (double)1.5, (double)3.5, (double)0.0, (double)0.0, (double)0.0, (double)0.03, (boolean)false);
            pillar.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 4.0f, 1.0f);
            pillar.discard();
        }
    }

    private void spawnResonatePillar(Level level, LivingEntity caster, int spellLevel) {
        Vec3 spawnPosition = this.calculateSpawnPosition(caster, this.getSpawnOffset());
        AdvancedSphereParticleManager.spawnParticles((Level)level, (double)spawnPosition.x, (double)(spawnPosition.y + 1.0), (double)spawnPosition.z, (int)80, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.BASALT.defaultBlockState()), (ParticleDirection)ParticleDirection.OUTWARD, (double)0.8, (boolean)false);
        ResonatePillarEntity pillar = new ResonatePillarEntity(level, caster);
        pillar.setPos(spawnPosition.x, spawnPosition.y, spawnPosition.z);
        pillar.setDamage(this.getDamage(spellLevel, caster));
        pillar.setMaxAge(this.getDuration(spellLevel));
        pillar.setShockwaveRadius(this.getShockwaveRadius(spellLevel));
        pillar.setErodeAmplifier(this.getErodeAmplifier(spellLevel));
        level.addFreshEntity((Entity)pillar);
    }

    private Vec3 calculateSpawnPosition(LivingEntity caster, double offset) {
        Vec3 lookDirection = caster.getLookAngle();
        return caster.position().add(lookDirection.x * offset, 0.0, lookDirection.z * offset);
    }

    private double getSpawnOffset() {
        return 6.0;
    }

    private float getShockwaveRadius(int spellLevel) {
        return 4.0f + (float)spellLevel * 1.0f;
    }

    public int getDuration(int spellLevel) {
        return 200 + spellLevel * 200;
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity) * 3.0f;
    }

    private int getErodeAmplifier(int spellLevel) {
        return spellLevel * 2;
    }

    private float getErodeArmorShredPercent(int spellLevel) {
        int amplifier = this.getErodeAmplifier(spellLevel);
        return (float)amplifier * 2.5f;
    }

    private float getErodeSpellResistShredPercent(int spellLevel) {
        int amplifier = this.getErodeAmplifier(spellLevel);
        return (float)amplifier * 1.25f;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.gtbcs_geomancy_plus.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.translatable((String)"ui.gtbcs_geomancy_plus.duration", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(spellLevel), (int)2)}), Component.translatable((String)"ui.gtbcs_geomancy_plus.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getShockwaveRadius(spellLevel), (int)2)}), Component.translatable((String)"ui.gtbcs_geomancy_plus.erode_armor_shred", (Object[])new Object[]{Utils.stringTruncation((double)this.getErodeArmorShredPercent(spellLevel), (int)2)}), Component.translatable((String)"ui.gtbcs_geomancy_plus.erode_spell_resist_shred", (Object[])new Object[]{Utils.stringTruncation((double)this.getErodeSpellResistShredPercent(spellLevel), (int)2)}), Component.literal((String)"\u00a79GTBC'S Geomancy Plus"));
    }
}

