/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.spells.geo;

import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.seismic_ride.SeismicRideEntity;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEffects;
import com.gametechbc.spelllib.particle.AdvancedSphereParticleManager;
import com.gametechbc.spelllib.particle.ParticleDirection;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class SeismicSurfSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"seismic_surf");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(GGSchools.GEO_RESOURCE).setMaxLevel(3).setCooldownSeconds(90.0).build();

    public SeismicSurfSpell() {
        this.manaCostPerLevel = 40;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 30;
        this.baseManaCost = 40;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_1.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1.get());
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        Vec3 spawnPosition = this.calculateSpawnPosition(entity, this.getSpawnOffset());
        AdvancedSphereParticleManager.spawnParticles((Level)level, (double)spawnPosition.x, (double)(spawnPosition.y + 0.5), (double)spawnPosition.z, (int)2, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DEEPSLATE.defaultBlockState()), (ParticleDirection)ParticleDirection.INWARD, (double)3.0, (boolean)false);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        this.spawnSeismicRide(level, entity, spellLevel);
        entity.addEffect(new MobEffectInstance(GGEffects.SEISMIC_RIDE_TIMER_EFFECT, this.getDuration(spellLevel) - 220, 0, false, false, true));
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnSeismicRide(Level level, LivingEntity caster, int spellLevel) {
        Vec3 spawnPosition = this.calculateSpawnPosition(caster, this.getSpawnOffset());
        AdvancedSphereParticleManager.spawnParticles((Level)level, (double)spawnPosition.x, (double)(spawnPosition.y + 0.5), (double)spawnPosition.z, (int)50, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DEEPSLATE.defaultBlockState()), (ParticleDirection)ParticleDirection.OUTWARD, (double)5.0, (boolean)false);
        SeismicRideEntity seismicRide = new SeismicRideEntity(level, caster);
        seismicRide.setPos(spawnPosition.x, spawnPosition.y, spawnPosition.z);
        seismicRide.setYRot(caster.getYRot());
        seismicRide.setXRot(0.0f);
        seismicRide.setForwardSpeed(this.getForwardVelocity(caster, spellLevel));
        seismicRide.setMaxAge(this.getDuration(spellLevel));
        level.addFreshEntity((Entity)seismicRide);
    }

    private Vec3 calculateSpawnPosition(LivingEntity caster, double offset) {
        Vec3 lookDirection = caster.getLookAngle();
        return caster.position().add(lookDirection.x * offset, 0.0, lookDirection.z * offset);
    }

    private double getSpawnOffset() {
        return 4.0;
    }

    public int getDuration(int spellLevel) {
        return 600 + spellLevel * 450;
    }

    public float getForwardVelocity(LivingEntity caster, int spellLevel) {
        return 0.35f + this.getSpellPower(spellLevel, (Entity)caster) * 0.25f;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.STOMP;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.gtbcs_geomancy_plus.forward_velocity", (Object[])new Object[]{Utils.stringTruncation((double)this.getForwardVelocity(caster, spellLevel), (int)2)}), Component.translatable((String)"ui.gtbcs_geomancy_plus.duration", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(spellLevel), (int)1)}), Component.literal((String)"\u00a79GTBC'S Geomancy Plus"));
    }
}

