/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.spells.geo;

import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.tremor_spike.TremorSpikeEntity;
import com.gametechbc.spelllib.entity.GSLScreenShakeEntity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

@AutoSpellConfig
public class TremorSpikeSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"tremor_spike");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(GGSchools.GEO_RESOURCE).setMaxLevel(5).setCooldownSeconds(25.0).build();

    public TremorSpikeSpell() {
        this.manaCostPerLevel = 30;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 16;
        this.baseManaCost = 50;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)MMSounds.EFFECT_GEOMANCY_CRUMBLE.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_2.get());
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.OVERHEAD_MELEE_SWING_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return 1 + spellLevel / 2;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!playerMagicData.getPlayerCooldowns().isOnCooldown((AbstractSpell)this) && !playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 80, castSource, null), playerMagicData);
        }
        Vec3 casterPos = entity.position();
        int ringCount = this.getRingCount(spellLevel);
        float baseDamage = this.getDamage(entity, spellLevel);
        for (int ring = 0; ring < ringCount; ++ring) {
            double radius = 2.5 + (double)ring * 1.5;
            int spikeCount = 6 + ring * 6;
            int ringDelay = ring * 3;
            TremorSpikeSpell.spawnTremorSpikeRing(level, casterPos, radius, spikeCount, entity.getY() - 2.0, entity.getY() + 3.0, ringDelay, entity, baseDamage);
        }
        GSLScreenShakeEntity.createScreenShake((Level)level, (Vec3)entity.position(), (float)8.0f, (float)0.03f, (int)12, (int)0, (int)6, (boolean)false);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private static void spawnTremorSpikeRing(Level level, Vec3 center, double radius, int spikeCount, double minY, double maxY, int ringDelay, LivingEntity caster, float damage) {
        for (int k = 0; k < spikeCount; ++k) {
            float angle = (float)k * (float)Math.PI * 2.0f / (float)spikeCount;
            double x = center.x + (double)Mth.cos((float)angle) * radius;
            double z = center.z + (double)Mth.sin((float)angle) * radius;
            float outwardRotation = (float)Math.toDegrees(angle) + 270.0f;
            TremorSpikeSpell.spawnTremorSpike(level, x, z, minY, maxY, outwardRotation, ringDelay, caster, damage);
        }
    }

    private static boolean spawnTremorSpike(Level level, double x, double z, double minY, double maxY, float rotation, int delay, LivingEntity caster, float damage) {
        BlockPos pos = BlockPos.containing((double)x, (double)maxY, (double)z);
        boolean foundGround = false;
        double yOffset = 0.0;
        do {
            VoxelShape shape;
            BlockPos below;
            if (!level.getBlockState(below = pos.below()).isFaceSturdy((BlockGetter)level, below, Direction.UP)) continue;
            if (!level.isEmptyBlock(pos) && !(shape = level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos)).isEmpty()) {
                yOffset = shape.max(Direction.Axis.Y);
            }
            foundGround = true;
            break;
        } while ((pos = pos.below()).getY() >= Mth.floor((double)minY) - 1);
        if (foundGround) {
            TremorSpikeEntity spike = new TremorSpikeEntity(level, x, (double)pos.getY() + yOffset, z, rotation, delay, damage, caster);
            level.addFreshEntity((Entity)spike);
            return true;
        }
        return false;
    }

    public int getRingCount(int spellLevel) {
        return 2 + spellLevel / 2;
    }

    public float getDamage(LivingEntity caster, int spellLevel) {
        return 2.5f + this.getSpellPower(spellLevel, (Entity)caster) * 2.5f;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.gtbcs_geomancy_plus.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(caster, spellLevel), (int)2)}), Component.translatable((String)"ui.gtbcs_geomancy_plus.ring_count", (Object[])new Object[]{Utils.stringTruncation((double)this.getRingCount(spellLevel), (int)2)}), Component.translatable((String)"ui.gtbcs_geomancy_plus.recast", (Object[])new Object[]{Utils.stringTruncation((double)this.getRecastCount(spellLevel, caster), (int)2)}), Component.literal((String)"\u00a79GTBC'S Geomancy Plus"));
    }
}

