/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.spells.holy;

import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySolarBeam;
import com.gametechbc.gtbcs_geomancy_plus.entity.extended.projectiles.ExtendedSolarBeamEntity;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEffects;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.spelllib.spells.AbstractUniqueSpell;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class SolarBeamSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"solar_beam");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.HOLY_RESOURCE).setMaxLevel(3).setCooldownSeconds(12.0).build();

    public SolarBeamSpell() {
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 50;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
        ExtendedSolarBeamEntity solarBeam = new ExtendedSolarBeamEntity((EntityType<? extends EntitySolarBeam>)((EntityType)GGEntities.EXTENDED_SOLAR_BEAM.get()), level, entity, entity.getX(), entity.getY() + (double)1.2f, entity.getZ(), (float)((double)(entity.yHeadRot + 90.0f) * Math.PI / 180.0), (float)((double)(-entity.getXRot()) * Math.PI / 180.0), 55);
        solarBeam.setHasPlayer(true);
        solarBeam.setDamageMob(this.getDamage(spellLevel, entity));
        level.addFreshEntity((Entity)solarBeam);
        entity.addEffect(new MobEffectInstance(GGEffects.CASTING_EFFECT, 80, 3, false, false));
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity) * 2.65f;
    }

    private float getDefaultDamage() {
        return 1.85f;
    }

    public SpellDamageSource getDamageSource(Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker).setIFrames(0);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.gtbcs_geomancy_plus.damage", (Object[])new Object[]{Utils.stringTruncation((double)(this.getDamage(spellLevel, caster) + this.getDefaultDamage()), (int)2)}), Component.literal((String)"\u00a79GTBC'S Geomancy Plus"));
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.PREPARE_CROSS_ARMS;
    }
}

