/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.util;

import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class GGClientCastHelper {
    public static void handleClientboundEarthExplosion(Vec3 pos, float radius) {
        MinecraftInstanceHelper.ifPlayerPresent(player -> {
            double d5;
            double d4;
            double d3;
            double d2;
            double d1;
            double d0;
            double distance;
            double pitch;
            double angle;
            int i;
            Level level = player.level();
            double x = pos.x;
            double y = pos.y;
            double z = pos.z;
            RandomSource random = level.getRandom();
            int mainParticleCount = (int)(6.0f * radius * radius);
            int superParticleCount = (int)(3.0f * radius * radius);
            int dustCloudCount = 15;
            for (i = 0; i < mainParticleCount; ++i) {
                angle = random.nextDouble() * Math.PI * 2.0;
                pitch = (random.nextDouble() - 0.3) * Math.PI * 0.6;
                distance = random.nextDouble() * (double)radius;
                d0 = x + Math.cos(angle) * Math.cos(pitch) * distance;
                d1 = y + Math.sin(pitch) * distance * 0.3;
                d2 = z + Math.sin(angle) * Math.cos(pitch) * distance;
                double explosiveForce = (0.8 + random.nextDouble() * 1.2) * (1.0 + (double)radius * 0.3);
                d3 = Math.cos(angle) * Math.cos(pitch) * explosiveForce;
                d4 = Math.abs(Math.sin(pitch)) * explosiveForce + 0.3;
                d5 = Math.sin(angle) * Math.cos(pitch) * explosiveForce;
                level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DIRT.defaultBlockState()), d0, d1, d2, d3, d4, d5);
            }
            for (i = 0; i < superParticleCount; ++i) {
                angle = random.nextDouble() * Math.PI * 2.0;
                pitch = (random.nextDouble() - 0.2) * Math.PI * 0.7;
                distance = random.nextDouble() * (double)radius * 0.7;
                d0 = x + Math.cos(angle) * distance;
                d1 = y + random.nextDouble();
                d2 = z + Math.sin(angle) * distance;
                double superExplosiveForce = (1.5 + random.nextDouble() * 1.5) * (1.0 + (double)radius * 0.4);
                d3 = Math.cos(angle) * Math.cos(pitch) * superExplosiveForce;
                d4 = Math.abs(Math.sin(pitch)) * superExplosiveForce + 0.5;
                d5 = Math.sin(angle) * Math.cos(pitch) * superExplosiveForce;
                level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DIRT.defaultBlockState()), d0, d1, d2, d3, d4, d5);
            }
            for (i = 0; i < dustCloudCount; ++i) {
                double d02 = x + (random.nextDouble() - 0.5) * 1.5;
                double d12 = y + random.nextDouble();
                double d22 = z + (random.nextDouble() - 0.5) * 1.5;
                double d32 = (random.nextDouble() - 0.5) * 0.05;
                double d42 = random.nextDouble() * 0.05 + 0.02;
                double d52 = (random.nextDouble() - 0.5) * 0.05;
                level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, d02, d12, d22, d32, d42, d52);
            }
        });
    }
}

