/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.data_managers;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class GSLSwitchManager {
    private static final String SWITCHES_TAG = "GSLSwitches";

    public static boolean isEnabled(ItemStack stack, String abilityKey) {
        CompoundTag tag;
        if (stack.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains(SWITCHES_TAG)) {
            CompoundTag switches = tag.getCompound(SWITCHES_TAG);
            return switches.getBoolean(abilityKey);
        }
        return false;
    }

    public static void setEnabled(ItemStack stack, String abilityKey, boolean enabled) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> {
            CompoundTag switches = tag.getCompound(SWITCHES_TAG);
            switches.putBoolean(abilityKey, enabled);
            tag.put(SWITCHES_TAG, (Tag)switches);
        });
    }

    public static void toggle(ItemStack stack, String abilityKey) {
        boolean current = GSLSwitchManager.isEnabled(stack, abilityKey);
        GSLSwitchManager.setEnabled(stack, abilityKey, !current);
    }

    public static void enable(ItemStack stack, String abilityKey) {
        GSLSwitchManager.setEnabled(stack, abilityKey, true);
    }

    public static void disable(ItemStack stack, String abilityKey) {
        GSLSwitchManager.setEnabled(stack, abilityKey, false);
    }

    public static CompoundTag getAllSwitches(ItemStack stack) {
        CompoundTag tag;
        if (stack.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains(SWITCHES_TAG)) {
            return tag.getCompound(SWITCHES_TAG);
        }
        return new CompoundTag();
    }
}

