/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.entity;

import com.gametechbc.spelllib.init.GSLEntities;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GSLFollowingScreenShakeEntity
extends Entity {
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.defineId(GSLFollowingScreenShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> MAGNITUDE = SynchedEntityData.defineId(GSLFollowingScreenShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.defineId(GSLFollowingScreenShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FADE_DURATION = SynchedEntityData.defineId(GSLFollowingScreenShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FADE_IN_DURATION = SynchedEntityData.defineId(GSLFollowingScreenShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FADE_OUT_IN_DISTANCE = SynchedEntityData.defineId(GSLFollowingScreenShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<UUID>> TARGET_UUID = SynchedEntityData.defineId(GSLFollowingScreenShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> IS_FORCE_FADING = SynchedEntityData.defineId(GSLFollowingScreenShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private Entity cachedTarget = null;
    private int forceFadeStartTick = -1;
    private int lastPositionUpdateTick = -1;

    public GSLFollowingScreenShakeEntity(EntityType<? extends GSLFollowingScreenShakeEntity> type, Level world) {
        super(type, world);
    }

    public GSLFollowingScreenShakeEntity(Level world, Entity targetEntity, float radius, float magnitude, int duration, int fadeInDuration, int fadeOutDuration, boolean fadeOutInDistance) {
        super((EntityType)GSLEntities.GSL_FOLLOWING_SCREEN_SHAKE.get(), world);
        this.setRadius(radius);
        this.setMagnitude(magnitude);
        this.setDuration(duration);
        this.setFadeInDuration(fadeInDuration);
        this.setFadeDuration(fadeOutDuration);
        this.setFadeOutInDistance(fadeOutInDistance);
        this.setTargetUUID(targetEntity.getUUID());
        this.setForceFading(false);
        this.setPos(targetEntity.getX(), targetEntity.getY(), targetEntity.getZ());
        this.cachedTarget = targetEntity;
        this.lastPositionUpdateTick = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAmount(Player player, float delta) {
        float baseAmount;
        float ticksDelta = (float)this.tickCount + delta;
        float fadeInDur = this.getFadeInDuration();
        float duration = this.getDuration();
        float fadeDur = this.getFadeDuration();
        float magnitude = this.getMagnitude();
        if (this.isForceFading()) {
            float timeSinceForceFade = ticksDelta - (float)this.forceFadeStartTick;
            if (timeSinceForceFade >= fadeDur) {
                baseAmount = 0.0f;
            } else {
                float timeFrac = 1.0f - timeSinceForceFade / (fadeDur + 1.0f);
                baseAmount = timeFrac * timeFrac * magnitude;
            }
        } else if (ticksDelta < fadeInDur) {
            float progress = ticksDelta / fadeInDur;
            baseAmount = progress * progress * magnitude;
        } else if (ticksDelta < fadeInDur + duration) {
            baseAmount = magnitude;
        } else if (ticksDelta < fadeInDur + duration + fadeDur) {
            float timeFrac = 1.0f - (ticksDelta - fadeInDur - duration) / (fadeDur + 1.0f);
            baseAmount = timeFrac * timeFrac * magnitude;
        } else {
            baseAmount = 0.0f;
        }
        Vec3 playerPos = player.getEyePosition(delta);
        double distance = this.position().distanceTo(playerPos);
        float minStrengthFactor = 0.1f;
        float falloffStart = 0.7f * this.getRadius();
        float distanceFactor = this.getFadeOutInDistance() ? (distance <= (double)falloffStart ? 1.0f : (distance >= (double)this.getRadius() ? minStrengthFactor : minStrengthFactor + (float)((double)this.getRadius() - distance) / (this.getRadius() - falloffStart) * (1.0f - minStrengthFactor))) : (distance <= (double)this.getRadius() ? 1.0f : 0.0f);
        return distance <= (double)this.getRadius() ? baseAmount * distanceFactor : 0.0f;
    }

    public void tick() {
        super.tick();
        boolean shouldUpdatePosition = this.tickCount - this.lastPositionUpdateTick >= 2;
        Entity target = this.getTargetEntity();
        if (target == null || target.isRemoved()) {
            if (!this.isForceFading()) {
                this.startForceFading();
            }
        } else if (shouldUpdatePosition) {
            this.setPos(target.getX(), target.getY(), target.getZ());
            this.cachedTarget = target;
            this.lastPositionUpdateTick = this.tickCount;
        }
        if (this.isForceFading()) {
            float timeSinceForceFade = this.tickCount - this.forceFadeStartTick;
            if (timeSinceForceFade > (float)this.getFadeDuration()) {
                this.discard();
            }
        } else {
            int totalDuration = this.getFadeInDuration() + this.getDuration() + this.getFadeDuration();
            if (this.tickCount > totalDuration) {
                this.discard();
            }
        }
    }

    private Entity getTargetEntity() {
        if (this.cachedTarget != null && !this.cachedTarget.isRemoved()) {
            return this.cachedTarget;
        }
        Optional<UUID> targetUUID = this.getTargetUUID();
        if (targetUUID.isPresent()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Entity entity = serverLevel.getEntity(targetUUID.get());
                if (entity != null) {
                    this.cachedTarget = entity;
                    return entity;
                }
            } else {
                for (Entity entity : this.level().getEntitiesOfClass(Entity.class, this.getBoundingBox().inflate((double)(this.getRadius() * 2.0f)))) {
                    if (!entity.getUUID().equals(targetUUID.get())) continue;
                    this.cachedTarget = entity;
                    return entity;
                }
            }
        }
        this.cachedTarget = null;
        return null;
    }

    private void startForceFading() {
        this.setForceFading(true);
        this.forceFadeStartTick = this.tickCount;
    }

    protected void defineSynchedData(SynchedEntityData.Builder entityData) {
        entityData.define(RADIUS, (Object)Float.valueOf(10.0f));
        entityData.define(MAGNITUDE, (Object)Float.valueOf(1.0f));
        entityData.define(DURATION, (Object)0);
        entityData.define(FADE_DURATION, (Object)5);
        entityData.define(FADE_IN_DURATION, (Object)0);
        entityData.define(FADE_OUT_IN_DISTANCE, (Object)false);
        entityData.define(TARGET_UUID, Optional.empty());
        entityData.define(IS_FORCE_FADING, (Object)false);
    }

    public float getRadius() {
        return ((Float)this.entityData.get(RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.entityData.set(RADIUS, (Object)Float.valueOf(radius));
    }

    public float getMagnitude() {
        return ((Float)this.entityData.get(MAGNITUDE)).floatValue();
    }

    public void setMagnitude(float magnitude) {
        this.entityData.set(MAGNITUDE, (Object)Float.valueOf(magnitude));
    }

    public int getDuration() {
        return (Integer)this.entityData.get(DURATION);
    }

    public void setDuration(int duration) {
        this.entityData.set(DURATION, (Object)duration);
    }

    public int getFadeDuration() {
        return (Integer)this.entityData.get(FADE_DURATION);
    }

    public void setFadeDuration(int fadeDuration) {
        this.entityData.set(FADE_DURATION, (Object)fadeDuration);
    }

    public int getFadeInDuration() {
        return (Integer)this.entityData.get(FADE_IN_DURATION);
    }

    public void setFadeInDuration(int fadeInDuration) {
        this.entityData.set(FADE_IN_DURATION, (Object)fadeInDuration);
    }

    public boolean getFadeOutInDistance() {
        return (Boolean)this.entityData.get(FADE_OUT_IN_DISTANCE);
    }

    public void setFadeOutInDistance(boolean fadeOutInDistance) {
        this.entityData.set(FADE_OUT_IN_DISTANCE, (Object)fadeOutInDistance);
    }

    public Optional<UUID> getTargetUUID() {
        return (Optional)this.entityData.get(TARGET_UUID);
    }

    public void setTargetUUID(UUID targetUUID) {
        this.entityData.set(TARGET_UUID, Optional.of(targetUUID));
    }

    public boolean isForceFading() {
        return (Boolean)this.entityData.get(IS_FORCE_FADING);
    }

    public void setForceFading(boolean forceFading) {
        this.entityData.set(IS_FORCE_FADING, (Object)forceFading);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setRadius(compound.getFloat("radius"));
        this.setMagnitude(compound.getFloat("magnitude"));
        this.setDuration(compound.getInt("duration"));
        this.setFadeDuration(compound.getInt("fade_duration"));
        this.setFadeInDuration(compound.getInt("fade_in_duration"));
        this.setFadeOutInDistance(compound.getBoolean("fade_out_in_distance"));
        if (compound.hasUUID("target_uuid")) {
            this.setTargetUUID(compound.getUUID("target_uuid"));
        }
        this.setForceFading(compound.getBoolean("is_force_fading"));
        this.forceFadeStartTick = compound.getInt("force_fade_start_tick");
        this.lastPositionUpdateTick = compound.getInt("last_position_update_tick");
        this.tickCount = compound.getInt("ticks_existed");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("radius", this.getRadius());
        compound.putFloat("magnitude", this.getMagnitude());
        compound.putInt("duration", this.getDuration());
        compound.putInt("fade_duration", this.getFadeDuration());
        compound.putInt("fade_in_duration", this.getFadeInDuration());
        compound.putBoolean("fade_out_in_distance", this.getFadeOutInDistance());
        Optional<UUID> targetUUID = this.getTargetUUID();
        targetUUID.ifPresent(value -> compound.putUUID("target_uuid", value));
        compound.putBoolean("is_force_fading", this.isForceFading());
        compound.putInt("force_fade_start_tick", this.forceFadeStartTick);
        compound.putInt("last_position_update_tick", this.lastPositionUpdateTick);
        compound.putInt("ticks_existed", this.tickCount);
    }

    public static void createFollowingScreenShake(Level world, Entity targetEntity, float radius, float magnitude, int duration, int fadeInDuration, int fadeOutDuration, boolean fadeOutInDistance) {
        if (!world.isClientSide) {
            GSLFollowingScreenShakeEntity screenShake = new GSLFollowingScreenShakeEntity(world, targetEntity, radius, magnitude, duration, fadeInDuration, fadeOutDuration, fadeOutInDistance);
            world.addFreshEntity((Entity)screenShake);
        }
    }
}

