/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.entity;

import com.gametechbc.spelllib.init.GSLEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GSLPowerInversionEntity
extends Entity {
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.defineId(GSLPowerInversionEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> INTENSITY = SynchedEntityData.defineId(GSLPowerInversionEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> FADE_DURATION = SynchedEntityData.defineId(GSLPowerInversionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> INVERT_COLORS = SynchedEntityData.defineId(GSLPowerInversionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> FLASH_COLOR = SynchedEntityData.defineId(GSLPowerInversionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public GSLPowerInversionEntity(EntityType<? extends GSLPowerInversionEntity> type, Level world) {
        super(type, world);
    }

    public GSLPowerInversionEntity(Level world, Vec3 position, float radius, float intensity, int fadeDuration, boolean invertColors, int flashColor) {
        super((EntityType)GSLEntities.GSL_POWER_INVERSION.get(), world);
        this.setRadius(radius);
        this.setIntensity(intensity);
        this.setFadeDuration(fadeDuration);
        this.setInvertColors(invertColors);
        this.setFlashColor(flashColor);
        this.setPos(position.x, position.y, position.z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public PowerEffectData getEffectData(Player player, float delta) {
        float ticksDelta = (float)this.tickCount + delta;
        Vec3 playerPos = player.getEyePosition(delta);
        double distance = this.position().distanceTo(playerPos);
        if (distance > (double)this.getRadius()) {
            return new PowerEffectData(0.0f, 0.0f, EffectPhase.NONE);
        }
        float distanceFalloff = (float)Math.max(0.0, 1.0 - distance / (double)this.getRadius());
        float baseIntensity = this.getIntensity() * distanceFalloff;
        if (ticksDelta < 2.0f) {
            return new PowerEffectData(baseIntensity, 0.0f, EffectPhase.FIRST_FLASH);
        }
        if (ticksDelta < 4.0f) {
            return new PowerEffectData(0.0f, baseIntensity, EffectPhase.SECOND_FLASH);
        }
        if (ticksDelta < 4.0f + (float)this.getFadeDuration()) {
            float fadeProgress = (ticksDelta - 4.0f) / (float)this.getFadeDuration();
            fadeProgress = Math.max(0.0f, Math.min(1.0f, fadeProgress));
            float fadeIntensity = baseIntensity * (1.0f - fadeProgress);
            return new PowerEffectData(0.0f, fadeIntensity, EffectPhase.FADE);
        }
        return new PowerEffectData(0.0f, 0.0f, EffectPhase.NONE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFlashColor() {
        return this.getFlashColorValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldInvertColors() {
        return this.getInvertColors();
    }

    public void tick() {
        super.tick();
        int totalDuration = 4 + this.getFadeDuration();
        if (this.tickCount > totalDuration) {
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder entityData) {
        entityData.define(RADIUS, (Object)Float.valueOf(15.0f));
        entityData.define(INTENSITY, (Object)Float.valueOf(1.0f));
        entityData.define(FADE_DURATION, (Object)20);
        entityData.define(INVERT_COLORS, (Object)true);
        entityData.define(FLASH_COLOR, (Object)0xF8F8F8);
    }

    public float getRadius() {
        return ((Float)this.entityData.get(RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.entityData.set(RADIUS, (Object)Float.valueOf(radius));
    }

    public float getIntensity() {
        return ((Float)this.entityData.get(INTENSITY)).floatValue();
    }

    public void setIntensity(float intensity) {
        this.entityData.set(INTENSITY, (Object)Float.valueOf(intensity));
    }

    public int getFadeDuration() {
        return (Integer)this.entityData.get(FADE_DURATION);
    }

    public void setFadeDuration(int duration) {
        this.entityData.set(FADE_DURATION, (Object)duration);
    }

    public boolean getInvertColors() {
        return (Boolean)this.entityData.get(INVERT_COLORS);
    }

    public void setInvertColors(boolean invert) {
        this.entityData.set(INVERT_COLORS, (Object)invert);
    }

    public int getFlashColorValue() {
        return (Integer)this.entityData.get(FLASH_COLOR);
    }

    public void setFlashColor(int color) {
        this.entityData.set(FLASH_COLOR, (Object)color);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setRadius(compound.getFloat("radius"));
        this.setIntensity(compound.getFloat("intensity"));
        this.setFadeDuration(compound.getInt("fade_duration"));
        this.setInvertColors(compound.getBoolean("invert_colors"));
        this.setFlashColor(compound.getInt("flash_color"));
        this.tickCount = compound.getInt("ticks_existed");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("radius", this.getRadius());
        compound.putFloat("intensity", this.getIntensity());
        compound.putInt("fade_duration", this.getFadeDuration());
        compound.putBoolean("invert_colors", this.getInvertColors());
        compound.putInt("flash_color", this.getFlashColorValue());
        compound.putInt("ticks_existed", this.tickCount);
    }

    public static void createPowerInversion(Level world, Vec3 position, float radius, float intensity, int fadeDuration, boolean invertColors, int flashColor) {
        if (!world.isClientSide) {
            GSLPowerInversionEntity effect = new GSLPowerInversionEntity(world, position, radius, intensity, fadeDuration, invertColors, flashColor);
            world.addFreshEntity((Entity)effect);
        }
    }

    public static void createWhitePowerInversion(Level world, Vec3 position, float radius, float intensity, int fadeDuration) {
        GSLPowerInversionEntity.createPowerInversion(world, position, radius, intensity, fadeDuration, true, 0xF8F8F8);
    }

    public static void createCustomPowerInversion(Level world, Vec3 position, float radius, float intensity) {
        GSLPowerInversionEntity.createPowerInversion(world, position, radius, intensity, 20, true, 0xF8F8F8);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PowerEffectData {
        public final float flashIntensity;
        public final float effectIntensity;
        public final EffectPhase phase;

        public PowerEffectData(float flashIntensity, float effectIntensity, EffectPhase phase) {
            this.flashIntensity = flashIntensity;
            this.effectIntensity = effectIntensity;
            this.phase = phase;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum EffectPhase {
        NONE,
        FIRST_FLASH,
        SECOND_FLASH,
        FADE;

    }
}

