/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.entity;

import com.gametechbc.spelllib.init.GSLEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GSLScreenShakeEntity
extends Entity {
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.defineId(GSLScreenShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> MAGNITUDE = SynchedEntityData.defineId(GSLScreenShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.defineId(GSLScreenShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FADE_DURATION = SynchedEntityData.defineId(GSLScreenShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FADE_IN_DURATION = SynchedEntityData.defineId(GSLScreenShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FADE_OUT_IN_DISTANCE = SynchedEntityData.defineId(GSLScreenShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public GSLScreenShakeEntity(EntityType<? extends GSLScreenShakeEntity> type, Level world) {
        super(type, world);
    }

    public GSLScreenShakeEntity(Level world, Vec3 position, float radius, float magnitude, int duration, int fadeInDuration, int fadeOutDuration, boolean fadeOutInDistance) {
        super((EntityType)GSLEntities.GSL_SCREEN_SHAKE.get(), world);
        this.setRadius(radius);
        this.setMagnitude(magnitude);
        this.setDuration(duration);
        this.setFadeInDuration(fadeInDuration);
        this.setFadeDuration(fadeOutDuration);
        this.setFadeOutInDistance(fadeOutInDistance);
        this.setPos(position.x, position.y, position.z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAmount(Player player, float delta) {
        float baseAmount;
        float ticksDelta = (float)this.tickCount + delta;
        float fadeInDur = this.getFadeInDuration();
        float duration = this.getDuration();
        float fadeDur = this.getFadeDuration();
        float magnitude = this.getMagnitude();
        if (ticksDelta < fadeInDur) {
            float progress = ticksDelta / fadeInDur;
            baseAmount = progress * progress * magnitude;
        } else if (ticksDelta < fadeInDur + duration) {
            baseAmount = magnitude;
        } else if (ticksDelta < fadeInDur + duration + fadeDur) {
            float timeFrac = 1.0f - (ticksDelta - fadeInDur - duration) / (fadeDur + 1.0f);
            baseAmount = timeFrac * timeFrac * magnitude;
        } else {
            baseAmount = 0.0f;
        }
        Vec3 playerPos = player.getEyePosition(delta);
        double distance = this.position().distanceTo(playerPos);
        float minStrengthFactor = 0.1f;
        float falloffStart = 0.7f * this.getRadius();
        float distanceFactor = this.getFadeOutInDistance() ? (distance <= (double)falloffStart ? 1.0f : (distance >= (double)this.getRadius() ? minStrengthFactor : minStrengthFactor + (float)((double)this.getRadius() - distance) / (this.getRadius() - falloffStart) * (1.0f - minStrengthFactor))) : (distance <= (double)this.getRadius() ? 1.0f : 0.0f);
        return distance <= (double)this.getRadius() ? baseAmount * distanceFactor : 0.0f;
    }

    public void tick() {
        super.tick();
        int totalDuration = this.getFadeInDuration() + this.getDuration() + this.getFadeDuration();
        if (this.tickCount > totalDuration) {
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder entityData) {
        entityData.define(RADIUS, (Object)Float.valueOf(10.0f));
        entityData.define(MAGNITUDE, (Object)Float.valueOf(1.0f));
        entityData.define(DURATION, (Object)0);
        entityData.define(FADE_DURATION, (Object)5);
        entityData.define(FADE_IN_DURATION, (Object)0);
        entityData.define(FADE_OUT_IN_DISTANCE, (Object)false);
    }

    public float getRadius() {
        return ((Float)this.entityData.get(RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.entityData.set(RADIUS, (Object)Float.valueOf(radius));
    }

    public float getMagnitude() {
        return ((Float)this.entityData.get(MAGNITUDE)).floatValue();
    }

    public void setMagnitude(float magnitude) {
        this.entityData.set(MAGNITUDE, (Object)Float.valueOf(magnitude));
    }

    public int getDuration() {
        return (Integer)this.entityData.get(DURATION);
    }

    public void setDuration(int duration) {
        this.entityData.set(DURATION, (Object)duration);
    }

    public int getFadeDuration() {
        return (Integer)this.entityData.get(FADE_DURATION);
    }

    public void setFadeDuration(int fadeDuration) {
        this.entityData.set(FADE_DURATION, (Object)fadeDuration);
    }

    public int getFadeInDuration() {
        return (Integer)this.entityData.get(FADE_IN_DURATION);
    }

    public void setFadeInDuration(int fadeInDuration) {
        this.entityData.set(FADE_IN_DURATION, (Object)fadeInDuration);
    }

    public boolean getFadeOutInDistance() {
        return (Boolean)this.entityData.get(FADE_OUT_IN_DISTANCE);
    }

    public void setFadeOutInDistance(boolean fadeOutInDistance) {
        this.entityData.set(FADE_OUT_IN_DISTANCE, (Object)fadeOutInDistance);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setRadius(compound.getFloat("radius"));
        this.setMagnitude(compound.getFloat("magnitude"));
        this.setDuration(compound.getInt("duration"));
        this.setFadeDuration(compound.getInt("fade_duration"));
        this.setFadeInDuration(compound.getInt("fade_in_duration"));
        this.setFadeOutInDistance(compound.getBoolean("fade_out_in_distance"));
        this.tickCount = compound.getInt("ticks_existed");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("radius", this.getRadius());
        compound.putFloat("magnitude", this.getMagnitude());
        compound.putInt("duration", this.getDuration());
        compound.putInt("fade_duration", this.getFadeDuration());
        compound.putInt("fade_in_duration", this.getFadeInDuration());
        compound.putBoolean("fade_out_in_distance", this.getFadeOutInDistance());
        compound.putInt("ticks_existed", this.tickCount);
    }

    public static void createScreenShake(Level world, Vec3 position, float radius, float magnitude, int duration, int fadeInDuration, int fadeOutDuration, boolean fadeOutInDistance) {
        if (!world.isClientSide) {
            GSLScreenShakeEntity screenShake = new GSLScreenShakeEntity(world, position, radius, magnitude, duration, fadeInDuration, fadeOutDuration, fadeOutInDistance);
            world.addFreshEntity((Entity)screenShake);
        }
    }

    public static void createScreenShake(Level world, Vec3 position, float radius, float magnitude, int duration, int fadeDuration) {
        GSLScreenShakeEntity.createScreenShake(world, position, radius, magnitude, duration, 0, fadeDuration, false);
    }
}

