/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.utils;

import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class AdvancedTrades {

    public static class DualItemTrade
    extends FlexibleTrade {
        public DualItemTrade(int tradeUses, ItemStack currency, int minCurrency, int maxCurrency, ItemStack middleItem, int minMiddle, int maxMiddle, ItemStack output, int minOutput, int maxOutput, float priceMultiplier) {
            super((trader, random) -> {
                int currencyAmount = random.nextIntBetweenInclusive(minCurrency, maxCurrency);
                int middleAmount = random.nextIntBetweenInclusive(minMiddle, maxMiddle);
                int outputAmount = random.nextIntBetweenInclusive(minOutput, maxOutput);
                return new MerchantOffer(new ItemCost((ItemLike)currency.getItem(), currencyAmount), Optional.of(new ItemCost((ItemLike)middleItem.getItem(), middleAmount)), new ItemStack((ItemLike)output.getItem(), outputAmount), tradeUses, 0, priceMultiplier);
            });
        }
    }

    public static class SingleItemTrade
    extends FlexibleTrade {
        public SingleItemTrade(int tradeUses, ItemStack currency, int minCurrency, int maxCurrency, ItemStack output, int minOutput, int maxOutput, float priceMultiplier) {
            super((trader, random) -> {
                int currencyAmount = random.nextIntBetweenInclusive(minCurrency, maxCurrency);
                int outputAmount = random.nextIntBetweenInclusive(minOutput, maxOutput);
                return new MerchantOffer(new ItemCost((ItemLike)currency.getItem(), currencyAmount), new ItemStack((ItemLike)output.getItem(), outputAmount), tradeUses, 0, priceMultiplier);
            });
        }
    }

    public static class FlexibleTrade
    implements VillagerTrades.ItemListing {
        final BiFunction<Entity, RandomSource, MerchantOffer> getOffer;

        protected FlexibleTrade(BiFunction<Entity, RandomSource, MerchantOffer> getOffer) {
            this.getOffer = getOffer;
        }

        public static FlexibleTrade of(BiFunction<Entity, RandomSource, MerchantOffer> getOffer) {
            return new FlexibleTrade(getOffer);
        }

        public MerchantOffer getOffer(Entity trader, RandomSource random) {
            return this.getOffer.apply(trader, random);
        }
    }
}

