/*
 * Decompiled with CFR 0.152.
 */
package guideme.indices;

import com.google.gson.stream.JsonWriter;
import guideme.GuidePageChange;
import guideme.compiler.ParsedGuidePage;
import guideme.indices.PageIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class MultiValuedIndex<K, V>
implements PageIndex {
    private final Map<K, List<Record<V>>> index = new HashMap<K, List<Record<V>>>();
    private final String name;
    private final EntryFunction<K, V> entryFunction;
    private final PageIndex.JsonSerializer<K> keySerializer;
    private final PageIndex.JsonSerializer<V> valueSerializer;

    public MultiValuedIndex(String name, EntryFunction<K, V> entryFunction, PageIndex.JsonSerializer<K> keySerializer, PageIndex.JsonSerializer<V> valueSerializer) {
        this.name = name;
        this.entryFunction = entryFunction;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<V> get(K key) {
        List<Record<V>> entries = this.index.get(key);
        if (entries != null) {
            return entries.stream().map(Record::value).toList();
        }
        return List.of();
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public void rebuild(List<ParsedGuidePage> pages) {
        this.index.clear();
        for (ParsedGuidePage page : pages) {
            this.addToIndex(page);
        }
    }

    @Override
    public void update(List<ParsedGuidePage> allPages, List<GuidePageChange> changes) {
        Set idsToRemove = changes.stream().map(GuidePageChange::pageId).collect(Collectors.toSet());
        Iterator<List<Record<V>>> it = this.index.values().iterator();
        while (it.hasNext()) {
            List<Record<V>> entries = it.next();
            entries.removeIf(p -> idsToRemove.contains(p.pageId));
            if (!entries.isEmpty()) continue;
            it.remove();
        }
        for (GuidePageChange change : changes) {
            ParsedGuidePage newPage = change.newPage();
            if (newPage == null) continue;
            this.addToIndex(newPage);
        }
    }

    @Override
    public void export(JsonWriter writer) throws IOException {
        writer.beginArray();
        for (Map.Entry<K, List<Record<V>>> entry : this.index.entrySet()) {
            this.keySerializer.write(writer, entry.getKey());
            writer.beginArray();
            for (Record<V> vRecord : entry.getValue()) {
                this.valueSerializer.write(writer, vRecord.value());
            }
            writer.endArray();
        }
        writer.endArray();
    }

    private void addToIndex(ParsedGuidePage page) {
        for (Pair<K, V> entry : this.entryFunction.getEntry(page)) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            List entries = this.index.computeIfAbsent(key, k -> new ArrayList());
            entries.add(new Record<Object>(page.getId(), value));
        }
    }

    @FunctionalInterface
    public static interface EntryFunction<K, V> {
        public Iterable<Pair<K, V>> getEntry(ParsedGuidePage var1);
    }

    private record Record<V>(ResourceLocation pageId, V value) {
    }
}

