/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.search.MatchesIterator;
import guideme.internal.shaded.lucene.search.Query;
import java.io.IOException;

class TermMatchesIterator
implements MatchesIterator {
    private int upto;
    private int pos;
    private final PostingsEnum pe;
    private final Query query;

    TermMatchesIterator(Query query, PostingsEnum pe) throws IOException {
        this.pe = pe;
        this.query = query;
        this.upto = pe.freq();
    }

    @Override
    public boolean next() throws IOException {
        if (this.upto-- > 0) {
            this.pos = this.pe.nextPosition();
            return true;
        }
        return false;
    }

    @Override
    public int startPosition() {
        return this.pos;
    }

    @Override
    public int endPosition() {
        return this.pos;
    }

    @Override
    public int startOffset() throws IOException {
        return this.pe.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.pe.endOffset();
    }

    @Override
    public MatchesIterator getSubMatches() throws IOException {
        return null;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }
}

