/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials;

import com.henny.hennyessentials.Constants;
import com.henny.hennyessentials.command.ModCommands;
import com.henny.hennyessentials.compat.LuckPermsIntegration;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.data.PermissionUserData;
import com.henny.hennyessentials.data.PlayerData;
import com.henny.hennyessentials.data.WarpData;
import com.henny.hennyessentials.data.objects.Ban;
import com.henny.hennyessentials.data.objects.CommandToken;
import com.henny.hennyessentials.data.objects.Mute;
import com.henny.hennyessentials.permission.Permissions;
import com.henny.hennyessentials.platform.Services;
import com.henny.hennyessentials.task.TaskManager;
import com.henny.hennyessentials.util.AFKHandler;
import com.henny.hennyessentials.util.BackHandler;
import com.henny.hennyessentials.util.ModerationUtils;
import com.henny.hennyessentials.util.TextUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class CommonClass {
    public static MinecraftServer minecraftServer;
    static final int[] tickCounter;
    public static Map<UUID, BlockPos> teleportMoveLock;
    public static Map<UUID, Boolean> playersInVanish;
    public static Map<UUID, Boolean> playersInFly;

    public static void init(String configDir) {
        ConfigManager.load(configDir);
        ConfigManager.loadCommandTokensConfig(configDir);
        ConfigManager.loadAnnouncements(configDir);
        ConfigManager.loadBannedItems();
        ConfigManager.reloadConditionsConfig();
        ConfigManager.reloadPagesConfig();
        if (Services.PLATFORM.isModLoaded("hennyessentials")) {
            Constants.LOG.info("Hello to hennyessentials");
        }
    }

    public static void playerDeathEvent(ServerPlayer player, GlobalPos deathPos) {
        BackHandler.setLastDeathLocation(player, deathPos);
    }

    public static void playerLeaveEvent(ServerPlayer player) {
        if (playersInVanish.containsKey(player.getUUID())) {
            player.setInvisible(false);
            player.removeEffect(MobEffects.INVISIBILITY);
            playersInVanish.remove(player.getUUID());
            if (player.getTags().contains("he.vanish")) {
                player.removeTag("he.vanish");
            }
        }
        if (player.getTags().contains("he.vanish")) {
            player.removeTag("he.vanish");
            player.setInvisible(false);
            player.removeEffect(MobEffects.INVISIBILITY);
        }
        AFKHandler.AFKTracker.remove(player.getUUID());
    }

    public static void playerJoinEvent(ServerPlayer serverPlayer) {
        if (serverPlayer.getTags().contains("he.fly")) {
            Abilities abs = serverPlayer.getAbilities();
            abs.flying = true;
            abs.mayfly = true;
            serverPlayer.onUpdateAbilities();
        }
        if (ConfigManager.CONFIG.commandConfigs.vanishConfigs.EXPERIMENTAL_shouldHideVanishedPlayersFromTabList) {
            ArrayList<UUID> vanishedPlayers = new ArrayList<UUID>();
            for (Map.Entry<UUID, Boolean> entry : playersInVanish.entrySet()) {
                if (!entry.getValue().booleanValue() || entry.getKey() == serverPlayer.getUUID()) continue;
                vanishedPlayers.add(entry.getKey());
            }
            ClientboundPlayerInfoRemovePacket packet = new ClientboundPlayerInfoRemovePacket(vanishedPlayers);
            serverPlayer.connection.send((Packet)packet);
        }
        PlayerData data = PlayerData.getUserData(serverPlayer.server);
        PermissionUserData.getPermissionUserData(serverPlayer.server).addUserPermission(serverPlayer.getUUID(), "group.default");
        Map<UUID, Ban> bannedPlayers = data.bannedPlayers;
        if (bannedPlayers.containsKey(serverPlayer.getUUID())) {
            String expiryStr;
            long expiry = bannedPlayers.get((Object)serverPlayer.getUUID()).banExpiry;
            String reason = bannedPlayers.get((Object)serverPlayer.getUUID()).banReason;
            String string = expiryStr = expiry == 0L ? "Never" : TextUtils.readableDuration(expiry - System.currentTimeMillis());
            if (expiry == 0L || expiry > System.currentTimeMillis()) {
                serverPlayer.connection.disconnect((Component)Component.literal((String)(ConfigManager.CONFIG.moderationConfigs.banConfigs.bannedMessage.replace("%reason%", reason) + "\n" + ConfigManager.CONFIG.moderationConfigs.banConfigs.expiryMessage.replace("%expiry%", expiryStr))));
            }
        }
    }

    public static void serverStartedEvent() {
        TaskManager.startHETasks();
        TaskManager.startAnnouncementTasks();
    }

    public static void commandRegistrationEvent(CommandDispatcher<CommandSourceStack> cmdDispatcher) {
        ModCommands.register(cmdDispatcher);
    }

    public static void interactItemRightClickEvent(ServerPlayer player, InteractionHand interactionHand) {
        ItemStack itemStack;
        boolean hasData;
        if (ConfigManager.CONFIG.moderationConfigs.afkConfigs.rightClickItemCountsAsMovement) {
            AFKHandler.updatePlayer(player);
        }
        boolean bl = hasData = (itemStack = player.getItemInHand(interactionHand)).get(DataComponents.CUSTOM_DATA) != null;
        if (hasData && !((CustomData)itemStack.get(DataComponents.CUSTOM_DATA)).copyTag().getString("commandtoken").isEmpty()) {
            CommandToken token = ConfigManager.TOKENS.get(((CustomData)itemStack.get(DataComponents.CUSTOM_DATA)).copyTag().getString("commandtoken"));
            if (token.permission != null && !token.permission.isBlank() && ConfigManager.CONFIG.permissionConfigs.permissionsEnabled && !Permissions.permissionCheck(player.getUUID(), token.permission, minecraftServer)) {
                player.sendSystemMessage((Component)Component.literal((String)ConfigManager.CONFIG.tokenConfigs.tokenNoPermissionMessage));
                return;
            }
            if (!((CustomData)itemStack.get(DataComponents.CUSTOM_DATA)).copyTag().getString("locked").isEmpty() && !player.getUUID().toString().equals(((CustomData)itemStack.get(DataComponents.CUSTOM_DATA)).copyTag().getString("locked"))) {
                player.sendSystemMessage((Component)TextUtils.formatMessage(ConfigManager.CONFIG.tokenConfigs.lockedTokenNoPermissionMessage));
                return;
            }
            if (token.reusableUsageLimit > 0 && token.isReusable()) {
                CompoundTag tokenData = ((CustomData)itemStack.get(DataComponents.CUSTOM_DATA)).copyTag();
                int usages = 0;
                if (tokenData.contains("usages")) {
                    usages = tokenData.getInt("usages");
                }
                if (usages >= token.reusableUsageLimit) {
                    player.sendSystemMessage((Component)TextUtils.formatMessage(ConfigManager.CONFIG.tokenConfigs.maxUsagesText));
                    PlayerData.getUserData().updatePlayerInfo(player.getUUID(), "token-usage-" + token.alias, String.valueOf(token.reusableUsageLimit));
                    itemStack.shrink(1);
                    return;
                }
                tokenData.putInt("usages", usages + 1);
                itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tokenData));
            }
            token.commands.stream().map(cmd -> cmd.replace("%p", player.getName().getString())).forEach(cmd -> {
                MinecraftServer server = player.getServer();
                Commands commands = server.getCommands();
                ParseResults parseRes = commands.getDispatcher().parse(cmd, (Object)server.createCommandSourceStack().withPermission(4));
                try {
                    commands.getDispatcher().execute(parseRes);
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException(e);
                }
            });
            if (ConfigManager.CONFIG.moderationConfigs.auditConfigs.shouldWriteCommandTokenUsagesToAuditLog && token.shouldWriteToAuditLog) {
                ModerationUtils.writeToAuditLog("TOKEN", player.getScoreboardName() + " redeemed token: " + token.alias + ". Player UUID is: " + String.valueOf(player.getUUID()));
            }
            if (!token.reusable) {
                itemStack.shrink(1);
            }
        }
    }

    public static boolean serverChatEventResult(ServerPlayer serverPlayer, Component msg) {
        if (serverPlayer != null && PlayerData.getUserData((MinecraftServer)CommonClass.minecraftServer).mutedPlayers.containsKey(serverPlayer.getUUID())) {
            Mute muteData = PlayerData.getUserData((MinecraftServer)CommonClass.minecraftServer).mutedPlayers.get(serverPlayer.getUUID());
            if (muteData.muteExpiry == 0L || muteData.muteExpiry > System.currentTimeMillis()) {
                String expiry = muteData.muteExpiry == 0L ? "Never" : TextUtils.readableDuration(muteData.muteExpiry - System.currentTimeMillis());
                serverPlayer.sendSystemMessage((Component)Component.literal((String)ConfigManager.CONFIG.moderationConfigs.muteConfigs.mutedMessage.replace("%reason%", muteData.muteReason)));
                serverPlayer.sendSystemMessage((Component)Component.literal((String)ConfigManager.CONFIG.moderationConfigs.muteConfigs.expiryMessage.replace("%expiry%", expiry)));
                return false;
            }
        }
        if (serverPlayer != null && ConfigManager.CONFIG.moderationConfigs.afkConfigs.chatMessageOrCommandCountsAsMovement) {
            AFKHandler.updatePlayer(serverPlayer);
        }
        if (ConfigManager.CONFIG.chatConfigs.chatFormattingEnabled) {
            String raw = msg.getString().replace(ConfigManager.CONFIG.chatConfigs.chatColorCode, "\u00a7");
            if (ConfigManager.CONFIG.chatConfigs.chatColorsEnabled && ConfigManager.CONFIG.permissionConfigs.permissionsEnabled && ConfigManager.CONFIG.chatConfigs.permissionCheckForChatColors) {
                raw = CommonClass.removeUnauthorizedColorCodes(raw, serverPlayer, minecraftServer);
            }
            MutableComponent messageComponent = Component.literal((String)raw);
            MutableComponent prefix = Component.literal((String)"");
            MutableComponent suffix = Component.literal((String)"");
            if (ConfigManager.CONFIG.permissionConfigs.luckPermsOverridePermissions) {
                prefix = Component.literal((String)LuckPermsIntegration.getPrefix(serverPlayer.getUUID()).replace("&", "\u00a7"));
                suffix = Component.literal((String)LuckPermsIntegration.getSuffix(serverPlayer.getUUID()).replace("&", "\u00a7"));
            } else if (ConfigManager.CONFIG.permissionConfigs.permissionsEnabled) {
                prefix = PermissionUserData.getChatPrefix(serverPlayer.getUUID(), serverPlayer.server);
                suffix = PermissionUserData.getChatSuffix(serverPlayer.getUUID(), serverPlayer.server);
            }
            String username = serverPlayer.getName().getString();
            String format = ConfigManager.CONFIG.chatConfigs.playerChatMessageFormat.replace(ConfigManager.CONFIG.chatConfigs.chatColorCode, "\u00a7");
            Pattern pattern = Pattern.compile("%(prefix|username|suffix|message)%");
            Matcher matcher = pattern.matcher(format);
            int lastEnd = 0;
            MutableComponent finalMsg = Component.empty();
            while (matcher.find()) {
                String before = format.substring(lastEnd, matcher.start());
                if (!before.isEmpty()) {
                    finalMsg.append((Component)CommonClass.parseFormattedLiteral(before));
                }
                switch (matcher.group(1)) {
                    case "prefix": {
                        finalMsg.append((Component)prefix);
                        break;
                    }
                    case "username": {
                        finalMsg.append((Component)Component.literal((String)username));
                        break;
                    }
                    case "suffix": {
                        finalMsg.append((Component)suffix);
                        break;
                    }
                    case "message": {
                        finalMsg.append((Component)messageComponent);
                    }
                }
                lastEnd = matcher.end();
            }
            if (lastEnd < format.length()) {
                finalMsg.append((Component)CommonClass.parseFormattedLiteral(format.substring(lastEnd)));
            }
            serverPlayer.server.getPlayerList().broadcastSystemMessage((Component)finalMsg, false);
            return false;
        }
        return true;
    }

    private static MutableComponent parseFormattedLiteral(String input) {
        return Component.literal((String)input);
    }

    private static String removeUnauthorizedColorCodes(String raw, ServerPlayer serverPlayer, MinecraftServer minecraftServer) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < raw.length(); ++i) {
            char code;
            String node;
            char c = raw.charAt(i);
            if (c == '\u00a7' && i + 1 < raw.length() && (node = Permissions.COLOR_CODE_PERMISSIONS.get(Character.valueOf(code = Character.toLowerCase(raw.charAt(i + 1))))) != null) {
                String permission = "he.chat.format." + node;
                if (!Permissions.permissionCheck(serverPlayer.getUUID(), permission, minecraftServer)) {
                    ++i;
                    continue;
                }
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static void interactBlockRightClickEvent(ServerPlayer player, BlockPos blockPos) {
        if (ConfigManager.CONFIG.moderationConfigs.afkConfigs.rightClickBlockCountsAsMovement) {
            AFKHandler.updatePlayer(player);
        }
    }

    public static void tickEvent(MinecraftServer server) {
        TaskManager.tick(server);
        AFKHandler.tick(server);
        tickCounter[0] = tickCounter[0] + 1;
        if (tickCounter[0] >= 120) {
            WarpData.getWarpData(server).purgeExpired();
            PlayerData.getUserData(server).purgeExpiredBansMutes();
            for (Map.Entry<UUID, Boolean> entry : playersInVanish.entrySet()) {
                if (server.getPlayerList().getPlayer(entry.getKey()) == null) continue;
                playersInVanish.put(entry.getKey(), server.getPlayerList().getPlayer(entry.getKey()).getTags().contains("he.vanish"));
            }
            CommonClass.tickCounter[0] = 0;
        }
    }

    public static boolean entityChangeTargetEventResult(ServerPlayer newTarget) {
        return playersInVanish.getOrDefault(newTarget.getUUID(), false);
    }

    public static void changeLevelEventResult(String level, ServerPlayer player) {
        if (ConfigManager.CONFIG.permissionConfigs.permissionRequiredToEnterDimensions && !level.equals(ConfigManager.CONFIG.permissionConfigs.defaultDimensionNoPermsRequired) && !Permissions.permissionCheck(player.getUUID(), "dimension." + level, player.server)) {
            ServerLevel ow = player.server.overworld();
            BlockPos owspawn = player.server.overworld().getSharedSpawnPos();
            player.teleportTo(ow, (double)owspawn.getX(), (double)(owspawn.getY() + 1), (double)owspawn.getZ(), player.getYRot(), player.getXRot());
            player.sendSystemMessage((Component)TextUtils.formatMessage(ConfigManager.CONFIG.commandConfigs.teleportConfigs.normalTeleportToDimNoPermission.replace("%dimension%", level)));
        }
    }

    static {
        tickCounter = new int[]{0};
        teleportMoveLock = new HashMap<UUID, BlockPos>();
        playersInVanish = new HashMap<UUID, Boolean>();
        playersInFly = new HashMap<UUID, Boolean>();
    }
}

