/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.Constants;
import com.henny.hennyessentials.compat.LuckPermsIntegration;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.permission.Permissions;
import com.henny.hennyessentials.util.ModerationUtils;
import com.henny.hennyessentials.util.TextUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@Mod(value="hennyessentials")
public class HennyEssentials {
    public HennyEssentials(IEventBus eventBus) {
        Constants.LOG.info("Hello NeoForge world!");
        CommonClass.init(FMLPaths.CONFIGDIR.get().toString() + "/HennyEssentials/");
        NeoForge.EVENT_BUS.register((Object)this);
        LuckPermsIntegration.isLuckPermsLoaded = ModList.get().isLoaded("luckperms");
    }

    @SubscribeEvent
    public void playerDeathEvent(LivingDeathEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)livingEntity;
            CommonClass.playerDeathEvent(p, GlobalPos.of((ResourceKey)p.serverLevel().dimension(), (BlockPos)p.getOnPos()));
        }
    }

    @SubscribeEvent
    public void playerRespawnEvent(PlayerEvent.PlayerRespawnEvent e) {
        ServerPlayer p;
        Player player = e.getEntity();
        if (player instanceof ServerPlayer && (p = (ServerPlayer)player).getLastDeathLocation().isPresent()) {
            CommonClass.playerDeathEvent(p, (GlobalPos)p.getLastDeathLocation().get());
        }
    }

    @SubscribeEvent
    public void playerLeaveEvent(PlayerEvent.PlayerLoggedOutEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)player;
            CommonClass.playerLeaveEvent(p);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)player;
            if (ModerationUtils.isBannedItem(e.getCrafting().getItem())) {
                if (ConfigManager.CONFIG.permissionConfigs.permissionsEnabled) {
                    if (!Permissions.permissionCheck(p.getUUID(), "he.banneditem.bypass." + BuiltInRegistries.ITEM.getKey((Object)e.getCrafting().getItem()).toString(), p.getServer())) {
                        ModerationUtils.handleBannedItem(e.getCrafting(), p);
                    }
                } else {
                    ModerationUtils.handleBannedItem(e.getCrafting(), p);
                }
            }
        }
    }

    @SubscribeEvent
    public void onItemPickup(ItemEntityPickupEvent.Pre e) {
        Player player = e.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)player;
            if (ModerationUtils.isBannedItem(e.getItemEntity().getItem().getItem())) {
                if (ConfigManager.CONFIG.permissionConfigs.permissionsEnabled) {
                    if (!Permissions.permissionCheck(p.getUUID(), "he.banneditem.bypass." + BuiltInRegistries.ITEM.getKey((Object)e.getItemEntity().getItem().getItem()).toString(), p.getServer())) {
                        if (ConfigManager.CONFIG.moderationConfigs.bannedItemsConfigs.shouldRemoveBannedItemFromPlayer) {
                            e.setCanPickup(TriState.FALSE);
                        }
                        ModerationUtils.handleBannedItem(e.getItemEntity().getItem(), p);
                    }
                } else {
                    if (ConfigManager.CONFIG.moderationConfigs.bannedItemsConfigs.shouldRemoveBannedItemFromPlayer) {
                        e.setCanPickup(TriState.FALSE);
                    }
                    ModerationUtils.handleBannedItem(e.getItemEntity().getItem(), p);
                }
            }
        }
    }

    @SubscribeEvent
    public void serverTickPost(ServerTickEvent.Post event) {
        CommonClass.tickEvent(event.getServer());
    }

    @SubscribeEvent
    public void serverStart(ServerStartingEvent e) {
        CommonClass.minecraftServer = e.getServer();
        CommonClass.serverStartedEvent();
    }

    @SubscribeEvent
    public void playerJoin(EntityJoinLevelEvent e) {
        Entity ent = e.getEntity();
        if (ent instanceof ServerPlayer && e.getLevel().getServer().getPlayerList().getPlayer(ent.getUUID()) != null) {
            CommonClass.playerJoinEvent(e.getLevel().getServer().getPlayerList().getPlayer(e.getEntity().getUUID()));
        }
    }

    @SubscribeEvent
    public void commandRegister(RegisterCommandsEvent e) {
        CommonClass.commandRegistrationEvent((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    @SubscribeEvent
    public void commandPerform(CommandEvent e) {
        if (!ConfigManager.CONFIG.permissionConfigs.permissionsEnabled) {
            return;
        }
        if (ConfigManager.CONFIG.permissionConfigs.luckPermsOverridePermissions) {
            return;
        }
        CommandSourceStack source = (CommandSourceStack)e.getParseResults().getContext().getSource();
        if (!source.isPlayer()) {
            return;
        }
        UUID uuid = source.getPlayer().getUUID();
        MinecraftServer server = source.getServer();
        List cmdNodes = e.getParseResults().getContext().getNodes();
        if (cmdNodes.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder("command");
        for (ParsedCommandNode cmdNode : cmdNodes) {
            if (!(cmdNode.getNode() instanceof LiteralCommandNode) && (!ConfigManager.CONFIG.permissionConfigs.shouldIncludeArgumentNodesInPermissions || !(cmdNode.getNode() instanceof ArgumentCommandNode))) continue;
            sb.append(".").append(cmdNode.getNode().getName());
        }
        String basePermission = sb.toString().toLowerCase();
        Object permission = basePermission;
        String rawInput = e.getParseResults().getReader().getString();
        String commandLabel = rawInput.split(" ")[0].substring(1);
        Map<String, List<String>> aliasList = ConfigManager.CONFIG.aliasConfigs.aliasList;
        for (Map.Entry<String, List<String>> entry : aliasList.entrySet()) {
            if (!entry.getValue().contains(commandLabel)) continue;
            permission = "command." + entry.getKey().replace(" ", ".").toLowerCase();
            break;
        }
        if (source.getPlayer().getTags().contains("hessentials.verbose")) {
            source.sendSystemMessage((Component)TextUtils.formatMessage("Permission check: " + (String)permission));
        }
        if (Permissions.permissionCheck(uuid, (String)permission, server)) {
            return;
        }
        for (String group : Permissions.getDefinedGroups()) {
            if (!Permissions.permissionCheck(uuid, group, server) || !Permissions.hasGroupPermission(group, (String)permission)) continue;
            return;
        }
        source.sendSystemMessage((Component)TextUtils.formatMessage("You do not have the required permission to execute this command."));
        e.setCanceled(true);
    }

    @SubscribeEvent
    public void interactItemRightClick(PlayerInteractEvent.RightClickItem e) {
        if (e.getEntity() instanceof ServerPlayer) {
            CommonClass.interactItemRightClickEvent((ServerPlayer)e.getEntity(), e.getHand());
        }
    }

    @SubscribeEvent
    public void playerInteractBlockRightClickEvent(PlayerInteractEvent.RightClickBlock e) {
        if (e.getEntity() instanceof ServerPlayer) {
            CommonClass.interactBlockRightClickEvent((ServerPlayer)e.getEntity(), e.getPos());
        }
    }

    @SubscribeEvent
    public void playerChatEvent(ServerChatEvent e) {
        e.setCanceled(!CommonClass.serverChatEventResult(e.getPlayer(), e.getMessage()));
    }

    @SubscribeEvent
    public void playerChangeLevelEvent(PlayerEvent.PlayerChangedDimensionEvent e) {
        if (!(e.getEntity() instanceof ServerPlayer)) {
            return;
        }
        CommonClass.changeLevelEventResult(e.getTo().location().toString(), (ServerPlayer)e.getEntity());
    }

    @SubscribeEvent
    public void onMobTargetChange(LivingChangeTargetEvent event) {
        if (event.getNewAboutToBeSetTarget() instanceof ServerPlayer) {
            event.setCanceled(CommonClass.entityChangeTargetEventResult((ServerPlayer)event.getNewAboutToBeSetTarget()));
        }
    }
}

