/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.command;

import com.henny.hennyessentials.command.ModCommands;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.data.objects.CommandToken;
import com.henny.hennyessentials.util.TextUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CommandTokenCommands {
    public static List<LiteralArgumentBuilder<CommandSourceStack>> buildCommandTokenCommands() {
        ArrayList<LiteralArgumentBuilder<CommandSourceStack>> returnList = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();
        LiteralArgumentBuilder tokenCommand = Commands.literal((String)"token");
        LiteralArgumentBuilder giveTokenCommand = Commands.literal((String)"give");
        LiteralArgumentBuilder reloadConfigCommand = Commands.literal((String)"reloadConfig");
        ((LiteralArgumentBuilder)reloadConfigCommand.executes(CommandTokenCommands::executeReloadConfig)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.reloadtokens")));
        tokenCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.token")));
        giveTokenCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.givetoken")));
        giveTokenCommand.then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"token", (ArgumentType)StringArgumentType.string()).suggests(CommandTokenCommands::suggestTokenOptions).then(Commands.argument((String)"isLockedToReceivingPlayer?", (ArgumentType)BoolArgumentType.bool()).executes(CommandTokenCommands::executeGiveToken))).executes(CommandTokenCommands::executeGiveToken)));
        tokenCommand.then((ArgumentBuilder)giveTokenCommand);
        tokenCommand.then((ArgumentBuilder)reloadConfigCommand);
        returnList.add(tokenCommand);
        return returnList;
    }

    private static int executeGiveToken(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
        String tokenName = StringArgumentType.getString(context, (String)"token");
        ItemStack tokenItem = new ItemStack((ItemLike)Items.PAPER);
        boolean isLockedToReceivingPlayer = context.getNodes().stream().map(ParsedCommandNode::getNode).anyMatch(node -> node.getName().equals("isLockedToReceivingPlayer?")) ? BoolArgumentType.getBool(context, (String)"isLockedToReceivingPlayer?") : false;
        ItemStack tokenStack = CommandToken.createTokenItemStack(tokenItem, tokenName, isLockedToReceivingPlayer, targetPlayer);
        targetPlayer.getInventory().add(tokenStack);
        return 1;
    }

    private static int executeReloadConfig(CommandContext<CommandSourceStack> context) {
        ConfigManager.reloadCommandTokens();
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("CommandTokens config reloaded"));
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestTokenOptions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        for (String tokenAlias : ConfigManager.TOKENS.keySet()) {
            builder.suggest(tokenAlias);
        }
        return builder.buildFuture();
    }
}

