/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.command;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.command.ModCommands;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.data.PlayerData;
import com.henny.hennyessentials.data.objects.Condition;
import com.henny.hennyessentials.util.TextUtils;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class ConditionCommands {
    public static List<LiteralArgumentBuilder<CommandSourceStack>> buildConditionCommands() {
        ArrayList<LiteralArgumentBuilder<CommandSourceStack>> returnList = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();
        LiteralArgumentBuilder conditionBase = Commands.literal((String)"condition");
        conditionBase.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.condition")));
        LiteralArgumentBuilder unredeemConditionCommand = Commands.literal((String)"unredeem");
        unredeemConditionCommand.then(Commands.argument((String)"playername", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"conditionID", (ArgumentType)StringArgumentType.string()).suggests(ConditionCommands::suggestConditionIDs).executes(ConditionCommands::executeUnredeemCondition)));
        unredeemConditionCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.condition.unredeem")));
        LiteralArgumentBuilder manualRedeemConditionCommand = Commands.literal((String)"manualredeem");
        manualRedeemConditionCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.condition.manualredeem")));
        manualRedeemConditionCommand.then(Commands.argument((String)"playername", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"conditionID", (ArgumentType)StringArgumentType.string()).suggests(ConditionCommands::suggestConditionIDs).executes(ConditionCommands::executeManualRedeemCondition)));
        LiteralArgumentBuilder reloadConditionsConfigCommand = Commands.literal((String)"reloadconfig");
        reloadConditionsConfigCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.condition.reloadconfig")));
        reloadConditionsConfigCommand.executes(ctx -> {
            ConfigManager.reloadConditionsConfig();
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Conditions reloaded."));
            return 1;
        });
        conditionBase.then((ArgumentBuilder)unredeemConditionCommand);
        conditionBase.then((ArgumentBuilder)manualRedeemConditionCommand);
        conditionBase.then((ArgumentBuilder)reloadConditionsConfigCommand);
        returnList.add(conditionBase);
        return returnList;
    }

    private static int executeUnredeemCondition(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer p = EntityArgument.getPlayer(context, (String)"playername");
        String conditionID = StringArgumentType.getString(context, (String)"conditionID");
        PlayerData.getUserData().updatePlayerInfo(p.getUUID(), conditionID + "-condition", "false");
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatAndHighlight("Player [" + p.getScoreboardName() + "] has had their redeem status for condition [" + conditionID + "] refreshed."));
        return 1;
    }

    private static int executeManualRedeemCondition(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer p = EntityArgument.getPlayer(context, (String)"playername");
        String conditionID = StringArgumentType.getString(context, (String)"conditionID");
        boolean found = false;
        for (Condition condition : ConfigManager.conditions) {
            if (!condition.conditionID.equals(conditionID)) continue;
            found = true;
            for (String cmd : condition.commands) {
                String cmdreplace = cmd.replace("%p", p.getScoreboardName());
                ParseResults parseRes = CommonClass.minecraftServer.getCommands().getDispatcher().parse(cmdreplace, (Object)CommonClass.minecraftServer.createCommandSourceStack());
                CommonClass.minecraftServer.getCommands().getDispatcher().execute(parseRes);
            }
            PlayerData.getUserData().updatePlayerInfo(p.getUUID(), conditionID + "-condition", "true");
        }
        if (found) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatAndHighlight("You have manually redeemed condition [" + conditionID + "] for player [" + p.getScoreboardName() + "]."));
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatAndHighlight("Could not find condition with ID [" + conditionID + "]. Please try again."));
        }
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestConditionIDs(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        for (Condition c : ConfigManager.conditions) {
            builder.suggest(c.conditionID);
        }
        return builder.buildFuture();
    }
}

