/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.command;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.Constants;
import com.henny.hennyessentials.command.ModCommands;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.data.KitData;
import com.henny.hennyessentials.data.PlayerData;
import com.henny.hennyessentials.data.objects.HEPlayer;
import com.henny.hennyessentials.data.objects.Kit;
import com.henny.hennyessentials.menu.KitCreationMenu;
import com.henny.hennyessentials.menu.KitEditMenu;
import com.henny.hennyessentials.menu.KitsMenu;
import com.henny.hennyessentials.permission.Permissions;
import com.henny.hennyessentials.util.TextUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class KitCommands {
    public static List<LiteralArgumentBuilder<CommandSourceStack>> buildKitCommands() {
        ArrayList<LiteralArgumentBuilder<CommandSourceStack>> returnList = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();
        LiteralArgumentBuilder kitCommand = Commands.literal((String)"kit");
        kitCommand.then(Commands.argument((String)"kitName", (ArgumentType)StringArgumentType.word()).suggests(KitCommands::suggestKitOptions).executes(KitCommands::executeGiveKit));
        kitCommand.then(Commands.literal((String)"setCategory").then(Commands.argument((String)"kitName", (ArgumentType)StringArgumentType.word()).suggests(KitCommands::suggestKitOptions).then(((RequiredArgumentBuilder)Commands.argument((String)"kitCategory", (ArgumentType)StringArgumentType.word()).executes(KitCommands::executeSetKitCategory)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.setkitcategory"))))));
        LiteralArgumentBuilder setDisplayIcon = Commands.literal((String)"setDisplayIcon");
        setDisplayIcon.then(Commands.literal((String)"kit").then(((RequiredArgumentBuilder)Commands.argument((String)"kitName", (ArgumentType)StringArgumentType.word()).executes(KitCommands::executeSetKitDisplayIcon)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.setkitdisplay")))));
        setDisplayIcon.then(Commands.literal((String)"category").then(((RequiredArgumentBuilder)Commands.argument((String)"categoryName", (ArgumentType)StringArgumentType.word()).suggests(KitCommands::suggestCategoryOptions).executes(KitCommands::executeSetCategoryDisplayIcon)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.setkitdisplay")))));
        kitCommand.then((ArgumentBuilder)setDisplayIcon);
        LiteralArgumentBuilder createKitCommand = (LiteralArgumentBuilder)Commands.literal((String)"createkit").then(Commands.argument((String)"kitName", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.argument((String)"cooldownSeconds", (ArgumentType)IntegerArgumentType.integer()).executes(KitCommands::executeStartCreateKit)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.createkit")))));
        createKitCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.createkit")));
        LiteralArgumentBuilder deleteKitCommand = (LiteralArgumentBuilder)Commands.literal((String)"deletekit").then(((RequiredArgumentBuilder)Commands.argument((String)"kitName", (ArgumentType)StringArgumentType.word()).executes(KitCommands::executeDeleteKit)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.delkit"))));
        deleteKitCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.delkit")));
        LiteralArgumentBuilder editKitCommand = (LiteralArgumentBuilder)Commands.literal((String)"editkit").then(((RequiredArgumentBuilder)Commands.argument((String)"kitName", (ArgumentType)StringArgumentType.word()).executes(KitCommands::executeStartEditKit)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.editkit"))));
        editKitCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.editkit")));
        LiteralArgumentBuilder listKitsCommand = Commands.literal((String)"kits");
        ((LiteralArgumentBuilder)listKitsCommand.executes(KitCommands::executeListKits)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.listkits")));
        listKitsCommand.then(((RequiredArgumentBuilder)Commands.argument((String)"category", (ArgumentType)StringArgumentType.word()).suggests(KitCommands::suggestCategoryOptions).executes(KitCommands::executeListKits)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.listkits"))));
        returnList.add(createKitCommand);
        returnList.add(deleteKitCommand);
        returnList.add(editKitCommand);
        returnList.add(kitCommand);
        returnList.add(listKitsCommand);
        return returnList;
    }

    private static int executeSetKitDisplayIcon(CommandContext<CommandSourceStack> context) {
        String kitName = StringArgumentType.getString(context, (String)"kitName");
        ItemStack item = ((CommandSourceStack)context.getSource()).getPlayer().getMainHandItem();
        if (item != null && !item.isEmpty() && KitData.getKitData((MinecraftServer)CommonClass.minecraftServer).kits.containsKey(kitName)) {
            KitData.getKitData(((CommandSourceStack)context.getSource()).getServer()).setKitDisplayItem(kitName, item);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Set display icon for kit: " + kitName + " to: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item.getItem()))));
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Error setting display item."));
        }
        return 1;
    }

    private static int executeSetCategoryDisplayIcon(CommandContext<CommandSourceStack> context) {
        String categoryName = StringArgumentType.getString(context, (String)"categoryName");
        ItemStack item = ((CommandSourceStack)context.getSource()).getPlayer().getMainHandItem();
        if (item != null && !item.isEmpty()) {
            KitData.getKitData(((CommandSourceStack)context.getSource()).getServer()).setCategoryDisplayItem(categoryName, item);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Set display icon for kit category: " + categoryName + " to: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item.getItem()))));
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Error setting display item."));
        }
        return 1;
    }

    private static int executeSetKitCategory(CommandContext<CommandSourceStack> context) {
        String kitName = StringArgumentType.getString(context, (String)"kitName");
        String category = StringArgumentType.getString(context, (String)"kitCategory");
        KitData kitData = KitData.getKitData(CommonClass.minecraftServer);
        if (!kitData.kits.containsKey(kitName)) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Couldn't find kit with that name."));
            return 1;
        }
        kitData.kits.get((Object)kitName).category = category;
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Changed kit category to: " + category));
        return 1;
    }

    private static int executeGiveKit(CommandContext<CommandSourceStack> context) {
        Long cooldown;
        long timeLeft;
        boolean canBypassCooldown;
        String kitName = StringArgumentType.getString(context, (String)"kitName");
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        KitData kitData = KitData.getKitData(player.server);
        if (!kitData.kits.containsKey(kitName)) {
            player.sendSystemMessage((Component)TextUtils.formatMessage("Could not find kit with the name: '" + kitName + "'"));
            return 1;
        }
        if (ConfigManager.CONFIG.permissionConfigs.permissionsEnabled && !Permissions.permissionCheck(player.getUUID(), "kit." + kitName, ((CommandSourceStack)context.getSource()).getServer())) {
            player.sendSystemMessage((Component)TextUtils.formatMessage("You do not have the required permission: 'kit." + kitName + "' to redeem this kit."));
            return 1;
        }
        PlayerData allData = PlayerData.getUserData(player.server);
        HEPlayer playerData = allData.HEPlayerData.getOrDefault(player.getUUID(), new HEPlayer());
        boolean bl = canBypassCooldown = ConfigManager.CONFIG.permissionConfigs.permissionsEnabled && Permissions.permissionCheck(player.getUUID(), "kit." + kitName + ".nocooldown", player.server);
        if (playerData != null && !canBypassCooldown && (timeLeft = (cooldown = playerData.kitCooldowns.getOrDefault(kitName, 0L)) - System.currentTimeMillis()) > 0L) {
            player.sendSystemMessage((Component)TextUtils.formatAndHighlight("You need to wait: " + TextUtils.readableDuration(timeLeft) + " before redeeming this kit again."));
            return 1;
        }
        Kit kit = kitData.kits.get(kitName);
        long emptySlots = player.getInventory().items.stream().filter(item -> item.isEmpty()).count();
        if ((long)kit.items.size() <= emptySlots) {
            kit.items.forEach(itemStack -> player.getInventory().add(itemStack.copy()));
            allData.updateKitCooldown(player.getUUID(), kitName, kit.cooldownSeconds);
            if (ConfigManager.CONFIG.commandConfigs.kitConfigs.claimingKitsPlaysSound) {
                player.playNotifySound(SoundEvents.PLAYER_LEVELUP, SoundSource.AMBIENT, 0.5f, 1.0f);
            }
        } else {
            player.sendSystemMessage((Component)TextUtils.formatMessage("You do not have enough free space in your inventory to redeem this kit."));
        }
        return 1;
    }

    public static void giveKitToPlayer(ServerPlayer player, String kitName) {
        Long cooldown;
        long timeLeft;
        boolean canBypassCooldown;
        KitData kitData = KitData.getKitData(player.server);
        if (!kitData.kits.containsKey(kitName)) {
            player.sendSystemMessage((Component)TextUtils.formatMessage("Could not find kit with the name: '" + kitName + "'"));
            return;
        }
        if (ConfigManager.CONFIG.permissionConfigs.permissionsEnabled && !Permissions.permissionCheck(player.getUUID(), "kit." + kitName, CommonClass.minecraftServer)) {
            player.sendSystemMessage((Component)TextUtils.formatMessage("You do not have the required permission: 'kit." + kitName + "' to redeem this kit."));
            return;
        }
        PlayerData allData = PlayerData.getUserData(player.server);
        HEPlayer playerData = allData.HEPlayerData.getOrDefault(player.getUUID(), new HEPlayer());
        boolean bl = canBypassCooldown = ConfigManager.CONFIG.permissionConfigs.permissionsEnabled && Permissions.permissionCheck(player.getUUID(), "kit." + kitName + ".nocooldown", player.server);
        if (playerData != null && !canBypassCooldown && (timeLeft = (cooldown = playerData.kitCooldowns.getOrDefault(kitName, 0L)) - System.currentTimeMillis()) > 0L) {
            player.sendSystemMessage((Component)TextUtils.formatAndHighlight("You need to wait: " + TextUtils.readableDuration(timeLeft) + " before redeeming this kit again."));
            return;
        }
        Kit kit = KitData.getKitData((MinecraftServer)CommonClass.minecraftServer).kits.get(kitName);
        long emptySlots = player.getInventory().items.stream().filter(item -> item.isEmpty()).count();
        if ((long)kit.items.size() <= emptySlots) {
            kit.items.forEach(itemStack -> player.getInventory().add(itemStack.copy()));
            allData.updateKitCooldown(player.getUUID(), kitName, kit.cooldownSeconds);
            if (ConfigManager.CONFIG.commandConfigs.kitConfigs.claimingKitsPlaysSound) {
                player.playNotifySound(SoundEvents.PLAYER_LEVELUP, SoundSource.AMBIENT, 0.5f, 1.0f);
            }
        } else {
            player.sendSystemMessage((Component)TextUtils.formatMessage("You do not have enough free space in your inventory to redeem this kit."));
        }
    }

    private static int executeStartCreateKit(CommandContext<CommandSourceStack> context) {
        String kitName = StringArgumentType.getString(context, (String)"kitName");
        int cooldown = IntegerArgumentType.getInteger(context, (String)"cooldownSeconds");
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, p) -> new KitCreationMenu(id, inv, new SimpleContainer(27), kitName, cooldown), (Component)Component.literal((String)("Creating kit: " + kitName))));
        return 1;
    }

    private static int executeStartEditKit(CommandContext<CommandSourceStack> context) {
        String kitName = StringArgumentType.getString(context, (String)"kitName");
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        KitData kitData = KitData.getKitData(((CommandSourceStack)context.getSource()).getServer());
        if (kitData.kits.containsKey(kitName)) {
            final Kit kit = kitData.kits.get(kitName);
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, p) -> new KitEditMenu(id, inv, new SimpleContainer(27), kitName, (List<ItemStack>)new ArrayList<ItemStack>(){
                {
                    this.addAll(kit.items);
                }
            }), (Component)Component.literal((String)("Editing kit: " + kitName))));
        } else {
            player.sendSystemMessage((Component)TextUtils.formatMessage("Can't find kit with name: " + kitName));
        }
        return 1;
    }

    private static int executeDeleteKit(CommandContext<CommandSourceStack> context) {
        String kitName = StringArgumentType.getString(context, (String)"kitName");
        KitData kitData = KitData.getKitData(((CommandSourceStack)context.getSource()).getServer());
        if (kitData.kits.containsKey(kitName)) {
            kitData.removeKit(kitName);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Kit: " + kitName + " was removed."));
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Could not find kit with name: " + kitName));
        }
        return 1;
    }

    private static int executeListKits(CommandContext<CommandSourceStack> context) {
        if (ConfigManager.CONFIG.commandConfigs.kitConfigs.shouldUseInventoryMenuForKits) {
            KitCommands.openKitsMenu(((CommandSourceStack)context.getSource()).getPlayer());
        } else {
            ArrayList<MutableComponent> kitComponentList = new ArrayList<MutableComponent>();
            MutableComponent title = Component.literal((String)"~ KIT LIST ~").withStyle(ChatFormatting.GREEN);
            for (Map.Entry<String, Kit> entry : KitData.getKitData((MinecraftServer)((CommandSourceStack)context.getSource()).getServer()).kits.entrySet()) {
                Kit kit = entry.getValue();
                Style style = Style.EMPTY.withColor(ChatFormatting.GOLD).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click here to redeem kit: " + kit.name)))).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + ModCommands.BASE_COMMAND_ALIAS + " kit " + kit.name));
                MutableComponent comp = Component.literal((String)("~ " + kit.name)).withStyle(style);
                if (ConfigManager.CONFIG.permissionConfigs.permissionsEnabled) {
                    if (!((CommandSourceStack)context.getSource()).isPlayer() || !Permissions.permissionCheck(((CommandSourceStack)context.getSource()).getPlayer().getUUID(), "kit." + kit.name, ((CommandSourceStack)context.getSource()).getServer())) continue;
                    kitComponentList.add(comp);
                    continue;
                }
                kitComponentList.add(comp);
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)title);
            for (Component component : kitComponentList) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage(component);
            }
        }
        return 1;
    }

    public static ItemStack createCustomPlayerHead(String textureUrl, String displayName) {
        ItemStack head = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        byte[] textureBytes = textureUrl.getBytes();
        UUID uuid = UUID.nameUUIDFromBytes(textureBytes);
        GameProfile profile = new GameProfile(uuid, "name");
        String skinTextureNBT = String.format("{\"textures\":{\"SKIN\":{\"url\":\"http://textures.minecraft.net/texture/%s\"}}}", textureUrl);
        String encodedURL = Base64.getEncoder().encodeToString(skinTextureNBT.getBytes());
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", encodedURL));
        GameProfileCache cache = CommonClass.minecraftServer.getProfileCache();
        if (cache != null) {
            cache.add(profile);
        }
        ResolvableProfile prof = new ResolvableProfile(profile);
        try {
            prof.resolve().thenAccept(resolved -> head.set(DataComponents.PROFILE, resolved));
        }
        catch (Exception e) {
            Constants.LOG.info("Error resolving Game Profile for skull, using default.");
            head.set(DataComponents.PROFILE, (Object)prof);
        }
        if (!displayName.isBlank()) {
            head.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)displayName));
        }
        return head;
    }

    public static void openKitsMenu(ServerPlayer player) {
        SimpleContainer container = new SimpleContainer(90);
        ItemStack i1 = KitCommands.createCustomPlayerHead("45ca82b79198c452e105e9b6eb4da58c6fabd0a30307ea5eb183a9044b567786", "Warp 1");
        ItemStack i2 = KitCommands.createCustomPlayerHead("a7d5eb0aea5d61ba3ff4996416a90096a9d77609ebcd3b308f906ae888a45f6d", "Warp 2");
        ItemStack i3 = KitCommands.createCustomPlayerHead("af334488f13e6a6a4894f33445332641b3e5e112fe0b17ceada6cd514765325b", "Warp 3");
        player.openMenu(new MenuProvider(){

            @Nullable
            public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
                return new KitsMenu(i, inventory, KitData.getKitData(CommonClass.minecraftServer));
            }

            public Component getDisplayName() {
                return Component.literal((String)"Kits Menu");
            }
        });
    }

    private static CompletableFuture<Suggestions> suggestKitOptions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        if (CommonClass.minecraftServer != null) {
            KitData data = KitData.getKitData(CommonClass.minecraftServer);
            for (String kitName : data.kits.keySet()) {
                if (ConfigManager.CONFIG.permissionConfigs.permissionsEnabled) {
                    if (!((CommandSourceStack)context.getSource()).isPlayer() || !Permissions.permissionCheck(((CommandSourceStack)context.getSource()).getPlayer().getUUID(), "kit." + kitName, CommonClass.minecraftServer)) continue;
                    builder.suggest(kitName);
                    continue;
                }
                builder.suggest(kitName);
            }
        }
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> suggestCategoryOptions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        if (CommonClass.minecraftServer != null) {
            KitData data = KitData.getKitData(CommonClass.minecraftServer);
            HashSet<String> categories = new HashSet<String>();
            for (Map.Entry<String, Kit> kit : data.kits.entrySet()) {
                categories.add(kit.getValue().category);
            }
            categories.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }
        return builder.buildFuture();
    }
}

