/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.command;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.command.CommandTokenCommands;
import com.henny.hennyessentials.command.ConditionCommands;
import com.henny.hennyessentials.command.KitCommands;
import com.henny.hennyessentials.command.ModerationCommands;
import com.henny.hennyessentials.command.PageCommands;
import com.henny.hennyessentials.command.PermCommands;
import com.henny.hennyessentials.command.PlayerCommands;
import com.henny.hennyessentials.command.TeleportCommands;
import com.henny.hennyessentials.command.WarpCommands;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.config.objects.MainConfig;
import com.henny.hennyessentials.permission.Permissions;
import com.henny.hennyessentials.util.Pagination;
import com.henny.hennyessentials.util.TextUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;

public class ModCommands {
    public static String BASE_COMMAND_ALIAS = "he";

    public static void register(CommandDispatcher<CommandSourceStack> cmdDispatcher) {
        LiteralArgumentBuilder baseCommand = Commands.literal((String)BASE_COMMAND_ALIAS);
        LiteralArgumentBuilder callback = (LiteralArgumentBuilder)Commands.literal((String)"pcallback").then(Commands.argument((String)"uuid", (ArgumentType)UuidArgument.uuid()).executes(ctx -> {
            UUID uuid = UuidArgument.getUuid((CommandContext)ctx, (String)"uuid");
            if (Pagination.callbackRunnables.containsKey(uuid)) {
                Pagination.callbackRunnables.get(uuid).run();
            }
            return 1;
        }));
        baseCommand.then((ArgumentBuilder)callback);
        ArrayList<LiteralArgumentBuilder<CommandSourceStack>> childCommands = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();
        MainConfig.CommandConfigs commandConfigs = ConfigManager.CONFIG.commandConfigs;
        if (commandConfigs.warpConfigs.warpCommandEnabled) {
            childCommands.addAll(WarpCommands.buildWarpCommands());
        }
        childCommands.addAll(CommandTokenCommands.buildCommandTokenCommands());
        if (commandConfigs.kitConfigs.kitsEnabled) {
            childCommands.addAll(KitCommands.buildKitCommands());
        }
        childCommands.addAll(ModerationCommands.buildModerationCommands());
        childCommands.addAll(PlayerCommands.buildPlayerCommands());
        if (commandConfigs.teleportConfigs.tpaCommandsEnabled) {
            childCommands.addAll(TeleportCommands.buildTeleportCommands());
        }
        if (ConfigManager.CONFIG.permissionConfigs.permissionsEnabled) {
            childCommands.addAll(PermCommands.buildUserPermCommands());
        }
        childCommands.addAll(ConditionCommands.buildConditionCommands());
        childCommands.addAll(PageCommands.buildPageCommands());
        for (LiteralArgumentBuilder literalArgumentBuilder : childCommands) {
            baseCommand.then((ArgumentBuilder)literalArgumentBuilder);
        }
        LiteralArgumentBuilder reloadConfigCmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reloadConfig").executes(ctx -> {
            ConfigManager.reloadHEConfig(true);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("HE Config reloaded"));
            return 1;
        })).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.reloadconfig")))).then(((RequiredArgumentBuilder)Commands.argument((String)"shouldRestartTasks?", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ConfigManager.reloadHEConfig(BoolArgumentType.getBool((CommandContext)context, (String)"shouldRestartTasks?"));
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("HE Config reloaded"));
            ((CommandSourceStack)context.getSource()).getServer().getProfileCache().get(((CommandSourceStack)context.getSource()).getPlayer().getUUID()).get();
            return 1;
        })).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.reloadconfig"))));
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"reloadAnnouncements");
        ((LiteralArgumentBuilder)literalArgumentBuilder.executes(ctx -> {
            ConfigManager.reloadAnnouncements();
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Announcements reloaded."));
            return 1;
        })).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.reloadannouncements")));
        baseCommand.then((ArgumentBuilder)reloadConfigCmd);
        baseCommand.then((ArgumentBuilder)literalArgumentBuilder);
        cmdDispatcher.register(baseCommand);
        ModCommands.registerAliases(cmdDispatcher);
    }

    public static boolean getRequirements(CommandSourceStack commandSourceStack, String permission) {
        if (!ConfigManager.CONFIG.permissionConfigs.permissionsEnabled) {
            return commandSourceStack.hasPermission(2);
        }
        if (ConfigManager.CONFIG.permissionConfigs.luckPermsOverridePermissions && commandSourceStack.isPlayer()) {
            return Permissions.permissionCheck(commandSourceStack.getPlayer().getUUID(), permission, CommonClass.minecraftServer);
        }
        return true;
    }

    public static boolean getRequirements(CommandSourceStack commandSourceStack, List<String> permission) {
        if (!ConfigManager.CONFIG.permissionConfigs.permissionsEnabled) {
            return commandSourceStack.hasPermission(2);
        }
        if (ConfigManager.CONFIG.permissionConfigs.luckPermsOverridePermissions && commandSourceStack.isPlayer()) {
            return Permissions.permissionCheckList(commandSourceStack.getPlayer().getUUID(), permission, CommonClass.minecraftServer);
        }
        return true;
    }

    public static boolean getPlayerRequirements(CommandSourceStack commandSourceStack, String permission) {
        if (!ConfigManager.CONFIG.permissionConfigs.permissionsEnabled) {
            return commandSourceStack.hasPermission(0);
        }
        if (ConfigManager.CONFIG.permissionConfigs.luckPermsOverridePermissions && commandSourceStack.isPlayer()) {
            return Permissions.permissionCheck(commandSourceStack.getPlayer().getUUID(), permission, CommonClass.minecraftServer);
        }
        return true;
    }

    public static boolean getPlayerRequirements(CommandSourceStack commandSourceStack, List<String> permission) {
        if (!ConfigManager.CONFIG.permissionConfigs.permissionsEnabled) {
            return commandSourceStack.hasPermission(0);
        }
        if (ConfigManager.CONFIG.permissionConfigs.luckPermsOverridePermissions && commandSourceStack.isPlayer()) {
            return Permissions.permissionCheckList(commandSourceStack.getPlayer().getUUID(), permission, CommonClass.minecraftServer);
        }
        return true;
    }

    public static void registerAliases(CommandDispatcher<CommandSourceStack> dispatcher) {
        for (Map.Entry<String, List<String>> alias : ConfigManager.CONFIG.aliasConfigs.aliasList.entrySet()) {
            String oldCmd = alias.getKey();
            List<String> aliases = alias.getValue();
            String[] parts = oldCmd.split(" ");
            RootCommandNode root = dispatcher.getRoot();
            CommandNode originalNode = root.getChild(parts[0]);
            if (originalNode == null) continue;
            for (int i = 1; i < parts.length && (originalNode = originalNode.getChild(parts[i])) != null; ++i) {
            }
            if (originalNode == null) continue;
            for (String cmdAlias : aliases) {
                ModCommands.removeExistingCommand(dispatcher, cmdAlias);
                dispatcher.register(ModCommands.createAliasTree((CommandNode<CommandSourceStack>)originalNode, cmdAlias));
            }
        }
    }

    private static void removeExistingCommand(CommandDispatcher<CommandSourceStack> dispatcher, String commandName) {
        try {
            RootCommandNode root = dispatcher.getRoot();
            CommandNode existingCommand = root.getChild(commandName);
            if (existingCommand != null) {
                root.getChildren().remove(existingCommand);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createAliasTree(CommandNode<CommandSourceStack> original, String alias) {
        LiteralArgumentBuilder builder = Commands.literal((String)alias);
        builder.requires(original.getRequirement());
        if (original.getCommand() != null) {
            builder.executes(original.getCommand());
        }
        for (CommandNode child : original.getChildren()) {
            builder.then(ModCommands.cloneNode((CommandNode<CommandSourceStack>)child));
        }
        return builder;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> cloneNode(CommandNode<CommandSourceStack> node) {
        LiteralArgumentBuilder builder;
        if (node instanceof LiteralCommandNode) {
            LiteralCommandNode literal = (LiteralCommandNode)node;
            builder = Commands.literal((String)literal.getLiteral());
        } else if (node instanceof ArgumentCommandNode) {
            ArgumentCommandNode argument;
            ArgumentCommandNode arg = argument = (ArgumentCommandNode)node;
            builder = Commands.argument((String)arg.getName(), (ArgumentType)arg.getType());
        } else {
            throw new IllegalStateException("Unsupported node type: " + String.valueOf(node.getClass()));
        }
        builder.requires(node.getRequirement());
        if (node.getCommand() != null) {
            builder.executes(node.getCommand());
        }
        for (CommandNode child : node.getChildren()) {
            builder.then(ModCommands.cloneNode((CommandNode<CommandSourceStack>)child));
        }
        if (node.getRedirect() != null) {
            builder.redirect(node.getRedirect());
        }
        return builder;
    }
}

