/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.command;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.command.ModCommands;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.config.objects.BannedItemsConfig;
import com.henny.hennyessentials.data.PlayerData;
import com.henny.hennyessentials.data.objects.Ban;
import com.henny.hennyessentials.data.objects.Mute;
import com.henny.hennyessentials.menu.InvseeMenu;
import com.henny.hennyessentials.util.ModerationUtils;
import com.henny.hennyessentials.util.Pagination;
import com.henny.hennyessentials.util.TextUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.LevelResource;

public class ModerationCommands {
    public static List<LiteralArgumentBuilder<CommandSourceStack>> buildModerationCommands() {
        ArrayList<LiteralArgumentBuilder<CommandSourceStack>> returnList = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();
        LiteralArgumentBuilder rulesCommand = Commands.literal((String)"rules");
        rulesCommand.executes(ModerationCommands::executeRules);
        rulesCommand.requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.banitem")));
        returnList.add(rulesCommand);
        LiteralArgumentBuilder broadcastCommand = (LiteralArgumentBuilder)Commands.literal((String)"broadcast").requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.broadcsat")));
        broadcastCommand.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"broadcastString", (ArgumentType)StringArgumentType.string()).executes(ModerationCommands::executeBroadcast)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.broadcsat")))).then(((RequiredArgumentBuilder)Commands.argument((String)"bypassHiddenChat?", (ArgumentType)BoolArgumentType.bool()).executes(ModerationCommands::executeBroadcast)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.broadcsat")))));
        returnList.add(broadcastCommand);
        LiteralArgumentBuilder banCommand = (LiteralArgumentBuilder)Commands.literal((String)"ban").then(Commands.argument((String)"playername", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ModerationCommands::executeBan)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.ban")))));
        banCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.ban")));
        LiteralArgumentBuilder banUUIDCommand = (LiteralArgumentBuilder)Commands.literal((String)"banuuid").then(Commands.argument((String)"playerUUID", (ArgumentType)UuidArgument.uuid()).then(((RequiredArgumentBuilder)Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ModerationCommands::executeBanUUID)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.banuuid")))));
        banUUIDCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.banuuid")));
        LiteralArgumentBuilder tempBanCommand = (LiteralArgumentBuilder)Commands.literal((String)"tempban").then(Commands.argument((String)"playername", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"duration", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ModerationCommands::executeTempBan)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.tempban"))))));
        tempBanCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.tempban")));
        LiteralArgumentBuilder muteCommand = (LiteralArgumentBuilder)Commands.literal((String)"mute").then(Commands.argument((String)"playername", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ModerationCommands::executeMute)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.mute")))));
        muteCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.mute")));
        LiteralArgumentBuilder tempMuteCommand = (LiteralArgumentBuilder)Commands.literal((String)"tempmute").then(Commands.argument((String)"playername", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"duration", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ModerationCommands::executeTempMute)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.tempmute"))))));
        tempMuteCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.tempmute")));
        LiteralArgumentBuilder unmuteCommand = (LiteralArgumentBuilder)Commands.literal((String)"unmute").then(((RequiredArgumentBuilder)Commands.argument((String)"playername", (ArgumentType)StringArgumentType.string()).executes(ModerationCommands::executeUnmute)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.unmute"))));
        unmuteCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.unmute")));
        LiteralArgumentBuilder unbanCommand = (LiteralArgumentBuilder)Commands.literal((String)"unban").then(((RequiredArgumentBuilder)Commands.argument((String)"playername", (ArgumentType)StringArgumentType.string()).executes(ModerationCommands::executeUnban)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.unban"))));
        unbanCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.unban")));
        LiteralArgumentBuilder unbanUUIDCommand = (LiteralArgumentBuilder)Commands.literal((String)"unbanUUID").then(((RequiredArgumentBuilder)Commands.argument((String)"uuid", (ArgumentType)UuidArgument.uuid()).executes(ModerationCommands::executeUnbanUUID)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.unbanuuid"))));
        unbanUUIDCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.unbanuuid")));
        LiteralArgumentBuilder invseeCommand = (LiteralArgumentBuilder)Commands.literal((String)"invsee").then(Commands.argument((String)"playername", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            if (!((CommandSourceStack)ctx.getSource()).isPlayer()) {
                return 1;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayer();
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"playername");
            p.openMenu((MenuProvider)new SimpleMenuProvider((windowId, inv, player) -> new InvseeMenu(windowId, inv, target.getInventory(), false, target.getUUID()), (Component)Component.literal((String)("Inventory of " + target.getGameProfile().getName()))));
            return 1;
        }));
        LiteralArgumentBuilder invseeOfflineCommand = (LiteralArgumentBuilder)Commands.literal((String)"invseeoffline").then(Commands.argument((String)"playername", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            if (!((CommandSourceStack)ctx.getSource()).isPlayer()) {
                return 1;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayer();
            ((CommandSourceStack)ctx.getSource()).getServer().getProfileCache().get(StringArgumentType.getString((CommandContext)ctx, (String)"playername")).ifPresentOrElse(gameProfile -> {
                CompoundTag playerTag;
                Path datfile = CommonClass.minecraftServer.getWorldPath(LevelResource.PLAYER_DATA_DIR).resolve(String.valueOf(gameProfile.getId()) + ".dat");
                try (InputStream is = Files.newInputStream(datfile, new OpenOption[0]);){
                    playerTag = NbtIo.readCompressed((InputStream)is, (NbtAccounter)NbtAccounter.unlimitedHeap());
                }
                catch (IOException e) {
                    ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Error opening player inventory."));
                    return;
                }
                ListTag inventoryList = playerTag.getList("Inventory", 10);
                ServerPlayer sp = new ServerPlayer(CommonClass.minecraftServer, CommonClass.minecraftServer.overworld(), gameProfile, new ClientInformation("en", 1, ChatVisiblity.HIDDEN, false, 0, HumanoidArm.LEFT, false, false));
                sp.getInventory().load(inventoryList);
                p.openMenu((MenuProvider)new SimpleMenuProvider((windowId, inv, player) -> new InvseeMenu(windowId, inv, sp.getInventory(), true, gameProfile.getId()), (Component)Component.literal((String)("Inventory of " + sp.getGameProfile().getName()))));
            }, () -> ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Couldn't find that player")));
            return 1;
        }));
        invseeCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.invsee")));
        invseeOfflineCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.invsee")));
        returnList.add(invseeCommand);
        returnList.add(invseeOfflineCommand);
        LiteralArgumentBuilder banHeldItemCommand = (LiteralArgumentBuilder)Commands.literal((String)"banHeldItem").then(((RequiredArgumentBuilder)Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            ItemStack item = ((CommandSourceStack)context.getSource()).getPlayer().getItemInHand(InteractionHand.MAIN_HAND);
            if (!item.is(Items.AIR)) {
                ConfigManager.bannedItemsConfig.addBannedItems(BuiltInRegistries.ITEM.getKey((Object)((CommandSourceStack)context.getSource()).getPlayer().getItemInHand(InteractionHand.MAIN_HAND).getItem()).toString(), StringArgumentType.getString((CommandContext)context, (String)"reason"));
            } else {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("You cannot ban Air!"));
            }
            return 1;
        })).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.banhelditem"))));
        banHeldItemCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.banhelditem")));
        LiteralArgumentBuilder banItemCommand = (LiteralArgumentBuilder)Commands.literal((String)"banItem").then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)Commands.createValidationContext((HolderLookup.Provider)VanillaRegistries.createLookup()))).then(((RequiredArgumentBuilder)Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            ItemInput item = ItemArgument.getItem((CommandContext)context, (String)"item");
            if (!item.createItemStack(1, false).is(Items.AIR)) {
                ConfigManager.bannedItemsConfig.addBannedItems(BuiltInRegistries.ITEM.getKey((Object)item.getItem()).toString(), StringArgumentType.getString((CommandContext)context, (String)"reason"));
            } else {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("You cannot ban Air!"));
            }
            return 1;
        })).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.banitem")))));
        LiteralArgumentBuilder removeBannedItemCommand = (LiteralArgumentBuilder)Commands.literal((String)"removeBannedItem").then(((RequiredArgumentBuilder)Commands.argument((String)"itemID", (ArgumentType)ItemArgument.item((CommandBuildContext)Commands.createValidationContext((HolderLookup.Provider)VanillaRegistries.createLookup()))).executes(ctx -> {
            ItemInput item = ItemArgument.getItem((CommandContext)ctx, (String)"itemID");
            if (!item.createItemStack(1, false).isEmpty()) {
                String id = BuiltInRegistries.ITEM.getKey((Object)item.getItem()).toString();
                ConfigManager.bannedItemsConfig.removeBannedItems(id);
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)TextUtils.formatAndHighlight("Banned item with ID: [" + id + "] was removed from the Banned Items list."));
            } else {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)TextUtils.formatAndHighlight("Couldn't find that item on the Banned Items list."));
            }
            return 1;
        })).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.removebanneditem"))));
        removeBannedItemCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.removebanneditem")));
        LiteralArgumentBuilder listBannedItemsCommand = Commands.literal((String)"banneditems");
        listBannedItemsCommand.executes(ModerationCommands::executeListBannedItems);
        listBannedItemsCommand.requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.listbanneditems")));
        banItemCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.banitem")));
        returnList.add(banItemCommand);
        returnList.add(banHeldItemCommand);
        returnList.add(removeBannedItemCommand);
        returnList.add(listBannedItemsCommand);
        returnList.add(banCommand);
        returnList.add(banUUIDCommand);
        returnList.add(tempBanCommand);
        returnList.add(muteCommand);
        returnList.add(tempMuteCommand);
        returnList.add(unbanCommand);
        returnList.add(unbanUUIDCommand);
        returnList.add(unmuteCommand);
        return returnList;
    }

    private static int executeBroadcast(CommandContext<CommandSourceStack> ctx) {
        String string = StringArgumentType.getString(ctx, (String)"broadcastString");
        boolean bypass = false;
        boolean hasBypass = ctx.getNodes().stream().anyMatch(node -> node.getNode().getName().equals("bypassHiddenChat?"));
        if (hasBypass) {
            bypass = BoolArgumentType.getBool(ctx, (String)"bypassHiddenChat?");
        }
        CommonClass.minecraftServer.getPlayerList().broadcastSystemMessage((Component)TextUtils.getModPrefix().append((Component)Component.literal((String)string.replace("&", "\u00a7"))), bypass);
        return 1;
    }

    private static int executeRules(CommandContext<CommandSourceStack> ctx) {
        if (!((CommandSourceStack)ctx.getSource()).isPlayer()) {
            return 1;
        }
        ArrayList<MutableComponent> returnComps = new ArrayList<MutableComponent>();
        for (String rule : ConfigManager.CONFIG.moderationConfigs.rulesConfigs.rules) {
            returnComps.add(Component.literal((String)rule));
        }
        new Pagination.PaginationBuilder(((CommandSourceStack)ctx.getSource()).getPlayer(), returnComps).header(ConfigManager.CONFIG.moderationConfigs.rulesConfigs.rulesPageHeader).padding(ConfigManager.CONFIG.moderationConfigs.rulesConfigs.rulesPagePadding).linesPerPage(ConfigManager.CONFIG.moderationConfigs.rulesConfigs.rulesPerPage).build().send();
        return 1;
    }

    private static int executeListBannedItems(CommandContext<CommandSourceStack> ctx) {
        ArrayList<MutableComponent> componentsToSend = new ArrayList<MutableComponent>();
        if (!((CommandSourceStack)ctx.getSource()).isPlayer()) {
            return 1;
        }
        for (Map.Entry<String, BannedItemsConfig.BannedItem> entry : ConfigManager.BANNED_ITEMS_MAP.entrySet()) {
            MutableComponent individualComp = Component.literal((String)"");
            MutableComponent id = Component.literal((String)entry.getKey()).withStyle(ChatFormatting.GREEN);
            MutableComponent separator = Component.literal((String)ConfigManager.CONFIG.moderationConfigs.bannedItemsConfigs.bannedItemsListSeparator);
            MutableComponent reason = Component.literal((String)entry.getValue().reason()).withStyle(ChatFormatting.GREEN);
            individualComp.append((Component)id).append((Component)separator).append((Component)reason);
            componentsToSend.add(individualComp);
        }
        if (!componentsToSend.isEmpty()) {
            new Pagination.PaginationBuilder(((CommandSourceStack)ctx.getSource()).getPlayer(), componentsToSend).header(ConfigManager.CONFIG.moderationConfigs.bannedItemsConfigs.bannedItemsListHeader).linesPerPage(ConfigManager.CONFIG.moderationConfigs.bannedItemsConfigs.bannedItemsPerPage).padding(ConfigManager.CONFIG.moderationConfigs.bannedItemsConfigs.bannedItemsListPadding).build().send();
        }
        return 1;
    }

    private static int executeBan(CommandContext<CommandSourceStack> context) {
        String playerName = StringArgumentType.getString(context, (String)"playername");
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        String reason = StringArgumentType.getString(context, (String)"reason");
        GameProfileCache cache = ((CommandSourceStack)context.getSource()).getServer().getProfileCache();
        if (cache.get(playerName).isPresent()) {
            GameProfile gameprofile = (GameProfile)cache.get(playerName).get();
            UUID uuid = gameprofile.getId();
            for (ServerPlayer next : new ArrayList(server.getPlayerList().getPlayers())) {
                if (!next.getUUID().equals(gameprofile.getId())) continue;
                next.connection.disconnect((Component)Component.literal((String)("You have been banned from this server for: " + reason + "\nThis ban is permanent.")).withStyle(ChatFormatting.RED));
            }
            PlayerData.getUserData(server).updateBanList(new Ban(uuid, reason));
            if (ConfigManager.CONFIG.moderationConfigs.auditConfigs.shouldWriteBansToAuditLog) {
                ModerationUtils.writeToAuditLog("BAN", playerName + " was banned by: " + ((CommandSourceStack)context.getSource()).getTextName());
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessageWithHighlight("Could not locate game profile for user: ", playerName, ". Make sure you have spelled the username corretly."));
        }
        return 1;
    }

    private static int executeBanUUID(CommandContext<CommandSourceStack> context) {
        UUID uuid = UuidArgument.getUuid(context, (String)"playerUUID");
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        String reason = StringArgumentType.getString(context, (String)"reason");
        GameProfileCache cache = ((CommandSourceStack)context.getSource()).getServer().getProfileCache();
        PlayerData.getUserData(server).updateBanList(new Ban(uuid, reason));
        if (ConfigManager.CONFIG.moderationConfigs.auditConfigs.shouldWriteBansToAuditLog) {
            ModerationUtils.writeToAuditLog("BAN", String.valueOf(uuid) + " was banned by: " + ((CommandSourceStack)context.getSource()).getTextName());
        }
        for (ServerPlayer serverPlayer : new ArrayList(server.getPlayerList().getPlayers())) {
            if (!serverPlayer.getUUID().equals(uuid)) continue;
            serverPlayer.connection.disconnect((Component)Component.literal((String)("You have been banned from this server for: " + reason + "\nThis ban is permanent.")));
        }
        return 1;
    }

    private static int executeTempBan(CommandContext<CommandSourceStack> context) {
        String playerName = StringArgumentType.getString(context, (String)"playername");
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        String reason = StringArgumentType.getString(context, (String)"reason");
        String duration = StringArgumentType.getString(context, (String)"duration");
        if (!TextUtils.canBeParsed(duration)) {
            TextUtils.sendParseError((CommandSourceStack)context.getSource(), duration);
            return 1;
        }
        GameProfileCache cache = ((CommandSourceStack)context.getSource()).getServer().getProfileCache();
        if (cache.get(playerName).isPresent()) {
            GameProfile gameprofile = (GameProfile)cache.get(playerName).get();
            UUID uuid = gameprofile.getId();
            long durationMillis = Duration.parse(TextUtils.parseToISO8601(duration)).toMillis();
            long expiry = System.currentTimeMillis() + durationMillis;
            for (ServerPlayer serverPlayer : new ArrayList(server.getPlayerList().getPlayers())) {
                if (!serverPlayer.getUUID().equals(gameprofile.getId())) continue;
                serverPlayer.connection.disconnect((Component)Component.literal((String)("You have been banned from this server for: " + reason + "\nThis ban is will expire in: " + TextUtils.readableDuration(expiry - System.currentTimeMillis()) + ".")).withStyle(ChatFormatting.RED));
            }
            Ban ban = new Ban(uuid, expiry, reason);
            PlayerData.getUserData(server).updateBanList(ban);
            if (ConfigManager.CONFIG.moderationConfigs.auditConfigs.shouldWriteBansToAuditLog) {
                ModerationUtils.writeToAuditLog("TEMPBAN", playerName + " was temp banned for " + TextUtils.readableDuration(expiry - System.currentTimeMillis()) + " by: " + ((CommandSourceStack)context.getSource()).getTextName());
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessageWithHighlight("Could not locate game profile for user: ", playerName, ". Make sure you have spelled the username corretly."));
        }
        return 1;
    }

    private static int executeMute(CommandContext<CommandSourceStack> context) {
        String playerName = StringArgumentType.getString(context, (String)"playername");
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        String reason = StringArgumentType.getString(context, (String)"reason");
        GameProfileCache cache = ((CommandSourceStack)context.getSource()).getServer().getProfileCache();
        if (cache.get(playerName).isPresent()) {
            GameProfile gameprofile = (GameProfile)cache.get(playerName).get();
            UUID uuid = gameprofile.getId();
            server.getPlayerList().getPlayers().forEach(serverPlayer -> {
                if (serverPlayer.getUUID().equals(gameprofile.getId())) {
                    serverPlayer.sendSystemMessage((Component)TextUtils.formatMessageWithHighlight("You have been muted for: ", reason, "."));
                    serverPlayer.sendSystemMessage((Component)TextUtils.formatMessage("Your messages can no longer be seen by others."));
                    ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessageWithHighlight("Player: ", playerName, " has been muted."));
                }
            });
            PlayerData.getUserData(server).updateMuteList(new Mute(uuid, reason));
            if (ConfigManager.CONFIG.moderationConfigs.auditConfigs.shouldWriteMutesToAuditLog) {
                ModerationUtils.writeToAuditLog("MUTE", playerName + " was muted by: " + ((CommandSourceStack)context.getSource()).getTextName());
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessageWithHighlight("Could not locate game profile for user: ", playerName, ". Make sure you have spelled the username correctly."));
        }
        return 1;
    }

    private static int executeTempMute(CommandContext<CommandSourceStack> context) {
        String playerName = StringArgumentType.getString(context, (String)"playername");
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        String reason = StringArgumentType.getString(context, (String)"reason");
        String duration = StringArgumentType.getString(context, (String)"duration");
        if (!TextUtils.canBeParsed(duration)) {
            TextUtils.sendParseError((CommandSourceStack)context.getSource(), duration);
            return 1;
        }
        GameProfileCache cache = ((CommandSourceStack)context.getSource()).getServer().getProfileCache();
        if (cache.get(playerName).isPresent()) {
            GameProfile gameprofile = (GameProfile)cache.get(playerName).get();
            UUID uuid = gameprofile.getId();
            long durationMillis = Duration.parse(TextUtils.parseToISO8601(duration)).toMillis();
            long expiry = System.currentTimeMillis() + durationMillis;
            server.getPlayerList().getPlayers().forEach(serverPlayer -> {
                if (serverPlayer.getUUID().equals(gameprofile.getId())) {
                    serverPlayer.sendSystemMessage((Component)TextUtils.formatMessageWithHighlight("You have been temporarily muted for reason: ", reason, "."));
                    serverPlayer.sendSystemMessage((Component)TextUtils.formatMessageWithHighlight("Your mute will expire in: ", TextUtils.readableDuration(expiry - System.currentTimeMillis()), "."));
                    ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessageWithHighlight("Player: ", playerName, " has been muted."));
                    ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessageWithHighlight("Their mute will expire in: ", TextUtils.readableDuration(expiry - System.currentTimeMillis()), "."));
                }
            });
            Mute mute = new Mute(uuid, expiry, reason);
            PlayerData.getUserData(server).updateMuteList(mute);
            if (ConfigManager.CONFIG.moderationConfigs.auditConfigs.shouldWriteMutesToAuditLog) {
                ModerationUtils.writeToAuditLog("TEMPMUTE", playerName + " was temp muted for " + TextUtils.readableDuration(expiry - System.currentTimeMillis()) + " by: " + ((CommandSourceStack)context.getSource()).getTextName());
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessageWithHighlight("Could not locate game profile for user: ", playerName, ". Make sure you have spelled the username corretly."));
        }
        return 1;
    }

    private static int executeUnmute(CommandContext<CommandSourceStack> context) {
        String playerName = StringArgumentType.getString(context, (String)"playername");
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        GameProfileCache cache = ((CommandSourceStack)context.getSource()).getServer().getProfileCache();
        if (cache.get(playerName).isPresent()) {
            PlayerData.getUserData(server).unmutePlayer(((GameProfile)cache.get(playerName).get()).getId());
            if (ConfigManager.CONFIG.moderationConfigs.auditConfigs.shouldWriteMutesToAuditLog) {
                ModerationUtils.writeToAuditLog("UNMUTE", playerName + " was unmuted by: " + ((CommandSourceStack)context.getSource()).getTextName());
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Player has been unmuted."));
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Error finding game profile for user: " + playerName));
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Could not unmute player."));
        }
        return 1;
    }

    private static int executeUnban(CommandContext<CommandSourceStack> context) {
        String playerName = StringArgumentType.getString(context, (String)"playername");
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        GameProfileCache cache = ((CommandSourceStack)context.getSource()).getServer().getProfileCache();
        if (cache.get(playerName).isPresent()) {
            PlayerData.getUserData(server).unbanPlayer(((GameProfile)cache.get(playerName).get()).getId());
            if (ConfigManager.CONFIG.moderationConfigs.auditConfigs.shouldWriteBansToAuditLog) {
                ModerationUtils.writeToAuditLog("UNBAN", playerName + " was unbanned by: " + ((CommandSourceStack)context.getSource()).getTextName());
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Player has been unbanned."));
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Error finding game profile for user: " + playerName));
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Could not unban player."));
        }
        return 1;
    }

    private static int executeUnbanUUID(CommandContext<CommandSourceStack> context) {
        UUID uuid = UuidArgument.getUuid(context, (String)"uuid");
        PlayerData.getUserData(((CommandSourceStack)context.getSource()).getServer()).unbanPlayer(uuid);
        if (ConfigManager.CONFIG.moderationConfigs.auditConfigs.shouldWriteBansToAuditLog) {
            ModerationUtils.writeToAuditLog("UNBAN", String.valueOf(uuid) + " was unbanned by: " + ((CommandSourceStack)context.getSource()).getTextName());
        }
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Player has been unbanned."));
        return 1;
    }
}

