/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.command;

import com.henny.hennyessentials.command.ModCommands;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.data.objects.ConfigPage;
import com.henny.hennyessentials.util.Pagination;
import com.henny.hennyessentials.util.TextUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class PageCommands {
    public static List<LiteralArgumentBuilder<CommandSourceStack>> buildPageCommands() {
        ArrayList<LiteralArgumentBuilder<CommandSourceStack>> returnList = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();
        LiteralArgumentBuilder pageCommand = Commands.literal((String)"page");
        pageCommand.requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.page")));
        RequiredArgumentBuilder arg = Commands.argument((String)"pageID", (ArgumentType)StringArgumentType.string());
        arg.suggests(PageCommands::suggestPages);
        arg.executes(ctx -> {
            String pageid = StringArgumentType.getString((CommandContext)ctx, (String)"pageID");
            if (!ConfigManager.PAGES.containsKey(pageid)) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)TextUtils.formatAndHighlight("Could not find page with ID: [" + pageid + "]."));
            } else {
                ConfigPage page = ConfigManager.PAGES.get(pageid);
                ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
                for (String line : page.content) {
                    lines.add(Component.literal((String)line));
                }
                new Pagination.PaginationBuilder(((CommandSourceStack)ctx.getSource()).getPlayer(), lines).linesPerPage(page.linesPerPage).header(page.header).padding(page.padding).build().send();
            }
            return 1;
        });
        arg.requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.page")));
        pageCommand.then((ArgumentBuilder)arg);
        LiteralArgumentBuilder reloadPagesConfigCommand = Commands.literal((String)"reloadpages");
        reloadPagesConfigCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.page.reloadconfig")));
        reloadPagesConfigCommand.executes(ctx -> {
            ConfigManager.reloadPagesConfig();
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Pages reloaded."));
            return 1;
        });
        pageCommand.then((ArgumentBuilder)reloadPagesConfigCommand);
        returnList.add(pageCommand);
        return returnList;
    }

    private static CompletableFuture<Suggestions> suggestPages(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        for (String pageID : ConfigManager.PAGES.keySet()) {
            builder.suggest(pageID);
        }
        return builder.buildFuture();
    }
}

