/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.command;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.command.ModCommands;
import com.henny.hennyessentials.data.PermissionGroupData;
import com.henny.hennyessentials.data.PermissionUserData;
import com.henny.hennyessentials.util.TextUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class PermCommands {
    public static List<LiteralArgumentBuilder<CommandSourceStack>> buildUserPermCommands() {
        ArrayList<LiteralArgumentBuilder<CommandSourceStack>> returnList = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();
        LiteralArgumentBuilder permissionBaseCommand = Commands.literal((String)"permission");
        permissionBaseCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "he.permission")));
        LiteralArgumentBuilder verboseCommand = (LiteralArgumentBuilder)Commands.literal((String)"verbose").executes(PermCommands::executeVerbose);
        permissionBaseCommand.then((ArgumentBuilder)verboseCommand);
        LiteralArgumentBuilder permissionUserCommand = Commands.literal((String)"user");
        LiteralArgumentBuilder permissionUUUIDCommand = Commands.literal((String)"uuid");
        LiteralArgumentBuilder permissionGroupCommand = Commands.literal((String)"group");
        LiteralArgumentBuilder prefixGroupGiveCommand = (LiteralArgumentBuilder)Commands.literal((String)"addPrefix").then(Commands.argument((String)"groupname", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.argument((String)"prefix", (ArgumentType)StringArgumentType.greedyString()).executes(PermCommands::executePrefixGiveGroup)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.addgroupprefix")))));
        LiteralArgumentBuilder prefixGroupRemoveCommand = (LiteralArgumentBuilder)Commands.literal((String)"removePrefix").then(((RequiredArgumentBuilder)Commands.argument((String)"groupname", (ArgumentType)StringArgumentType.word()).executes(PermCommands::executeRemovePrefixGroup)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.removegroupprefix"))));
        permissionGroupCommand.then((ArgumentBuilder)prefixGroupGiveCommand);
        permissionGroupCommand.then((ArgumentBuilder)prefixGroupRemoveCommand);
        LiteralArgumentBuilder prefixUserGiveCommand = (LiteralArgumentBuilder)Commands.literal((String)"addPrefix").then(Commands.argument((String)"username", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"prefix", (ArgumentType)StringArgumentType.greedyString()).executes(PermCommands::executePrefixGiveUser)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.adduserprefix")))));
        LiteralArgumentBuilder prefixUserRemoveCommand = (LiteralArgumentBuilder)Commands.literal((String)"removePrefix").then(((RequiredArgumentBuilder)Commands.argument((String)"username", (ArgumentType)EntityArgument.player()).executes(PermCommands::executeRemovePrefixUser)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.removeuserprefix"))));
        permissionUserCommand.then((ArgumentBuilder)prefixUserGiveCommand);
        permissionUserCommand.then((ArgumentBuilder)prefixUserRemoveCommand);
        LiteralArgumentBuilder suffixGroupGiveCommand = (LiteralArgumentBuilder)Commands.literal((String)"addSuffix").then(Commands.argument((String)"groupname", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.argument((String)"suffix", (ArgumentType)StringArgumentType.greedyString()).executes(PermCommands::executeSuffixGiveGroup)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.addgroupsuffix")))));
        LiteralArgumentBuilder suffixGroupRemoveCommand = (LiteralArgumentBuilder)Commands.literal((String)"removeSuffix").then(((RequiredArgumentBuilder)Commands.argument((String)"groupname", (ArgumentType)StringArgumentType.word()).executes(PermCommands::executeRemoveSuffixGroup)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.removegroupsuffix"))));
        permissionGroupCommand.then((ArgumentBuilder)suffixGroupGiveCommand);
        permissionGroupCommand.then((ArgumentBuilder)suffixGroupRemoveCommand);
        LiteralArgumentBuilder suffixUserGiveCommand = (LiteralArgumentBuilder)Commands.literal((String)"addSuffix").then(Commands.argument((String)"username", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"suffix", (ArgumentType)StringArgumentType.greedyString()).executes(PermCommands::executeSuffixGiveUser)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.addusersuffix")))));
        LiteralArgumentBuilder suffixUserRemoveCommand = (LiteralArgumentBuilder)Commands.literal((String)"removeSuffix").then(((RequiredArgumentBuilder)Commands.argument((String)"username", (ArgumentType)EntityArgument.player()).executes(PermCommands::executeRemoveSuffixUser)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.removeusersuffix"))));
        permissionUserCommand.then((ArgumentBuilder)suffixUserGiveCommand);
        permissionUserCommand.then((ArgumentBuilder)suffixUserRemoveCommand);
        LiteralArgumentBuilder permissionUserGiveCommand = (LiteralArgumentBuilder)Commands.literal((String)"add").then(Commands.argument((String)"playername", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"permissionNode", (ArgumentType)StringArgumentType.greedyString()).executes(PermCommands::executePermissionGiveUser)));
        permissionUserGiveCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.adduserperm")));
        permissionUserCommand.then((ArgumentBuilder)permissionUserGiveCommand);
        LiteralArgumentBuilder permissionUUIDGiveCommand = (LiteralArgumentBuilder)Commands.literal((String)"add").then(Commands.argument((String)"playerUUID", (ArgumentType)UuidArgument.uuid()).then(((RequiredArgumentBuilder)Commands.argument((String)"permissionNode", (ArgumentType)StringArgumentType.greedyString()).executes(PermCommands::executePermissionGiveUUID)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.adduuidperm")))));
        permissionUUUIDCommand.then((ArgumentBuilder)permissionUUIDGiveCommand);
        LiteralArgumentBuilder permissionUUIDRemoveCommand = (LiteralArgumentBuilder)Commands.literal((String)"remove").then(Commands.argument((String)"playerUUID", (ArgumentType)UuidArgument.uuid()).then(((RequiredArgumentBuilder)Commands.argument((String)"permissionNode", (ArgumentType)StringArgumentType.greedyString()).executes(PermCommands::executePermissionRemoveUUID)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.removeuuidperm")))));
        permissionUUUIDCommand.then((ArgumentBuilder)permissionUUIDRemoveCommand);
        LiteralArgumentBuilder permissionUserRemoveCommand = (LiteralArgumentBuilder)Commands.literal((String)"remove").then(Commands.argument((String)"playername", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"permissionNode", (ArgumentType)StringArgumentType.greedyString()).executes(PermCommands::executePermissionRemoveUser)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.removeuserperm")))));
        permissionUserCommand.then((ArgumentBuilder)permissionUserRemoveCommand);
        LiteralArgumentBuilder permissionGroupGiveCommand = (LiteralArgumentBuilder)Commands.literal((String)"add").then(Commands.argument((String)"groupName", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.argument((String)"permissionNode", (ArgumentType)StringArgumentType.string()).executes(PermCommands::executePermissionGiveGroup)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.addgroupperm")))));
        permissionGroupCommand.then((ArgumentBuilder)permissionGroupGiveCommand);
        LiteralArgumentBuilder permissionGroupRemoveCommand = (LiteralArgumentBuilder)Commands.literal((String)"remove").then(Commands.argument((String)"groupName", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.argument((String)"permissionNode", (ArgumentType)StringArgumentType.string()).executes(PermCommands::executePermissionRemoveGroup)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.removegroupperm")))));
        permissionGroupCommand.then((ArgumentBuilder)permissionGroupRemoveCommand);
        permissionBaseCommand.then((ArgumentBuilder)permissionUserCommand);
        permissionBaseCommand.then((ArgumentBuilder)permissionGroupCommand);
        permissionBaseCommand.then((ArgumentBuilder)permissionUUUIDCommand);
        returnList.add(permissionBaseCommand);
        return returnList;
    }

    private static int executeInfoUser(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer ply = ((CommandSourceStack)context.getSource()).getPlayer();
        ServerPlayer user = EntityArgument.getPlayer(context, (String)"userName");
        return 1;
    }

    private static int executeVerbose(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer ply = ((CommandSourceStack)context.getSource()).getPlayer();
        if (ply.getTags().contains("hessentials.verbose")) {
            ply.sendSystemMessage((Component)TextUtils.formatMessage("Verbose disabled"));
            ply.removeTag("hessentials.verbose");
        } else {
            ply.sendSystemMessage((Component)TextUtils.formatMessage("Verbose enabled"));
            ply.addTag("hessentials.verbose");
        }
        return 1;
    }

    private static int executePermissionGiveUser(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"playername");
        String permissionNode = StringArgumentType.getString(context, (String)"permissionNode");
        PermissionUserData userPermData = PermissionUserData.getPermissionUserData(((CommandSourceStack)context.getSource()).getServer());
        userPermData.addUserPermission(targetPlayer.getUUID(), permissionNode);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Permission node: " + permissionNode + " added to user: " + targetPlayer.getScoreboardName()));
        return 1;
    }

    private static int executePermissionRemoveUser(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"playername");
        String permissionNode = StringArgumentType.getString(context, (String)"permissionNode");
        PermissionUserData userPermData = PermissionUserData.getPermissionUserData(((CommandSourceStack)context.getSource()).getServer());
        userPermData.removeUserPermission(targetPlayer.getUUID(), permissionNode);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Permission node: " + permissionNode + " removed from user: " + targetPlayer.getScoreboardName()));
        return 1;
    }

    private static int executePermissionGiveUUID(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        UUID targetPlayer = UuidArgument.getUuid(context, (String)"playerUUID");
        String permissionNode = StringArgumentType.getString(context, (String)"permissionNode");
        PermissionUserData userPermData = PermissionUserData.getPermissionUserData(((CommandSourceStack)context.getSource()).getServer());
        userPermData.addUserPermission(targetPlayer, permissionNode);
        AtomicReference<String> pName = new AtomicReference<String>("");
        CommonClass.minecraftServer.getProfileCache().get(targetPlayer).ifPresent(gp -> pName.set(gp.getName()));
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Permission node: " + permissionNode + " added to user: " + (pName.get().isBlank() ? targetPlayer.toString() : pName.get())));
        return 1;
    }

    private static int executePermissionRemoveUUID(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        UUID targetPlayer = UuidArgument.getUuid(context, (String)"playerUUID");
        String permissionNode = StringArgumentType.getString(context, (String)"permissionNode");
        PermissionUserData userPermData = PermissionUserData.getPermissionUserData(((CommandSourceStack)context.getSource()).getServer());
        userPermData.removeUserPermission(targetPlayer, permissionNode);
        AtomicReference<String> pName = new AtomicReference<String>("");
        CommonClass.minecraftServer.getProfileCache().get(targetPlayer).ifPresent(gp -> pName.set(gp.getName()));
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Permission node: " + permissionNode + " removed from user: " + (pName.get().isBlank() ? targetPlayer.toString() : pName.get())));
        return 1;
    }

    private static int executePermissionGiveGroup(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String targetGroup = StringArgumentType.getString(context, (String)"groupName");
        String permissionNode = StringArgumentType.getString(context, (String)"permissionNode");
        PermissionGroupData groupPermData = PermissionGroupData.getPermissionGroupData(((CommandSourceStack)context.getSource()).getServer());
        groupPermData.addGroupPermission(targetGroup, permissionNode);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Permission node: " + permissionNode + " added to group: " + targetGroup));
        return 1;
    }

    private static int executePermissionRemoveGroup(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String targetGroup = StringArgumentType.getString(context, (String)"groupName");
        String permissionNode = StringArgumentType.getString(context, (String)"permissionNode");
        PermissionGroupData groupPermData = PermissionGroupData.getPermissionGroupData(((CommandSourceStack)context.getSource()).getServer());
        groupPermData.removeGroupPermission(targetGroup, permissionNode);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Permission node: " + permissionNode + " removed from group: " + targetGroup));
        return 1;
    }

    private static int executePrefixGiveGroup(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String targetGroup = StringArgumentType.getString(context, (String)"groupname");
        String prefix = StringArgumentType.getString(context, (String)"prefix");
        MutableComponent prefixComponent = Component.literal((String)"");
        prefixComponent = prefix.contains("{") ? Component.Serializer.fromJson((String)prefix, (HolderLookup.Provider)((CommandSourceStack)context.getSource()).getServer().registryAccess()) : Component.literal((String)prefix);
        PermissionGroupData groupPermData = PermissionGroupData.getPermissionGroupData(((CommandSourceStack)context.getSource()).getServer());
        groupPermData.addGroupPrefix(targetGroup, (Component)prefixComponent);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Prefix: ").append(prefix).append((Component)Component.literal((String)(" added to group " + targetGroup)).setStyle(Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.GREEN}))));
        return 1;
    }

    private static int executePrefixGiveUser(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetUser = EntityArgument.getPlayer(context, (String)"username");
        String prefix = StringArgumentType.getString(context, (String)"prefix");
        MutableComponent prefixComponent = Component.literal((String)"");
        prefixComponent = prefix.contains("{") ? Component.Serializer.fromJson((String)prefix, (HolderLookup.Provider)((CommandSourceStack)context.getSource()).getServer().registryAccess()) : Component.literal((String)prefix);
        if (prefixComponent == null) {
            return 1;
        }
        PermissionUserData userPermData = PermissionUserData.getPermissionUserData(((CommandSourceStack)context.getSource()).getServer());
        userPermData.addUserPrefix(targetUser.getUUID(), (Component)prefixComponent);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Prefix: ").append((Component)prefixComponent).append((Component)Component.literal((String)(" added to user " + targetUser.getScoreboardName())).setStyle(Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.GREEN}))));
        return 1;
    }

    private static int executeSuffixGiveGroup(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String targetGroup = StringArgumentType.getString(context, (String)"groupname");
        String suffix = StringArgumentType.getString(context, (String)"suffix");
        MutableComponent suffixComponent = Component.literal((String)"");
        suffixComponent = suffix.contains("{") ? Component.Serializer.fromJson((String)suffix, (HolderLookup.Provider)((CommandSourceStack)context.getSource()).getServer().registryAccess()) : Component.literal((String)suffix);
        if (suffixComponent == null) {
            return 1;
        }
        PermissionGroupData groupPermData = PermissionGroupData.getPermissionGroupData(((CommandSourceStack)context.getSource()).getServer());
        groupPermData.addGroupSuffix(targetGroup, (Component)suffixComponent);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Suffix: ").append((Component)suffixComponent).append((Component)Component.literal((String)(" added to group " + targetGroup)).setStyle(Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.GREEN}))));
        return 1;
    }

    private static int executeSuffixGiveUser(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetUser = EntityArgument.getPlayer(context, (String)"username");
        String suffix = StringArgumentType.getString(context, (String)"suffix");
        MutableComponent suffixComponent = Component.literal((String)"");
        suffixComponent = suffix.contains("{") ? Component.Serializer.fromJson((String)suffix, (HolderLookup.Provider)((CommandSourceStack)context.getSource()).getServer().registryAccess()) : Component.literal((String)suffix);
        if (suffixComponent == null) {
            return 1;
        }
        PermissionUserData userPermData = PermissionUserData.getPermissionUserData(((CommandSourceStack)context.getSource()).getServer());
        userPermData.addUserSuffix(targetUser.getUUID(), (Component)suffixComponent);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Suffix: ").append((Component)suffixComponent).append((Component)Component.literal((String)(" added to user " + targetUser.getScoreboardName())).setStyle(Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.GREEN}))));
        return 1;
    }

    private static int executeRemovePrefixUser(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"username");
        PermissionUserData.getPermissionUserData(((CommandSourceStack)context.getSource()).getServer()).removeUserPrefix(target.getUUID());
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Prefix removed."));
        return 1;
    }

    private static int executeRemoveSuffixUser(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"username");
        PermissionUserData.getPermissionUserData(((CommandSourceStack)context.getSource()).getServer()).removeUserSuffix(target.getUUID());
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Suffix removed."));
        return 1;
    }

    private static int executeRemovePrefixGroup(CommandContext<CommandSourceStack> context) {
        String target = StringArgumentType.getString(context, (String)"groupname");
        PermissionGroupData.getPermissionGroupData(((CommandSourceStack)context.getSource()).getServer()).removeGroupPrefix(target);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Prefix removed."));
        return 1;
    }

    private static int executeRemoveSuffixGroup(CommandContext<CommandSourceStack> context) {
        String target = StringArgumentType.getString(context, (String)"groupname");
        PermissionGroupData.getPermissionGroupData(((CommandSourceStack)context.getSource()).getServer()).removeGroupSuffix(target);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Suffix removed."));
        return 1;
    }
}

