/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.command;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.Constants;
import com.henny.hennyessentials.command.ModCommands;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.config.objects.MainConfig;
import com.henny.hennyessentials.data.PlayerData;
import com.henny.hennyessentials.util.AFKHandler;
import com.henny.hennyessentials.util.TextUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class PlayerCommands {
    public static List<LiteralArgumentBuilder<CommandSourceStack>> buildPlayerCommands() {
        MainConfig.CommandConfigs.PlayerCommandConfigs playerCommandConfigs = ConfigManager.CONFIG.commandConfigs.playerCommandConfigs;
        ArrayList<LiteralArgumentBuilder<CommandSourceStack>> returnList = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();
        LiteralArgumentBuilder vanishCommand = Commands.literal((String)"vanish");
        ((LiteralArgumentBuilder)vanishCommand.executes(PlayerCommands::executeVanish)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.vanish")));
        if (playerCommandConfigs.vanishCommandEnabled) {
            returnList.add(vanishCommand);
        }
        LiteralArgumentBuilder playtimeCommand = Commands.literal((String)"playtime");
        ((LiteralArgumentBuilder)playtimeCommand.executes(ctx -> {
            String duration = TextUtils.readableDuration(TimeUnit.SECONDS.toMillis(Integer.parseInt(PlayerData.getUserData().getPlayerInfoValue(((CommandSourceStack)ctx.getSource()).getPlayer().getUUID(), "playtime"))));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("").append((Component)Component.literal((String)ConfigManager.CONFIG.commandConfigs.playerCommandConfigs.playtimeText.replace("%playtime%", duration))));
            return 1;
        })).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.playtime")));
        returnList.add(playtimeCommand);
        LiteralArgumentBuilder afkCommand = Commands.literal((String)"afk");
        afkCommand.requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.afk")));
        afkCommand.executes(ctx -> {
            if (!((CommandSourceStack)ctx.getSource()).isPlayer()) {
                return 1;
            }
            AFKHandler.markAFK(((CommandSourceStack)ctx.getSource()).getPlayer());
            return 1;
        });
        returnList.add(afkCommand);
        LiteralArgumentBuilder anvilCommand = Commands.literal((String)"anvil");
        anvilCommand.executes(ctx -> {
            if (!((CommandSourceStack)ctx.getSource()).isPlayer()) {
                return 1;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayer();
            p.openMenu((MenuProvider)new SimpleMenuProvider((syncId, playerInventory, playerEntity) -> new AnvilMenu(syncId, playerInventory), (Component)Component.literal((String)"Henny Anvil")));
            return 1;
        });
        anvilCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.anvil")));
        returnList.add(anvilCommand);
        LiteralArgumentBuilder craftingTableCommand = Commands.literal((String)"ctable");
        craftingTableCommand.executes(ctx -> {
            if (!((CommandSourceStack)ctx.getSource()).isPlayer()) {
                return 1;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayer();
            p.openMenu((MenuProvider)new SimpleMenuProvider((syncId, playerInventory, playerEntity) -> new CraftingMenu(syncId, playerInventory), (Component)Component.literal((String)"Henny Crafting")));
            return 1;
        });
        craftingTableCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.craftingtable")));
        returnList.add(craftingTableCommand);
        LiteralArgumentBuilder stonecutterCommand = Commands.literal((String)"stonecutter");
        stonecutterCommand.executes(ctx -> {
            if (!((CommandSourceStack)ctx.getSource()).isPlayer()) {
                return 1;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayer();
            p.openMenu((MenuProvider)new SimpleMenuProvider((syncId, playerInventory, playerEntity) -> new StonecutterMenu(syncId, playerInventory), (Component)Component.literal((String)"Henny Stonecutter")));
            return 1;
        });
        stonecutterCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.stonecutter")));
        returnList.add(stonecutterCommand);
        LiteralArgumentBuilder smithingTableCommand = Commands.literal((String)"smithtable");
        smithingTableCommand.executes(ctx -> {
            if (!((CommandSourceStack)ctx.getSource()).isPlayer()) {
                return 1;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayer();
            p.openMenu((MenuProvider)new SimpleMenuProvider((syncId, playerInventory, playerEntity) -> new SmithingMenu(syncId, playerInventory), (Component)Component.literal((String)"Henny Smithing")));
            return 1;
        });
        smithingTableCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.smithingtable")));
        returnList.add(smithingTableCommand);
        LiteralArgumentBuilder hatCommand = Commands.literal((String)"hat");
        hatCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.user", "command.he.hat")));
        hatCommand.executes(ctx -> {
            if (!((CommandSourceStack)ctx.getSource()).isPlayer()) {
                return 1;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayer();
            ItemStack helm = p.getItemBySlot(EquipmentSlot.HEAD);
            ItemStack main = p.getItemInHand(InteractionHand.MAIN_HAND);
            Constants.LOG.info(helm.getDisplayName().toString());
            if (helm.isEmpty() && !main.isEmpty()) {
                p.setItemSlot(EquipmentSlot.HEAD, main.copyWithCount(1));
                main.shrink(1);
            } else {
                p.sendSystemMessage((Component)TextUtils.formatMessage("Error setting hat. You need to have an empty helmet slot and hold the item you want to set as your hat in your MAIN HAND."));
            }
            return 1;
        });
        returnList.add(hatCommand);
        LiteralArgumentBuilder healCommand = Commands.literal((String)"heal");
        ((LiteralArgumentBuilder)healCommand.executes(PlayerCommands::executeHeal)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.vanish")));
        if (playerCommandConfigs.healCommandEnabled) {
            returnList.add(healCommand);
        }
        LiteralArgumentBuilder feedCommand = Commands.literal((String)"feed");
        ((LiteralArgumentBuilder)feedCommand.executes(PlayerCommands::executeFeed)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.feed")));
        if (playerCommandConfigs.feedCommandEnabled) {
            returnList.add(feedCommand);
        }
        LiteralArgumentBuilder repairCommand = Commands.literal((String)"repair");
        ((LiteralArgumentBuilder)repairCommand.executes(PlayerCommands::executeRepair)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.repair")));
        if (playerCommandConfigs.repairCommandEnabled) {
            returnList.add(repairCommand);
        }
        LiteralArgumentBuilder flyCommand = Commands.literal((String)"fly");
        ((LiteralArgumentBuilder)flyCommand.executes(PlayerCommands::executeFly)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.fly")));
        if (playerCommandConfigs.flyCommandEnabled) {
            returnList.add(flyCommand);
        }
        LiteralArgumentBuilder EChestCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"echest").executes(PlayerCommands::executeEchest)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.echest")));
        LiteralArgumentBuilder viewEChestCommand = (LiteralArgumentBuilder)Commands.literal((String)"viewechest").then(((RequiredArgumentBuilder)Commands.argument((String)"playername", (ArgumentType)EntityArgument.player()).executes(PlayerCommands::executeViewEChest)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.viewechest"))));
        viewEChestCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.viewechest")));
        if (playerCommandConfigs.enderChestCommandEnabled) {
            returnList.add(EChestCommand);
        }
        if (playerCommandConfigs.adminViewPlayerEnderChestCommandEnabled) {
            returnList.add((LiteralArgumentBuilder<CommandSourceStack>)viewEChestCommand);
        }
        return returnList;
    }

    private static int executeEchest(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer p = ((CommandSourceStack)context.getSource()).getPlayer();
        p.openMenu((MenuProvider)new SimpleMenuProvider((syncId, playerInventory, playerEntity) -> ChestMenu.threeRows((int)syncId, (Inventory)playerInventory, (Container)p.getEnderChestInventory()), (Component)Component.translatable((String)"container.enderchest")));
        return 1;
    }

    private static int executeViewEChest(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer tosee = EntityArgument.getPlayer(context, (String)"playername");
        ServerPlayer p = ((CommandSourceStack)context.getSource()).getPlayer();
        p.openMenu((MenuProvider)new SimpleMenuProvider((syncId, playerInventory, playerEntity) -> ChestMenu.threeRows((int)syncId, (Inventory)playerInventory, (Container)tosee.getEnderChestInventory()), (Component)Component.translatable((String)"container.enderchest")));
        return 1;
    }

    private static int executeVanish(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        Holder effect = MobEffects.INVISIBILITY;
        MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.INVISIBILITY, Integer.MAX_VALUE, 1, true, false, true);
        if (player.getTags().contains("he.vanish")) {
            CommonClass.playersInVanish.put(player.getUUID(), false);
            player.removeTag("he.vanish");
            player.setInvisible(false);
            player.removeEffect(effect);
            if (ConfigManager.CONFIG.commandConfigs.vanishConfigs.EXPERIMENTAL_shouldHideVanishedPlayersFromTabList) {
                ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(player));
                for (ServerPlayer p : player.server.getPlayerList().getPlayers()) {
                    p.connection.send((Packet)packet);
                }
            }
            player.sendSystemMessage((Component)TextUtils.formatMessage(ConfigManager.CONFIG.commandConfigs.playerCommandConfigs.vanishText.replace("%b", String.valueOf(false))));
        } else {
            if (ConfigManager.CONFIG.commandConfigs.vanishConfigs.EXPERIMENTAL_shouldHideVanishedPlayersFromTabList) {
                ClientboundPlayerInfoRemovePacket packet = new ClientboundPlayerInfoRemovePacket(List.of(player.getUUID()));
                for (ServerPlayer p : player.server.getPlayerList().getPlayers()) {
                    p.connection.send((Packet)packet);
                }
            }
            AABB box = new AABB(player.getOnPos()).inflate(50.0);
            player.level().getEntitiesOfClass(Mob.class, box).forEach(mob -> {
                if (mob != null && mob.getTarget() != null && mob.getTarget() == player) {
                    mob.setTarget(null);
                }
            });
            player.addEffect(mobEffectInstance);
            player.setInvisible(true);
            player.addTag("he.vanish");
            CommonClass.playersInVanish.put(player.getUUID(), true);
            player.sendSystemMessage((Component)TextUtils.formatMessage(ConfigManager.CONFIG.commandConfigs.playerCommandConfigs.vanishText.replace("%b", String.valueOf(true))));
        }
        return 1;
    }

    private static int executeHeal(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        player.setHealth(player.getMaxHealth());
        player.sendSystemMessage((Component)TextUtils.formatMessage("You have been healed."));
        return 1;
    }

    private static List<Mob> findMobsAround(ServerPlayer player, double radius) {
        AABB box = new AABB(player.getOnPos()).inflate(radius);
        return player.level().getEntitiesOfClass(Mob.class, box);
    }

    private static int executeFeed(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        player.getFoodData().setExhaustion(0.0f);
        player.getFoodData().setFoodLevel(20);
        player.getFoodData().setSaturation(20.0f);
        player.sendSystemMessage((Component)TextUtils.formatMessage("You have been fed."));
        return 1;
    }

    private static int executeRepair(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        ItemStack item = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!item.isEmpty() && item.has(DataComponents.DAMAGE)) {
            item.set(DataComponents.DAMAGE, (Object)0);
            player.sendSystemMessage((Component)TextUtils.formatMessage("Repaired held item."));
        } else {
            TextUtils.formatMessage("Error repairing item");
        }
        return 1;
    }

    private static int executeFly(CommandContext<CommandSourceStack> context) {
        boolean newFlyState;
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        boolean canFly = CommonClass.playersInFly.getOrDefault(player.getUUID(), false);
        boolean bl = !canFly;
        player.getAbilities().mayfly = newFlyState = bl;
        player.getAbilities().flying = newFlyState;
        player.onUpdateAbilities();
        CommonClass.playersInFly.put(player.getUUID(), newFlyState);
        if (newFlyState) {
            player.addTag("he.fly");
        } else {
            player.removeTag("he.fly");
        }
        player.sendSystemMessage((Component)TextUtils.formatMessage(ConfigManager.CONFIG.commandConfigs.playerCommandConfigs.flyText.replace("%b", String.valueOf(newFlyState))));
        return 1;
    }
}

